/*
 * Decompiled with CFR 0.152.
 */
package com.example.veinmine.config;

import com.example.veinmine.VeinMineMod;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.util.HashSet;
import java.util.Set;
import net.fabricmc.loader.api.FabricLoader;

public class VeinMineConfig {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final File CONFIG_FILE = FabricLoader.getInstance().getConfigDir().resolve("veinmine.json").toFile();
    private int maxBlocks = 64;
    private boolean requireSneaking = false;
    private boolean disableWhenSneaking = false;
    private boolean respectEnchantments = true;
    private Set<String> blacklistedBlocks = new HashSet<String>();

    public static VeinMineConfig loadConfig() {
        VeinMineConfig config = new VeinMineConfig();
        if (CONFIG_FILE.exists()) {
            try (FileReader reader = new FileReader(CONFIG_FILE);){
                config = (VeinMineConfig)GSON.fromJson((Reader)reader, VeinMineConfig.class);
                if (config == null) {
                    config = new VeinMineConfig();
                }
            }
            catch (IOException e) {
                VeinMineMod.LOGGER.error("Failed to load config file", (Throwable)e);
            }
        } else {
            config.saveConfig();
        }
        return config;
    }

    public void saveConfig() {
        try {
            CONFIG_FILE.getParentFile().mkdirs();
            try (FileWriter writer = new FileWriter(CONFIG_FILE);){
                GSON.toJson((Object)this, (Appendable)writer);
            }
        }
        catch (IOException e) {
            VeinMineMod.LOGGER.error("Failed to save config file", (Throwable)e);
        }
    }

    public int getMaxBlocks() {
        return this.maxBlocks;
    }

    public void setMaxBlocks(int maxBlocks) {
        this.maxBlocks = maxBlocks;
    }

    public boolean isRequireSneaking() {
        return this.requireSneaking;
    }

    public void setRequireSneaking(boolean requireSneaking) {
        this.requireSneaking = requireSneaking;
    }

    public boolean isDisableWhenSneaking() {
        return this.disableWhenSneaking;
    }

    public void setDisableWhenSneaking(boolean disableWhenSneaking) {
        this.disableWhenSneaking = disableWhenSneaking;
    }

    public boolean isRespectEnchantments() {
        return this.respectEnchantments;
    }

    public void setRespectEnchantments(boolean respectEnchantments) {
        this.respectEnchantments = respectEnchantments;
    }

    public Set<String> getBlacklistedBlocks() {
        return this.blacklistedBlocks;
    }

    public void setBlacklistedBlocks(Set<String> blacklistedBlocks) {
        this.blacklistedBlocks = blacklistedBlocks;
    }
}

