/*
 * Decompiled with CFR 0.152.
 */
package com.example.veinmine.mining;

import com.example.veinmine.mining.MiningMode;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_3222;

public class MiningHandler {
    private static final int MAX_BLOCKS = 64;

    public static List<class_2338> findBlocksToMine(class_1937 world, class_2338 startPos, class_2248 targetBlock, MiningMode mode, class_3222 player) {
        return switch (mode) {
            default -> throw new MatchException(null, null);
            case MiningMode.VEIN -> MiningHandler.findVeinBlocks(world, startPos, targetBlock);
            case MiningMode.TUNNEL_3X3 -> MiningHandler.findTunnel3x3Blocks(world, startPos, player);
            case MiningMode.EXCAVATE_5X5 -> MiningHandler.findExcavate5x5Blocks(world, startPos, player);
            case MiningMode.STAIRCASE -> MiningHandler.findStaircaseBlocks(world, startPos, player);
            case MiningMode.BRANCH_MINE -> MiningHandler.findBranchMineBlocks(world, startPos, player);
            case MiningMode.SHAFT -> MiningHandler.findShaftBlocks(world, startPos);
        };
    }

    private static class_2350 getPlayerFacingDirection(class_3222 player) {
        class_243 lookDirection = player.method_5828(1.0f);
        return class_2350.method_10142((double)lookDirection.field_1352, (double)0.0, (double)lookDirection.field_1350);
    }

    private static List<class_2338> findVeinBlocks(class_1937 world, class_2338 startPos, class_2248 targetBlock) {
        HashSet<class_2338> visited = new HashSet<class_2338>();
        LinkedList<class_2338> queue = new LinkedList<class_2338>();
        ArrayList<class_2338> result = new ArrayList<class_2338>();
        queue.add(startPos);
        visited.add(startPos);
        while (!queue.isEmpty() && result.size() < 64) {
            class_2338 pos = (class_2338)queue.poll();
            result.add(pos);
            for (class_2350 direction : class_2350.values()) {
                class_2680 adjacentState;
                class_2338 adjacentPos = pos.method_10093(direction);
                if (visited.contains(adjacentPos) || (adjacentState = world.method_8320(adjacentPos)).method_26204() != targetBlock) continue;
                queue.add(adjacentPos);
                visited.add(adjacentPos);
            }
        }
        result.remove(0);
        return result;
    }

    private static List<class_2338> findTunnel3x3Blocks(class_1937 world, class_2338 startPos, class_3222 player) {
        ArrayList<class_2338> result = new ArrayList<class_2338>();
        class_2350 facing = MiningHandler.getPlayerFacingDirection(player);
        for (int depth = 1; depth <= 5; ++depth) {
            class_2338 basePos = startPos.method_10079(facing, depth);
            for (int side = -1; side <= 1; ++side) {
                for (int vertical = -1; vertical <= 1; ++vertical) {
                    class_2338 pos = facing == class_2350.field_11043 || facing == class_2350.field_11035 ? basePos.method_10069(side, vertical, 0) : basePos.method_10069(0, vertical, side);
                    if (pos.equals((Object)startPos) || world.method_8320(pos).method_26204() == class_2246.field_10124) continue;
                    result.add(pos);
                }
            }
        }
        return result;
    }

    private static List<class_2338> findExcavate5x5Blocks(class_1937 world, class_2338 startPos, class_3222 player) {
        ArrayList<class_2338> result = new ArrayList<class_2338>();
        for (int x = -2; x <= 2; ++x) {
            for (int y = -1; y <= 1; ++y) {
                for (int z = -2; z <= 2; ++z) {
                    class_2338 pos;
                    if (x == 0 && y == 0 && z == 0 || world.method_8320(pos = startPos.method_10069(x, y, z)).method_26204() == class_2246.field_10124) continue;
                    result.add(pos);
                }
            }
        }
        return result;
    }

    private static List<class_2338> findStaircaseBlocks(class_1937 world, class_2338 startPos, class_3222 player) {
        ArrayList<class_2338> result = new ArrayList<class_2338>();
        class_2350 facing = MiningHandler.getPlayerFacingDirection(player);
        for (int step = 1; step <= 8; ++step) {
            class_2338 headroomPos;
            class_2338 stepPos = startPos.method_10079(facing, step).method_10087(step);
            if (world.method_8320(stepPos).method_26204() != class_2246.field_10124) {
                result.add(stepPos);
            }
            if (world.method_8320(headroomPos = stepPos.method_10084()).method_26204() == class_2246.field_10124) continue;
            result.add(headroomPos);
        }
        return result;
    }

    private static List<class_2338> findBranchMineBlocks(class_1937 world, class_2338 startPos, class_3222 player) {
        ArrayList<class_2338> result = new ArrayList<class_2338>();
        class_2350 facing = MiningHandler.getPlayerFacingDirection(player);
        class_2350 left = facing.method_10160();
        class_2350 right = facing.method_10170();
        for (int depth = 1; depth <= 6; ++depth) {
            class_2338 headroom;
            class_2338 pos = startPos.method_10079(facing, depth);
            if (world.method_8320(pos).method_26204() != class_2246.field_10124) {
                result.add(pos);
            }
            if (world.method_8320(headroom = pos.method_10084()).method_26204() == class_2246.field_10124) continue;
            result.add(headroom);
        }
        for (int mainStep = 3; mainStep <= 6; mainStep += 3) {
            int sideStep;
            class_2338 branchStart = startPos.method_10079(facing, mainStep);
            for (sideStep = 1; sideStep <= 3; ++sideStep) {
                class_2338 leftHeadroom;
                class_2338 leftPos = branchStart.method_10079(left, sideStep);
                if (world.method_8320(leftPos).method_26204() != class_2246.field_10124) {
                    result.add(leftPos);
                }
                if (world.method_8320(leftHeadroom = leftPos.method_10084()).method_26204() == class_2246.field_10124) continue;
                result.add(leftHeadroom);
            }
            for (sideStep = 1; sideStep <= 3; ++sideStep) {
                class_2338 rightHeadroom;
                class_2338 rightPos = branchStart.method_10079(right, sideStep);
                if (world.method_8320(rightPos).method_26204() != class_2246.field_10124) {
                    result.add(rightPos);
                }
                if (world.method_8320(rightHeadroom = rightPos.method_10084()).method_26204() == class_2246.field_10124) continue;
                result.add(rightHeadroom);
            }
        }
        return result;
    }

    private static List<class_2338> findShaftBlocks(class_1937 world, class_2338 startPos) {
        ArrayList<class_2338> result = new ArrayList<class_2338>();
        for (int depth = 1; depth <= 10; ++depth) {
            for (int x = 0; x <= 1; ++x) {
                for (int z = 0; z <= 1; ++z) {
                    class_2338 pos = startPos.method_10069(x, -depth, z);
                    if (world.method_8320(pos).method_26204() == class_2246.field_10124) continue;
                    result.add(pos);
                }
            }
        }
        return result;
    }
}

