/*
 * Decompiled with CFR 0.152.
 */
package com.example.veinmine.network;

import com.example.veinmine.VeinMineMod;
import com.example.veinmine.mining.MiningMode;
import com.example.veinmine.network.ModeSwitchPayload;
import com.example.veinmine.network.VeinMineActivationPayload;
import com.example.veinmine.network.VeinMineStatePayload;
import net.fabricmc.fabric.api.networking.v1.PayloadTypeRegistry;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_3222;

public class VeinMineServerNetworking {
    public static void registerReceivers() {
        PayloadTypeRegistry.playC2S().register(VeinMineActivationPayload.ID, VeinMineActivationPayload.CODEC);
        PayloadTypeRegistry.playC2S().register(ModeSwitchPayload.ID, ModeSwitchPayload.CODEC);
        PayloadTypeRegistry.playC2S().register(VeinMineStatePayload.ID, VeinMineStatePayload.CODEC);
        ServerPlayNetworking.registerGlobalReceiver(VeinMineActivationPayload.ID, (payload, context) -> {
            class_3222 player = context.player();
            MiningMode mode = payload.mode();
            context.server().execute(() -> {
                VeinMineMod.setVeinMineActive(player, true);
                VeinMineMod.setPlayerMode(player, mode);
            });
        });
        ServerPlayNetworking.registerGlobalReceiver(ModeSwitchPayload.ID, (payload, context) -> {
            class_3222 player = context.player();
            MiningMode newMode = payload.mode();
            context.server().execute(() -> VeinMineMod.setPlayerMode(player, newMode));
        });
        ServerPlayNetworking.registerGlobalReceiver(VeinMineStatePayload.ID, (payload, context) -> {
            class_3222 player = context.player();
            boolean active = payload.active();
            MiningMode mode = payload.mode();
            context.server().execute(() -> {
                VeinMineMod.setVeinMineActive(player, active);
                VeinMineMod.setPlayerMode(player, mode);
            });
        });
    }
}

