/*
 * Decompiled with CFR 0.152.
 */
package com.example.veinmine.util;

import java.util.Set;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2680;

public class SmartMiningHelper {
    private static final Set<class_2248> VALUABLE_BLOCKS = Set.of(class_2246.field_10442, class_2246.field_29029, class_2246.field_10013, class_2246.field_29220, class_2246.field_10571, class_2246.field_29026, class_2246.field_23077, class_2246.field_10212, class_2246.field_29027, class_2246.field_27120, class_2246.field_29221, class_2246.field_10080, class_2246.field_29030, class_2246.field_10090, class_2246.field_29028, class_2246.field_10418, class_2246.field_29219, class_2246.field_22109, class_2246.field_10213);
    private static final Set<class_2248> DANGEROUS_BLOCKS = Set.of(class_2246.field_9987, class_2246.field_10540, class_2246.field_22423, class_2246.field_10260, class_2246.field_10164, class_2246.field_10382, class_2246.field_10375, class_2246.field_23152);

    public static boolean isValuableBlock(class_2248 block) {
        return VALUABLE_BLOCKS.contains(block);
    }

    public static boolean isDangerousBlock(class_2248 block) {
        return DANGEROUS_BLOCKS.contains(block);
    }

    public static boolean hasValuableBlocksNearby(class_1937 world, class_2338 center) {
        for (int x = -2; x <= 2; ++x) {
            for (int y = -2; y <= 2; ++y) {
                for (int z = -2; z <= 2; ++z) {
                    class_2338 pos = center.method_10069(x, y, z);
                    class_2680 state = world.method_8320(pos);
                    if (!SmartMiningHelper.isValuableBlock(state.method_26204())) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public static int getMiningPriority(class_2248 block) {
        if (block == class_2246.field_10442 || block == class_2246.field_29029) {
            return 10;
        }
        if (block == class_2246.field_10013 || block == class_2246.field_29220) {
            return 9;
        }
        if (block == class_2246.field_22109) {
            return 8;
        }
        if (block == class_2246.field_10571 || block == class_2246.field_29026 || block == class_2246.field_23077) {
            return 7;
        }
        if (block == class_2246.field_10212 || block == class_2246.field_29027) {
            return 6;
        }
        if (block == class_2246.field_10080 || block == class_2246.field_29030) {
            return 5;
        }
        if (block == class_2246.field_10090 || block == class_2246.field_29028) {
            return 4;
        }
        if (block == class_2246.field_27120 || block == class_2246.field_29221) {
            return 3;
        }
        if (block == class_2246.field_10418 || block == class_2246.field_29219) {
            return 2;
        }
        if (block == class_2246.field_10213) {
            return 2;
        }
        return 1;
    }
}

