/*
 * Decompiled with CFR 0.152.
 */
package com.example.chainmining.config;

import net.minecraftforge.common.ForgeConfigSpec;

public class ChainMiningConfig {
    public static final ForgeConfigSpec.Builder BUILDER = new ForgeConfigSpec.Builder();
    public static final ForgeConfigSpec SPEC;
    public static final ForgeConfigSpec.IntValue MAX_BLOCKS_PER_OPERATION;
    public static final ForgeConfigSpec.DoubleValue MIN_BLOCK_HARDNESS;
    public static final ForgeConfigSpec.DoubleValue MAX_BLOCK_HARDNESS;
    public static final ForgeConfigSpec.BooleanValue REQUIRE_CORRECT_TOOL;
    public static final ForgeConfigSpec.BooleanValue DAMAGE_TOOL_PER_BLOCK;

    static {
        BUILDER.push("Chain Mining Settings");
        MAX_BLOCKS_PER_OPERATION = BUILDER.comment("Maximum number of blocks that can be mined in one operation").defineInRange("maxBlocksPerOperation", 64, 1, 512);
        MIN_BLOCK_HARDNESS = BUILDER.comment("Minimum hardness for blocks to be mineable (negative means unbreakable)").defineInRange("minBlockHardness", -1.0, -1.0, 100.0);
        MAX_BLOCK_HARDNESS = BUILDER.comment("Maximum hardness for blocks to be mineable").defineInRange("maxBlockHardness", 50.0, -1.0, 100.0);
        REQUIRE_CORRECT_TOOL = BUILDER.comment("Whether to require correct tool type for vein mining").define("requireCorrectTool", true);
        DAMAGE_TOOL_PER_BLOCK = BUILDER.comment("Whether to damage tool for each block mined").define("damageToolPerBlock", true);
        BUILDER.pop();
        SPEC = BUILDER.build();
    }
}

