/*
 * Decompiled with CFR 0.152.
 */
package com.example.chainmining.network;

import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.event.network.CustomPayloadEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class InventoryCollectPacket {
    private static final Logger LOGGER = LogManager.getLogger();
    private final boolean isEnabled;

    public InventoryCollectPacket(boolean isEnabled) {
        this.isEnabled = isEnabled;
    }

    public static void encode(InventoryCollectPacket packet, FriendlyByteBuf buffer) {
        buffer.writeBoolean(packet.isEnabled);
    }

    public static InventoryCollectPacket decode(FriendlyByteBuf buffer) {
        return new InventoryCollectPacket(buffer.readBoolean());
    }

    public static void handle(InventoryCollectPacket packet, CustomPayloadEvent.Context context) {
        ServerPlayer player = context.getSender();
        if (player != null) {
            context.enqueueWork(() -> {
                player.getPersistentData().putBoolean("inventoryCollectEnabled", packet.isEnabled);
                LOGGER.info("ChainMining: Set inventoryCollectEnabled to {} for player {}", (Object)packet.isEnabled, (Object)player.getName().getString());
            });
        }
        context.setPacketHandled(true);
    }

    public boolean isEnabled() {
        return this.isEnabled;
    }
}

