/*
 * Decompiled with CFR 0.152.
 */
package com.example.chainmining.network;

import com.example.chainmining.mining.MiningMode;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.event.network.CustomPayloadEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class MiningModePacket {
    private static final Logger LOGGER = LogManager.getLogger();
    private final MiningMode mode;

    public MiningModePacket(MiningMode mode) {
        this.mode = mode;
    }

    public static void encode(MiningModePacket packet, FriendlyByteBuf buffer) {
        buffer.writeEnum((Enum)packet.mode);
    }

    public static MiningModePacket decode(FriendlyByteBuf buffer) {
        return new MiningModePacket((MiningMode)buffer.readEnum(MiningMode.class));
    }

    public static void handle(MiningModePacket packet, CustomPayloadEvent.Context context) {
        ServerPlayer player = context.getSender();
        if (player != null) {
            context.enqueueWork(() -> {
                player.getPersistentData().putString("currentMiningMode", packet.mode.name());
                LOGGER.info("ChainMining: Set currentMiningMode to {} for player {}", (Object)packet.mode.name(), (Object)player.getName().getString());
            });
        }
        context.setPacketHandled(true);
    }

    public MiningMode getMode() {
        return this.mode;
    }
}

