/*
 * Decompiled with CFR 0.152.
 */
package com.example.chainmining.network;

import com.example.chainmining.network.InventoryCollectPacket;
import com.example.chainmining.network.MiningModePacket;
import com.example.chainmining.network.VeinMiningKeyPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.network.ChannelBuilder;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.network.SimpleChannel;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class NetworkHandler {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final String PROTOCOL_VERSION = "1";
    public static final SimpleChannel INSTANCE = ChannelBuilder.named((ResourceLocation)ResourceLocation.tryBuild((String)"chainmining", (String)"main")).optional().networkProtocolVersion(Integer.parseInt("1")).clientAcceptedVersions((status, version) -> version == Integer.parseInt(PROTOCOL_VERSION)).serverAcceptedVersions((status, version) -> version == Integer.parseInt(PROTOCOL_VERSION)).simpleChannel();

    public static void init() {
        LOGGER.info("ChainMining: Initializing network handler with protocol version {}", (Object)PROTOCOL_VERSION);
        INSTANCE.messageBuilder(VeinMiningKeyPacket.class).encoder(VeinMiningKeyPacket::encode).decoder(VeinMiningKeyPacket::decode).consumerMainThread(VeinMiningKeyPacket::handle).add();
        INSTANCE.messageBuilder(MiningModePacket.class).encoder(MiningModePacket::encode).decoder(MiningModePacket::decode).consumerMainThread(MiningModePacket::handle).add();
        INSTANCE.messageBuilder(InventoryCollectPacket.class).encoder(InventoryCollectPacket::encode).decoder(InventoryCollectPacket::decode).consumerMainThread(InventoryCollectPacket::handle).add();
        LOGGER.info("ChainMining: Network handler initialized successfully");
    }

    public static void sendToServer(VeinMiningKeyPacket packet) {
        LOGGER.debug("ChainMining: Sending VeinMiningKeyPacket to server: {}", (Object)packet.isKeyPressed());
        INSTANCE.send((Object)packet, PacketDistributor.SERVER.noArg());
    }

    public static void sendToServer(MiningModePacket packet) {
        LOGGER.debug("ChainMining: Sending MiningModePacket to server: {}", (Object)packet.getMode());
        INSTANCE.send((Object)packet, PacketDistributor.SERVER.noArg());
    }

    public static void sendToServer(InventoryCollectPacket packet) {
        LOGGER.debug("ChainMining: Sending InventoryCollectPacket to server: {}", (Object)packet.isEnabled());
        INSTANCE.send((Object)packet, PacketDistributor.SERVER.noArg());
    }
}

