/*
 * Decompiled with CFR 0.152.
 */
package com.example.chainmining.network;

import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.event.network.CustomPayloadEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class VeinMiningKeyPacket {
    private static final Logger LOGGER = LogManager.getLogger();
    private final boolean isKeyPressed;

    public VeinMiningKeyPacket(boolean isKeyPressed) {
        this.isKeyPressed = isKeyPressed;
    }

    public static void encode(VeinMiningKeyPacket packet, FriendlyByteBuf buffer) {
        buffer.writeBoolean(packet.isKeyPressed);
    }

    public static VeinMiningKeyPacket decode(FriendlyByteBuf buffer) {
        return new VeinMiningKeyPacket(buffer.readBoolean());
    }

    public static void handle(VeinMiningKeyPacket packet, CustomPayloadEvent.Context context) {
        ServerPlayer player = context.getSender();
        if (player != null) {
            context.enqueueWork(() -> {
                player.getPersistentData().putBoolean("veinMiningKeyPressed", packet.isKeyPressed);
                LOGGER.info("ChainMining: Set veinMiningKeyPressed to {} for player {}", (Object)packet.isKeyPressed, (Object)player.getName().getString());
            });
        }
        context.setPacketHandled(true);
    }

    public boolean isKeyPressed() {
        return this.isKeyPressed;
    }
}

