importPackage(java.awt);
importPackage(java.awt.geom);

include(Resources.id("mtrsteamloco:scripts/display_helper.js"));
const toDepot = "BOO!"

let slotCfg = {
    version: 1,
    texSize: [796, 128],
    slots: [
        {
            name: 'head',
            texArea: [0, 0, 796, 128],
            pos: [
                [
                    [-1.1687, 2.8338, 10.0506],
                    [-1.1687, 2.6961, 10.0947],
                    [-0.2703, 2.6961, 10.0947],
                    [-0.2703, 2.8338, 10.0506],
                ],
            ],
            offsets: [[0, 0, 0]]}

    ]
};

let slotCfg2 = {
    version: 1,
    texSize: [796, 128],
    slots: [
        {
            name: 'head',
            texArea: [0, 0, 796, 128],
            pos: [
                [
                    [0.2703, 2.8338, 10.0506],
                    [0.2703, 2.6961, 10.0947],
                    [1.1687, 2.6961, 10.0947],
                    [1.1687, 2.8338, 10.0506],
                ],
            ],
            offsets: [[0, 0, 0]]}

    ]
};

let slotHeadScreenCfg = {
    version: 1,
    texSize: [1565, 256],
    slots: [
        {
            name: 'screenfront',
            texArea: [0, 0, 1565, 256],
            pos: [
                [
                    [-0.1808, 3.13, 1.8373],
                    [-0.1808, 2.9782, 1.8373],
                    [-1.1083, 2.9782, 1.8373],
                    [-1.1083, 3.13, 1.8373]
                ],
            ],
            offsets: [[0, 0, 0]]},
       {
            name: 'screenback',
            texArea: [0, 0, 1565, 256],
            pos: [
                [
                    [-0.4637, 3.13, -7.8751],
                    [-0.4637, 2.9782, -7.8751],
                    [0.4637, 2.9782, -7.8751],
                    [0.4637, 3.13, -7.8751]
                ],
            ],
            offsets: [[0, 0, 0]]}
    ]
};

let slotPromScreenCfg = {
    version: 1,
    texSize: [1565, 256],
    slots: [
        {
            name: 'screenfront',
            texArea: [0, 0, 1565, 256],
            pos: [
                [
                    [0.4637, 3.13, 7.8751],
                    [0.4637, 2.9782, 7.8751],
                    [-0.4637, 2.9782, 7.8751],
                    [-0.4637, 3.13, 7.8751]
                ],
            ],
            offsets: [[0, 0, 0]]},
       {
            name: 'screenback',
            texArea: [0, 0, 1565, 256],
            pos: [
                [
                    [-0.4637, 3.13, -7.8751],
                    [-0.4637, 2.9782, -7.8751],
                    [0.4637, 2.9782, -7.8751],
                    [0.4637, 3.13, -7.8751]
                ],
            ],
            offsets: [[0, 0, 0]]}
    ]
};

var fontpered = Resources.readFont(Resources.idRelative("mtr:font/ed4m.ttf"));
var fontscreentext = Resources.readFont(Resources.idRelative("mtr:font/ep2d-begushchaia-stroka.ttf"));
const maxTickDispConst = 800;
const maxTickDispConst2 = 200;
const daylist = ['вс', 'пн', 'вт', 'ср', 'чт', 'пт', 'сб'];
const mounthlist = ['янв.', 'февр.', 'марта', 'апр.', 'мая', 'июня', 'июля', 'авг.', 'сент.', 'окт.', 'нояб.', 'дек.'];
const weatherlist = ['-6', '-4', '+1', '+10', '+18', '+22', '+25', '+24', '+17', '+9', '+2', '-3'];
const begstr23 = "ЦППК приглашает на работу на должность 'Контролер-кассир', зарплата от 40000 рублей. По вопросам обращаться по номеру 8 (800) 301-00-00.";
const begstr24 = "Подписывайтесь на соц сети NV и RuMTR. Следите за новостями сервера и разработки паков.";
let dhBase = new DisplayHelper(slotCfg);
let dhBase2 = new DisplayHelper(slotCfg2);
let dhHeadScreenBase = new DisplayHelper(slotHeadScreenCfg);
let dhPromScreenBase = new DisplayHelper(slotPromScreenCfg);

function create(ctx, state, train) {
	state.dh = dhBase.create();
	state.dh2 = dhBase2.create();
	state.dhHeadScreen = dhHeadScreenBase.create();
	state.dhPromScreen = dhPromScreenBase.create();
	state.rate = new RateLimit(0.07);
	state.dxscreen = 0;
	state.displTick = 0;
	state.displTick2 = 0;
	state.stationTick = 0;
	state.postCreateFunctionCalled = false;
	state.tekline = ""
	state.firstcalledthisstation = false;
	state.firstcalledthisstationstart = false;
	state.numbermesbegstr = 1;

	drawDispl(state, train)
}

function dispose(ctx, state, train) {
	if (state.dh != null) {
		state.dh.close();
	}
	if (state.dh2 != null) {
		state.dh2.close();
	}
}

function render(ctx, state, train) {
	//renderDispl(ctx, state, train); // неиспользуется из-за того, что вагон качается, а дисплей нет.
	updateDispl(ctx, state, train);
}

function setPostcreateInfo(ctx, state, train) {
	if (!state.postCreateFunctionCalled) {
		
		if (train.siding() == null) {
			return;
		}
		if (train.siding().name.includes('|')) {
		state.infoArr = train.siding().name.split('\\|');
		state.postCreateFunctionCalled = true;
		}
	}
}

function updateDispl(ctx, state, train){
	if (state.rate.shouldUpdate()){
		updateEmuStrings(state, train);
		drawDispl(state, train);
		//updateTick(state, train);
	}
}

function updateEmuStrings(state, train) {
  if (train.getThisRoutePlatforms().size() != 0) {
    state.isOnRoute = true;
  } else {
    state.isOnRoute = false
  }
}

function drawDispl(state, train){
        let EMUText = ""
	let date = new Date();
	let hours = date.getUTCHours() + 3;
	let minutes = date.getMinutes();
	if (hours > 23) hours = hours - 24 + "";
	else hours = hours + "";
	if (minutes < 10) minutes = "0" + (minutes + "");
	else minutes = minutes + "";
	let time = hours + ":" + minutes;
	let begstr1 = time + " " + daylist[date.getDay()] + " " + date.getDate() + " " + mounthlist[date.getMonth()] + " " + date.getFullYear() + " г.";
	let begstr2 = "Темп. на улице " + weatherlist[date.getMonth()] + "ºC";
	let begstr3 = "Темп. в салоне +21ºC";
	let begstr4 = "Курение запрещено!";

	if (train.getThisRoutePlatforms().size() != 0) {
		EMUText1 = processName(getFirstStation(train))
		EMUText2 = processName(getEndStation(train))
	}

	//ЭМУ головной вагон левый
	let g = state.dh.graphics();

	// PREPARE
	g.setComposite(AlphaComposite.Clear);
	g.fillRect(0, 0, 796, 128);
	g.setComposite(AlphaComposite.SrcOver);

	// route destination
	g.setColor(Color.GREEN);
	g.setFont(fontpered.deriveFont(Font.PLAIN, 80))

	if (!state.isOnRoute){
		drawStringCenter(g, toDepot, 796, 105);
	} else {
		drawStringCenter(g, EMUText1, 796, 105);
	}
	state.dh.upload();
	//ЭМУ головной вагон правый
       let g2 = state.dh2.graphics();

	// PREPARE
	g2.setComposite(AlphaComposite.Clear);
	g2.fillRect(0, 0, 796, 128);
	g2.setComposite(AlphaComposite.SrcOver);

            g2.setColor(Color.GREEN);
            g2.setFont(fontpered.deriveFont(Font.PLAIN, 80));
 	if (!state.isOnRoute){
		drawStringCenter(g2, toDepot, 796, 105);
	} else {
		drawStringCenter(g2, EMUText2, 796, 105);
	}
            state.dh2.upload();

}

function processName(a) {
	let aJsStr = "" + a;
	if (a.includes('|')) {

		let strs = aJsStr.split('|')
		aJsStr = strs[0];
	}
	return aJsStr;
}

function clamp(num, min, max) {
  return Math.min(Math.max(num, min), max);
} 

function getRouteNum(train) {
	let stationList = train.getThisRoutePlatforms();
	let ret = stationList[0].route.lightRailRouteNumber + "";
if (ret != "") ret += " ";
  return ret;
}

function getFirstStation(train) {
  let stationList = train.getThisRoutePlatforms();
  if (stationList.size() === 0 || stationList[0] == null) {
    return;
  }
  
  let regularFirstStation = stationList[0].station.name;
  let customFirstStation = stationList[0].route.platformIds[0].customDestination + "";

  return customFirstStation == "" ? regularFirstStation.toUpperCase() : customFirstStation.toUpperCase();
}

function getEndStation(train) {
  let stationList = train.getThisRoutePlatforms();
  if (stationList.size() === 0) {
    return;
  }
  
  let lastSt = stationList.size() - 1;
  if (stationList[lastSt] == null) {
    return;
  }
  
  let regularEndStation = stationList[lastSt].station.name;
  let customEndStation = stationList[lastSt].route.platformIds[lastSt].customDestination + "";

  return customEndStation == "" ? regularEndStation.toUpperCase() : customEndStation.toUpperCase();
}

function getNextStation(train) {
  let stationList = train.getThisRoutePlatforms();
  if (stationList.size() === 0) {
    return;
  }
  
  let nextstationindex = train.getThisRoutePlatformsNextIndex();
  if (stationList[nextstationindex] == null) {
    return;
  }
  
  return stationList[nextstationindex].station.name;
}

function getNextStationId(train) {
  let stationList = train.getAllPlatforms();
  let nextstationindex = train.getAllPlatformsNextIndex();
  
  return nextstationindex;
}

function getNextStationIdThisRoute(train) {
  let stationList = train.getThisRoutePlatforms();
  let nextstationindex = train.getThisRoutePlatformsNextIndex();
  
  return nextstationindex;
}

function isItStation(train) {
	let stoptime = train.path()[train.getRailIndex(train.getRailProgress(0), false)].dwellTime;
	return stoptime != 0;
}

function isTheDepartureSoon(state, train) {
	return state.savedDwellTime - 3 <= state.stationTick * 0.05;
}

function drawStringCenter(g, string, x, y){
  let fontMetrics = g.getFontMetrics();
  const newX = (x - fontMetrics.stringWidth(string)) / 2;

  g.drawString(string, newX, y)
} 