include(Resources.idRelative("mtr:lib/harrys_lib.js"));

var renderWindows = false;

var rawModels = ModelManager.loadPartedRawModel(Resources.manager(), Resources.idRelative("mtr:ed4m/ed4m_head.obj"), null);
var head = uploadPartedModels(rawModels, true, true);

var rawModels2 = ModelManager.loadPartedRawModel(Resources.manager(), Resources.idRelative("mtr:ed4m/ed4m_motor.obj"), null);
var motor = uploadPartedModels(rawModels2, true, true);

var rawModels3 = ModelManager.loadPartedRawModel(Resources.manager(), Resources.idRelative("mtr:ed4m/ed4m_prom.obj"), null);
var prom = uploadPartedModels(rawModels3, true, true);

/*repaint(head)
repaint2(motor)
repaint3(prom)*/

function create(ctx, state, train) {

	initRoll(train, state);
	initRocking(train, state);

	state.postCreateFunctionCalled = false;

	state.oldDoorVal = train.doorValue();
	state.wheelAngle = 0.0; // Градус поворота колеса радиусом 1 метр. Градус колеса радиуса x, очевидно, будет в два 1/x раз больше (или меньше)
	state.wheelSpark = 0.0
}


function dispose(ctx, state, train) {

}

function render(ctx, state, train) {
	state.wheelRadiusPricep = 0.42145;
	state.wheelRadiusMotor = 0.44595;
	updateLogic(state, train);
	renderLogic(ctx, state, train);
	updateSpeedStates(train, state);
	updateWheelAngle(train, state);	
	setPostcreateInfo(ctx, state, train); // train.siding() при вызове в функции create возвращает null, поэтому нужна доп. проверка.
}

function setPostcreateInfo(ctx, state, train) {
	if (!state.postCreateFunctionCalled) {
		
		if (train.siding() == null) {
			return;
		}
		if (train.siding().name.includes('|')) {
		state.infoArr = train.siding().name.split('\\|');
		state.postCreateFunctionCalled = true;
		}
	}
}

function updateLogic(state, train) {
	updateRoll(train, state, -0.5);
	updateRocking(train, state, 140, 88, 20, 27);
}

function renderLogic(ctx, state, train) {
	let matrices = new Matrices();
	renderHead(ctx, state, train, 0, matrices);

	if (train.trainCars() > 1) {
		renderMotor(ctx, state, train, 1, matrices);

		if (train.trainCars() == 11) {
			renderProm(ctx, state, train, 2, matrices);
			renderMotor(ctx, state, train, 3, matrices);
			renderProm(ctx, state, train, 4, matrices);
			renderMotor(ctx, state, train, 5, matrices);
			renderMotorRev(ctx, state, train, 6, matrices);
			renderProm(ctx, state, train, 7, matrices);
			renderProm(ctx, state, train, 8, matrices);
			renderMotorRev(ctx, state, train, 9, matrices);
		}
		else if (train.trainCars() == 10) {
			renderProm(ctx, state, train, 2, matrices);
			renderMotor(ctx, state, train, 3, matrices);
			renderProm(ctx, state, train, 4, matrices);
			renderMotor(ctx, state, train, 5, matrices);
			renderMotorRev(ctx, state, train, 6, matrices);
			renderProm(ctx, state, train, 7, matrices);
			renderMotorRev(ctx, state, train, 8, matrices);
		}
		else if (train.trainCars() == 9) {
			renderProm(ctx, state, train, 2, matrices);
			renderMotor(ctx, state, train, 3, matrices);
			renderMotorRev(ctx, state, train, 4, matrices);
			renderProm(ctx, state, train, 5, matrices);
			renderProm(ctx, state, train, 6, matrices);
			renderMotorRev(ctx, state, train, 7, matrices);
		}
		else if (train.trainCars() == 8) {
			renderProm(ctx, state, train, 2, matrices);
			renderMotor(ctx, state, train, 3, matrices);
			renderMotorRev(ctx, state, train, 4, matrices);
			renderProm(ctx, state, train, 5, matrices);
			renderMotorRev(ctx, state, train, 6, matrices);
		}
		else if (train.trainCars() == 7) {
			renderProm(ctx, state, train, 2, matrices);
			renderMotor(ctx, state, train, 3, matrices);
			renderMotorRev(ctx, state, train, 4, matrices);
			renderProm(ctx, state, train, 5, matrices);
		}
		else if (train.trainCars() == 6) {
			renderProm(ctx, state, train, 2, matrices);
			renderMotor(ctx, state, train, 3, matrices);
			renderMotorRev(ctx, state, train, 4, matrices);
		}
		else if (train.trainCars() == 5) {
			renderMotorRev(ctx, state, train, 2, matrices);
			renderProm(ctx, state, train, 3, matrices);
		}
		else {
			renderMotorRev(ctx, state, train, 2, matrices);
		}
		
		renderTail(ctx, state, train, train.trainCars()-1, matrices);
	}
}

function renderHead(ctx, state, train, i, matrices) {
	let roll = state.rolls[i];
	roll = clamp(roll, -0.03, 0.03);
	let speedKmph = train.speed() * 20 * 3.6;
	let speedCoef = speedKmph > 20.0 ? 1.0 : speedKmph / 40 + 0.5;
	let rockZ = (state.rockingZCoef + i * 0.2) % 1.0;
	let rockX = (state.rockingXCoef +  0.2 * i) % 1.0;
 
	let totalXrotation = 1.1 * speedCoef * chaoticRotate(rockX) * 0.5;
	let totalZrotation = 1.1 * speedCoef * chaoticRotate2(rockZ) * 5 + roll;

	let wheelAngleCoef = state.wheelAngle/state.wheelRadiusPricep; // поворот колеса радиуса wheelRadius

	let renderFrontLights = !train.isReversed();
	state.wheelSpark = state.wheelSpark + Timing.delta();
	if (state.wheelSpark > 1.0) state.wheelSpark = 0.0;
	// BOGIES
	
	matrices.pushPose();
	ctx.drawCarModel(head["TELEGI"], i, matrices);
	renderWheel(ctx, matrices, head["KOLPARA1"], wheelAngleCoef, i, -0.2867, 8.4407); 
	renderWheel(ctx, matrices, head["KOLPARA2"], wheelAngleCoef, i, -0.2867, 6.2327);
	renderWheel(ctx, matrices, head["KOLPARA3"], wheelAngleCoef, i, -0.2867, -6.6216);
	renderWheel(ctx, matrices, head["KOLPARA4"], wheelAngleCoef, i, -0.2867, -8.8296);
	if (speedKmph < 20 && state.isBreaking) {
		if (renderFrontLights) {
			if (state.wheelSpark > 0.5) {
				ctx.drawCarModel(head["ISKRI1"], i, matrices);
				ctx.drawCarModel(head["ISKRI5"], i, matrices);
			} else {
				ctx.drawCarModel(head["ISKRI2"], i, matrices);
				ctx.drawCarModel(head["ISKRI6"], i, matrices);
			}
		} else {
			if (state.wheelSpark > 0.5) {
				ctx.drawCarModel(head["ISKRI3"], i, matrices);
				ctx.drawCarModel(head["ISKRI7"], i, matrices);
			} else {
				ctx.drawCarModel(head["ISKRI4"], i, matrices);
				ctx.drawCarModel(head["ISKRI8"], i, matrices);
			}
		}
	}
	if ((speedKmph < 20 && state.isBreaking) || speedKmph == 0) {
		matrices.pushPose();
		matrices.translate(0, 0 , -0.007);
		ctx.drawCarModel(head["KOLODKI1"], i, matrices);		
		ctx.drawCarModel(head["KOLODKI3"], i, matrices);		
		ctx.drawCarModel(head["KOLODKI5"], i, matrices);		
		ctx.drawCarModel(head["KOLODKI7"], i, matrices);		
		matrices.popPose();
		matrices.pushPose();
		matrices.translate(0, 0 , 0.007);
		ctx.drawCarModel(head["KOLODKI2"], i, matrices);		
		ctx.drawCarModel(head["KOLODKI4"], i, matrices);		
		ctx.drawCarModel(head["KOLODKI6"], i, matrices);		
		ctx.drawCarModel(head["KOLODKI8"], i, matrices);		
		matrices.popPose();
	} else {
		ctx.drawCarModel(head["KOLODKI1"], i, matrices);		
		ctx.drawCarModel(head["KOLODKI3"], i, matrices);		
		ctx.drawCarModel(head["KOLODKI5"], i, matrices);		
		ctx.drawCarModel(head["KOLODKI7"], i, matrices);		
		ctx.drawCarModel(head["KOLODKI2"], i, matrices);		
		ctx.drawCarModel(head["KOLODKI4"], i, matrices);		
		ctx.drawCarModel(head["KOLODKI6"], i, matrices);		
		ctx.drawCarModel(head["KOLODKI8"], i, matrices);		
	}
	matrices.popPose();
		
	matrices.pushPose();
	matrices.rotateZ(totalZrotation);
	matrices.rotateX(totalXrotation);

	ctx.drawCarModel(state.dh.model, i, matrices);
	ctx.drawCarModel(state.dh2.model, i, matrices);
	//ctx.drawCarModel(state.dhHeadScreen.model, i, matrices);

	ctx.drawCarModel(head["EXT"], i, matrices);
	ctx.drawCarModel(head["INT"], i, matrices);
	ctx.drawCarModel(head["TIKVI"], i, matrices);
	ctx.drawCarModel(head["DECO"], i, matrices);
	ctx.drawCarModel(head["INTLAMPS"], i, matrices);
	//FARY
	if (renderFrontLights) {
		ctx.drawCarModel(head["FARY"], i, matrices);
	} else {
		ctx.drawCarModel(head["BUF"], i, matrices);
	}
	//DOORS
	renderDoorHalf(ctx, train, state, i, matrices, head["D_LF_EXT"], head["D_LF_INT"], null, null, 0, 0, 0, 0.55, false)

	renderDoorHalf(ctx, train, state, i, matrices, head["D_LB_EXT"], head["D_LB_INT"], null, null, 0, 0, 0, -0.55, false)

	renderDoorHalf(ctx, train, state, i, matrices, head["D_RB_EXT"], head["D_RB_INT"], null, null, 0, 0, 0, -0.55, true)

	renderDoorHalf(ctx, train, state, i, matrices, head["D_RF_EXT"], head["D_RF_INT"], null, null, 0, 0, 0, 0.55, true)

	matrices.popPose();
}

function renderMotor(ctx, state, train, i, matrices) {
	let roll = state.rolls[i];
	roll = clamp(roll, -0.03, 0.03);
	let speedKmph = train.speed() * 20 * 3.6;
	let speedCoef = speedKmph > 20.0 ? 1.0 : speedKmph / 40 + 0.5;
	let rockZ = (state.rockingZCoef + i * 0.2) % 1.0;
	let rockX = (state.rockingXCoef +  0.2 * i) % 1.0;

	let totalXrotation = 1.1 * speedCoef * chaoticRotate(rockX) * 0.5;
	let totalZrotation = 1.1 * speedCoef * chaoticRotate2(rockZ) * 5 + roll;
	let wheelAngleCoef = state.wheelAngle/state.wheelRadiusMotor; // поворот колеса радиуса wheelRadius

	let renderFrontLights = !train.isReversed();
	state.wheelSpark = state.wheelSpark + Timing.delta();
	if (state.wheelSpark > 1.0) state.wheelSpark = 0.0;
	// BOGIES
	
	matrices.pushPose();
	ctx.drawCarModel(motor["TELEGI"], i, matrices);
	renderWheel(ctx, matrices, motor["KOLPARA1"], wheelAngleCoef, i, -0.2628, 8.9739); 
	renderWheel(ctx, matrices, motor["KOLPARA2"], wheelAngleCoef, i, -0.2628, 6.5598);
	renderWheel(ctx, matrices, motor["KOLPARA3"], wheelAngleCoef, i, -0.2628, -6.5452);
	renderWheel(ctx, matrices, motor["KOLPARA4"], wheelAngleCoef, i, -0.2628, -8.9593);
	if (speedKmph < 20 && state.isBreaking) {
		if (renderFrontLights) {
			if (state.wheelSpark > 0.5) {
				ctx.drawCarModel(motor["ISKRI1"], i, matrices);
				ctx.drawCarModel(motor["ISKRI5"], i, matrices);
			} else {
				ctx.drawCarModel(motor["ISKRI2"], i, matrices);
				ctx.drawCarModel(motor["ISKRI6"], i, matrices);
			}
		} else {
			if (state.wheelSpark > 0.5) {
				ctx.drawCarModel(motor["ISKRI3"], i, matrices);
				ctx.drawCarModel(motor["ISKRI7"], i, matrices);
			} else {
				ctx.drawCarModel(motor["ISKRI4"], i, matrices);
				ctx.drawCarModel(motor["ISKRI8"], i, matrices);
			}
		}
	}
	if ((speedKmph < 20 && state.isBreaking) || speedKmph == 0) {
		matrices.pushPose();
		matrices.translate(0, 0 , -0.007);
		ctx.drawCarModel(motor["KOLODKI1"], i, matrices);		
		ctx.drawCarModel(motor["KOLODKI3"], i, matrices);		
		ctx.drawCarModel(motor["KOLODKI5"], i, matrices);		
		ctx.drawCarModel(motor["KOLODKI7"], i, matrices);		
		matrices.popPose();
		matrices.pushPose();
		matrices.translate(0, 0 , 0.007);
		ctx.drawCarModel(motor["KOLODKI2"], i, matrices);		
		ctx.drawCarModel(motor["KOLODKI4"], i, matrices);		
		ctx.drawCarModel(motor["KOLODKI6"], i, matrices);		
		ctx.drawCarModel(motor["KOLODKI8"], i, matrices);		
		matrices.popPose();
	} else {
		ctx.drawCarModel(motor["KOLODKI1"], i, matrices);		
		ctx.drawCarModel(motor["KOLODKI3"], i, matrices);		
		ctx.drawCarModel(motor["KOLODKI5"], i, matrices);		
		ctx.drawCarModel(motor["KOLODKI7"], i, matrices);		
		ctx.drawCarModel(motor["KOLODKI2"], i, matrices);		
		ctx.drawCarModel(motor["KOLODKI4"], i, matrices);		
		ctx.drawCarModel(motor["KOLODKI6"], i, matrices);		
		ctx.drawCarModel(motor["KOLODKI8"], i, matrices);		
	}
	matrices.popPose();
	
	matrices.pushPose();
	matrices.rotateZ(totalZrotation);
 	matrices.rotateX(totalXrotation);

	//ctx.drawCarModel(state.dhPromScreen.model, i, matrices);

	ctx.drawCarModel(motor["EXT"], i, matrices);
	ctx.drawCarModel(motor["INT"], i, matrices);
	ctx.drawCarModel(motor["TIKVI"], i, matrices);
	ctx.drawCarModel(motor["DECO"], i, matrices);
	ctx.drawCarModel(motor["INTLAMPS"], i, matrices);		
	//DOORS
	renderDoorHalf(ctx, train, state, i, matrices, motor["D_LF_EXT"], motor["D_LF_INT"], null, null, 0, 0, 0, 0.55, false)

	renderDoorHalf(ctx, train, state, i, matrices, motor["D_LB_EXT"], motor["D_LB_INT"], null, null, 0, 0, 0, -0.55, false)

	renderDoorHalf(ctx, train, state, i, matrices, motor["D_RB_EXT"], motor["D_RB_INT"], null, null, 0, 0, 0, -0.55, true)

	renderDoorHalf(ctx, train, state, i, matrices, motor["D_RF_EXT"], motor["D_RF_INT"], null, null, 0, 0, 0, 0.55, true)

	matrices.popPose();
}

function renderMotorRev(ctx, state, train, i, matrices) {
	let roll = state.rolls[i];
	roll = clamp(roll, -0.03, 0.03);
	let speedKmph = train.speed() * 20 * 3.6;
	let speedCoef = speedKmph > 20.0 ? 1.0 : speedKmph / 40 + 0.5;
	let rockZ = (state.rockingZCoef + i * 0.2) % 1.0;
	let rockX = (state.rockingXCoef +  0.2 * i) % 1.0;

	let totalXrotation = 1.1 * speedCoef * chaoticRotate(rockX) * 0.5;
	let totalZrotation = 1.1 * speedCoef * chaoticRotate2(rockZ) * 5 + roll;
	let wheelAngleCoef = state.wheelAngle/state.wheelRadiusMotor; // поворот колеса радиуса wheelRadius

	let renderFrontLights = !train.isReversed();
	state.wheelSpark = state.wheelSpark + Timing.delta();
	if (state.wheelSpark > 1.0) state.wheelSpark = 0.0;
	// BOGIES
	
	matrices.pushPose();
	ctx.drawCarModel(motor["TELEGI"], i, matrices);
	renderWheel(ctx, matrices, motor["KOLPARA1"], wheelAngleCoef, i, -0.2628, 8.9739); 
	renderWheel(ctx, matrices, motor["KOLPARA2"], wheelAngleCoef, i, -0.2628, 6.5598);
	renderWheel(ctx, matrices, motor["KOLPARA3"], wheelAngleCoef, i, -0.2628, -6.5452);
	renderWheel(ctx, matrices, motor["KOLPARA4"], wheelAngleCoef, i, -0.2628, -8.9593);
	if (speedKmph < 20 && state.isBreaking) {
		if (renderFrontLights) {
			if (state.wheelSpark > 0.5) {
				ctx.drawCarModel(motor["ISKRI1"], i, matrices);
				ctx.drawCarModel(motor["ISKRI5"], i, matrices);
			} else {
				ctx.drawCarModel(motor["ISKRI2"], i, matrices);
				ctx.drawCarModel(motor["ISKRI6"], i, matrices);
			}
		} else {
			if (state.wheelSpark > 0.5) {
				ctx.drawCarModel(motor["ISKRI3"], i, matrices);
				ctx.drawCarModel(motor["ISKRI7"], i, matrices);
			} else {
				ctx.drawCarModel(motor["ISKRI4"], i, matrices);
				ctx.drawCarModel(motor["ISKRI8"], i, matrices);
			}
		}
	}
	if ((speedKmph < 20 && state.isBreaking) || speedKmph == 0) {
		matrices.pushPose();
		matrices.translate(0, 0 , -0.007);
		ctx.drawCarModel(motor["KOLODKI1"], i, matrices);		
		ctx.drawCarModel(motor["KOLODKI3"], i, matrices);		
		ctx.drawCarModel(motor["KOLODKI5"], i, matrices);		
		ctx.drawCarModel(motor["KOLODKI7"], i, matrices);		
		matrices.popPose();
		matrices.pushPose();
		matrices.translate(0, 0 , 0.007);
		ctx.drawCarModel(motor["KOLODKI2"], i, matrices);		
		ctx.drawCarModel(motor["KOLODKI4"], i, matrices);		
		ctx.drawCarModel(motor["KOLODKI6"], i, matrices);		
		ctx.drawCarModel(motor["KOLODKI8"], i, matrices);		
		matrices.popPose();
	} else {
		ctx.drawCarModel(motor["KOLODKI1"], i, matrices);		
		ctx.drawCarModel(motor["KOLODKI3"], i, matrices);		
		ctx.drawCarModel(motor["KOLODKI5"], i, matrices);		
		ctx.drawCarModel(motor["KOLODKI7"], i, matrices);		
		ctx.drawCarModel(motor["KOLODKI2"], i, matrices);		
		ctx.drawCarModel(motor["KOLODKI4"], i, matrices);		
		ctx.drawCarModel(motor["KOLODKI6"], i, matrices);		
		ctx.drawCarModel(motor["KOLODKI8"], i, matrices);		
	}
	matrices.popPose();
	
	matrices.pushPose();
	matrices.rotateZ(totalZrotation);
	matrices.rotateY(3.1415);
	matrices.rotateX(totalXrotation);

	//ctx.drawCarModel(state.dhPromScreen.model, i, matrices);

	ctx.drawCarModel(motor["EXT"], i, matrices);
	ctx.drawCarModel(motor["INT"], i, matrices);
	ctx.drawCarModel(motor["TIKVI"], i, matrices);
	ctx.drawCarModel(motor["DECO"], i, matrices);
	ctx.drawCarModel(motor["INTLAMPS"], i, matrices);
	//DOORS
	renderDoorHalf(ctx, train, state, i, matrices, motor["D_LF_EXT"], motor["D_LF_INT"], null, null, 0, 0, 0, 0.55, true)

	renderDoorHalf(ctx, train, state, i, matrices, motor["D_LB_EXT"], motor["D_LB_INT"], null, null, 0, 0, 0, -0.55, true)

	renderDoorHalf(ctx, train, state, i, matrices, motor["D_RB_EXT"], motor["D_RB_INT"], null, null, 0, 0, 0, -0.55, false)

	renderDoorHalf(ctx, train, state, i, matrices, motor["D_RF_EXT"], motor["D_RF_INT"], null, null, 0, 0, 0, 0.55, false)

	matrices.popPose();
}

function renderProm(ctx, state, train, i, matrices) {
	let roll = state.rolls[i];
	roll = clamp(roll, -0.03, 0.03);
	let speedKmph = train.speed() * 20 * 3.6;
	let speedCoef = speedKmph > 20.0 ? 1.0 : speedKmph / 40 + 0.5;
	let rockZ = (state.rockingZCoef + i * 0.2) % 1.0;
	let rockX = (state.rockingXCoef +  0.2 * i) % 1.0;

	let totalXrotation = 1.1 * speedCoef * chaoticRotate(rockX) * 0.5;
	let totalZrotation = 1.1 * speedCoef * chaoticRotate2(rockZ) * 3 + roll;
	let wheelAngleCoef = state.wheelAngle/state.wheelRadiusPricep; // поворот колеса радиуса wheelRadius

	let renderFrontLights = !train.isReversed();
	state.wheelSpark = state.wheelSpark + Timing.delta();
	if (state.wheelSpark > 1.0) state.wheelSpark = 0.0;
	// BOGIES
	
	matrices.pushPose();
	ctx.drawCarModel(prom["TELEGI"], i, matrices);
	renderWheel(ctx, matrices, prom["KOLPARA1"], wheelAngleCoef, i, -0.2867, 8.9080); 
	renderWheel(ctx, matrices, prom["KOLPARA2"], wheelAngleCoef, i, -0.2867, 6.7000);
	renderWheel(ctx, matrices, prom["KOLPARA3"], wheelAngleCoef, i, -0.2867, -6.7464);
	renderWheel(ctx, matrices, prom["KOLPARA4"], wheelAngleCoef, i, -0.2867, -8.9544);
	if (speedKmph < 20 && state.isBreaking) {
		if (renderFrontLights) {
			if (state.wheelSpark > 0.5) {
				ctx.drawCarModel(prom["ISKRI1"], i, matrices);
				ctx.drawCarModel(prom["ISKRI5"], i, matrices);
			} else {
				ctx.drawCarModel(prom["ISKRI2"], i, matrices);
				ctx.drawCarModel(prom["ISKRI6"], i, matrices);
			}
		} else {
			if (state.wheelSpark > 0.5) {
				ctx.drawCarModel(prom["ISKRI3"], i, matrices);
				ctx.drawCarModel(prom["ISKRI7"], i, matrices);
			} else {
				ctx.drawCarModel(prom["ISKRI4"], i, matrices);
				ctx.drawCarModel(prom["ISKRI8"], i, matrices);
			}
		}
		matrices.pushPose();
		matrices.translate(0, 0 , -0.007);
		ctx.drawCarModel(prom["KOLODKI1"], i, matrices);		
		ctx.drawCarModel(prom["KOLODKI3"], i, matrices);		
		ctx.drawCarModel(prom["KOLODKI5"], i, matrices);		
		ctx.drawCarModel(prom["KOLODKI7"], i, matrices);		
		matrices.popPose();
		matrices.pushPose();
		matrices.translate(0, 0 , 0.007);
		ctx.drawCarModel(prom["KOLODKI2"], i, matrices);		
		ctx.drawCarModel(prom["KOLODKI4"], i, matrices);		
		ctx.drawCarModel(prom["KOLODKI6"], i, matrices);		
		ctx.drawCarModel(prom["KOLODKI8"], i, matrices);		
		matrices.popPose();
	}
	else {
		ctx.drawCarModel(prom["KOLODKI1"], i, matrices);		
		ctx.drawCarModel(prom["KOLODKI3"], i, matrices);		
		ctx.drawCarModel(prom["KOLODKI5"], i, matrices);		
		ctx.drawCarModel(prom["KOLODKI7"], i, matrices);		
		ctx.drawCarModel(prom["KOLODKI2"], i, matrices);		
		ctx.drawCarModel(prom["KOLODKI4"], i, matrices);		
		ctx.drawCarModel(prom["KOLODKI6"], i, matrices);		
		ctx.drawCarModel(prom["KOLODKI8"], i, matrices);		
	}
	matrices.popPose();
	
	matrices.pushPose();
	matrices.rotateZ(totalZrotation);
	matrices.rotateX(totalXrotation);

	//ctx.drawCarModel(state.dhPromScreen.model, i, matrices);

	ctx.drawCarModel(prom["EXT"], i, matrices);
	ctx.drawCarModel(prom["INT"], i, matrices);
	ctx.drawCarModel(prom["TIKVI"], i, matrices);
	ctx.drawCarModel(motor["DECO"], i, matrices);
	ctx.drawCarModel(prom["INTLAMPS"], i, matrices);
	//DOORS
	renderDoorHalf(ctx, train, state, i, matrices, prom["D_LF_EXT"], prom["D_LF_INT"], null, null, 0, 0, 0, 0.55, false)

	renderDoorHalf(ctx, train, state, i, matrices, prom["D_LB_EXT"], prom["D_LB_INT"], null, null, 0, 0, 0, -0.55, false)

	renderDoorHalf(ctx, train, state, i, matrices, prom["D_RB_EXT"], prom["D_RB_INT"], null, null, 0, 0, 0, -0.55, true)

	renderDoorHalf(ctx, train, state, i, matrices, prom["D_RF_EXT"], prom["D_RF_INT"], null, null, 0, 0, 0, 0.55, true)

	matrices.popPose();
}

function renderTail(ctx, state, train, i, matrices) {
	let roll = state.rolls[i];
	roll = clamp(roll, -0.03, 0.03);
	let speedKmph = train.speed() * 20 * 3.6;
	let speedCoef = speedKmph > 20.0 ? 1.0 : speedKmph / 40 + 0.5;
	let rockZ = (state.rockingZCoef + i * 0.2) % 1.0;
	let rockX = (state.rockingXCoef +  0.2 * i) % 1.0;

	let totalXrotation = 1.1 * speedCoef * chaoticRotate(rockX) * 0.5;
	let totalZrotation = 1.1 * speedCoef * chaoticRotate2(rockZ) * 5 + roll;

	let renderFrontLights = !train.isReversed();

	let wheelAngleCoef = state.wheelAngle/state.wheelRadiusPricep; // поворот колеса радиуса wheelRadius
	
	matrices.pushPose();

	matrices.rotateX(0.0005);
	matrices.rotateZ(totalZrotation);
	matrices.rotateY(3.1415);
	state.wheelSpark = state.wheelSpark + Timing.delta();
	if (state.wheelSpark > 1.0) state.wheelSpark = 0.0;
	// BOGIES
	
	//matrices.pushPose();
	ctx.drawCarModel(head["TELEGI"], i, matrices);
	renderWheel(ctx, matrices, head["KOLPARA1"], -wheelAngleCoef, i, -0.2867, 8.4407); 
	renderWheel(ctx, matrices, head["KOLPARA2"], -wheelAngleCoef, i, -0.2867, 6.2327);
	renderWheel(ctx, matrices, head["KOLPARA3"], -wheelAngleCoef, i, -0.2867, -6.6216);
	renderWheel(ctx, matrices, head["KOLPARA4"], -wheelAngleCoef, i, -0.2867, -8.8296);
	if (speedKmph < 20 && state.isBreaking) {
		if (renderFrontLights) {
			if (state.wheelSpark > 0.5) {
				ctx.drawCarModel(head["ISKRI3"], i, matrices);
				ctx.drawCarModel(head["ISKRI7"], i, matrices);
			} else {
				ctx.drawCarModel(head["ISKRI4"], i, matrices);
				ctx.drawCarModel(head["ISKRI8"], i, matrices);
			}
		} else {
			if (state.wheelSpark > 0.5) {
				ctx.drawCarModel(head["ISKRI1"], i, matrices);
				ctx.drawCarModel(head["ISKRI5"], i, matrices);
			} else {
				ctx.drawCarModel(head["ISKRI2"], i, matrices);
				ctx.drawCarModel(head["ISKRI6"], i, matrices);
			}
		}
	}
	if ((speedKmph < 20 && state.isBreaking) || speedKmph == 0) {
		matrices.pushPose();
		matrices.translate(0, 0 , -0.007);
		ctx.drawCarModel(head["KOLODKI1"], i, matrices);		
		ctx.drawCarModel(head["KOLODKI3"], i, matrices);		
		ctx.drawCarModel(head["KOLODKI5"], i, matrices);		
		ctx.drawCarModel(head["KOLODKI7"], i, matrices);		
		matrices.popPose();
		matrices.pushPose();
		matrices.translate(0, 0 , 0.007);
		ctx.drawCarModel(head["KOLODKI2"], i, matrices);		
		ctx.drawCarModel(head["KOLODKI4"], i, matrices);		
		ctx.drawCarModel(head["KOLODKI6"], i, matrices);		
		ctx.drawCarModel(head["KOLODKI8"], i, matrices);		
		matrices.popPose();
	} else {
		ctx.drawCarModel(head["KOLODKI1"], i, matrices);		
		ctx.drawCarModel(head["KOLODKI3"], i, matrices);		
		ctx.drawCarModel(head["KOLODKI5"], i, matrices);		
		ctx.drawCarModel(head["KOLODKI7"], i, matrices);		
		ctx.drawCarModel(head["KOLODKI2"], i, matrices);		
		ctx.drawCarModel(head["KOLODKI4"], i, matrices);		
		ctx.drawCarModel(head["KOLODKI6"], i, matrices);		
		ctx.drawCarModel(head["KOLODKI8"], i, matrices);		
	}
	//matrices.popPose();
	matrices.pushPose();
  	matrices.rotateZ(-totalZrotation);
  	matrices.rotateX(-totalXrotation);

	ctx.drawCarModel(state.dh.model, i, matrices);
	ctx.drawCarModel(state.dh2.model, i, matrices);
	//ctx.drawCarModel(state.dhHeadScreen.model, i, matrices);

	ctx.drawCarModel(head["EXT"], i, matrices);
	ctx.drawCarModel(head["INT"], i, matrices);
	ctx.drawCarModel(head["TIKVI"], i, matrices);
	ctx.drawCarModel(head["DECO"], i, matrices);
	ctx.drawCarModel(head["INTLAMPS"], i, matrices);
	//FARY
	if (!renderFrontLights) {
		ctx.drawCarModel(head["FARY"], i, matrices);
	} else {
		ctx.drawCarModel(head["BUF"], i, matrices);
	}

	//DOORS
	renderDoorHalf(ctx, train, state, i, matrices, head["D_LF_EXT"], head["D_LF_INT"], null, null, 0, 0, 0, 0.55, true)

	renderDoorHalf(ctx, train, state, i, matrices, head["D_LB_EXT"], head["D_LB_INT"], null, null, 0, 0, 0, -0.55, true)

	renderDoorHalf(ctx, train, state, i, matrices, head["D_RB_EXT"], head["D_RB_INT"], null, null, 0, 0, 0, -0.55, false)

	renderDoorHalf(ctx, train, state, i, matrices, head["D_RF_EXT"], head["D_RF_INT"], null, null, 0, 0, 0, 0.55, false)
	matrices.popPose();

	matrices.popPose();
}

function renderDoorHalf(ctx, train, state, i, matrices, ext, int, win, light, x1, z1, x2, z2, isRight) {
	let doorValue = 0.0
	if (isRight) {
		doorValue = train.doorValue() * train.doorRightOpen[i];
	} else {
		doorValue = train.doorValue() * train.doorLeftOpen[i];
	}

	let doorValueClamped = clamp(doorValue * 1.7, 0, 1);

	let doorA = 0.0
	let doorB = 0.0
	const alpha = 0.3

	if (doorValueClamped < alpha) {
		doorB = 0.0
		doorA = doorValueClamped / alpha
	} else {
		doorB = (doorValueClamped - alpha) / (1 - alpha)
		doorA = 1.0
	}

	doorA = easeIn(doorA)
	doorB = easeOut(doorB)

	matrices.pushPose();
	matrices.translate(x1 * doorA, 0 ,z1 * doorA * doorA);
	matrices.translate(x2 * doorB, 0 ,z2 * doorB);
	ctx.drawCarModel(ext, i, matrices);
	ctx.drawCarModel(int, i, matrices);

	if (renderWindows) {
		ctx.drawCarModel(win, i, matrices);
	}

	matrices.popPose();
}

function renderWheel(ctx, matrices, part, angle, i, y, z) {
	matrices.pushPose(); // поворот объекта - смотри в самый низ
	matrices.translate(0.0, y, z);
	matrices.rotate(1.0, 0.0, 0.0, angle);
	matrices.translate(0.0, -y, -z);
	ctx.drawCarModel(part, i, matrices);
	
	matrices.popPose();
}

function easeIn(x) {
	return x*x;
}

function easeOut(x) {
	return 1 - (1 - x) * (1 - x);
}

function chaoticRotate(x) {
	return (x)*(x-1)*(x-0.25)*(x-0.6)*(x-0.8);
}

function chaoticRotate2(x) {
	return (x)*(x-1)*(x-0.15)*(x-0.5)*(x-0.8);
}

