importPackage(java.awt);
importPackage(java.awt.geom);

include(Resources.id("mtrsteamloco:scripts/display_helper.js"));
const toDepot = "HAPPY METROWEEN!"

let slotCfg = {
    version: 1,
    texSize: [1580, 128],
    slots: [
        {
            name: 'head',
            texArea: [0, 0, 1580, 128],
            pos: [
                [
                    [-0.8529, 2.7996, 9.4640],
                    [-0.8529, 2.6640, 9.4640],
                    [0.8529, 2.6640, 9.4640],
                    [0.8529, 2.7996, 9.4640],
                ],
            ],
            offsets: [[0, 0, 0]]}

    ]
};

let slotMotorCfg = {
    version: 1,
    texSize: [1613, 128],
    slots: [
        {
            name: 'left',
            texArea: [0, 0, 1613, 128],
            pos: [
                [
                    [1.7002, 2.279, 7.5726],
                    [1.7002, 2.2012, 7.5726],
                    [1.7002, 2.2012, 6.5924],
                    [1.7002, 2.279, 6.5924],
                ],
            ],
            offsets: [[0, 0, 0]]},
        {
            name: 'right',
            texArea: [0, 0, 1613, 128],
            pos: [
                [
                    [-1.7002, 2.279, -7.5726],
                    [-1.7002, 2.2012, -7.5726],
                    [-1.7002, 2.2012, -6.5924],
                    [-1.7002, 2.279, -6.5924]
                ],
            ],
            offsets: [[0, 0, 0]]
        }
    ]
};

let slotHeadScreenCfg = {
    version: 1,
    texSize: [1295, 256],
    slots: [
        {
            name: 'screenfront',
            texArea: [0, 0, 1295, 256],
            pos: [
                [
                    [-0.1527, 3.0841, 1.7305],
                    [-0.1527, 2.886, 1.7305],
                    [-1.1551, 2.886, 1.7305],
                    [-1.1551, 3.0841, 1.7305]
                ],
            ],
            offsets: [[0, 0, 0]]},
       {
            name: 'screenback',
            texArea: [0, 0, 1295, 256],
            pos: [
                [
                    [-0.5012, 3.0841, -7.7689],
                    [-0.5012, 2.886, -7.7689],
                    [0.5012, 2.886, -7.7689],
                    [0.5012, 3.0841, -7.7689]
                ],
            ],
            offsets: [[0, 0, 0]]}
    ]
};

let slotPromScreenCfg = {
    version: 1,
    texSize: [1295, 256],
    slots: [
        {
            name: 'screenfront',
            texArea: [0, 0, 1295, 256],
            pos: [
                [
                    [0.5012, 3.0841, 7.7689],
                    [0.5012, 2.886, 7.7689],
                    [-0.5012, 2.886, 7.7689],
                    [-0.5012, 3.0841, 7.7689]
                ],
            ],
            offsets: [[0, 0, 0]]},
       {
            name: 'screenback',
            texArea: [0, 0, 1295, 256],
            pos: [
                [
                    [-0.5012, 3.0841, -7.7689],
                    [-0.5012, 2.886, -7.7689],
                    [0.5012, 2.886, -7.7689],
                    [0.5012, 3.0841, -7.7689]
                ],
            ],
            offsets: [[0, 0, 0]]}
    ]
};

var fontpered = Resources.readFont(Resources.idRelative("mtr:font/ep2d-ep2dm-perednii-emu.ttf"));
var fontbok = Resources.readFont(Resources.idRelative("mtr:font/ep2d-ep2dm-bokovoi-emu.ttf"));
var fontscreentext = Resources.readFont(Resources.idRelative("mtr:font/moscowsans.ttf"));
var fontscreensymb = Resources.readFont(Resources.idRelative("mtr:font/moscowsanspictogram.ttf"));
const maxTickDispConst = 460;
let dhBase = new DisplayHelper(slotCfg);
let dhMotorBase = new DisplayHelper(slotMotorCfg);
let dhHeadScreenBase = new DisplayHelper(slotHeadScreenCfg);
let dhPromScreenBase = new DisplayHelper(slotPromScreenCfg);



function create(ctx, state, train) {
	state.dh = dhBase.create();
	state.dhMotor = dhMotorBase.create();
	state.dhHeadScreen = dhHeadScreenBase.create();
	state.dhPromScreen = dhPromScreenBase.create();
	state.rate = new RateLimit(0.05);
	state.dyscreen = 42;
	state.displTick = 5;
	state.postCreateFunctionCalled = false;
	state.tekline = ""

	drawDispl(state, train)
}

function updateTick(state, train) {
  state.displTick++;
  if (maxTickDispConst < state.displTick) state.displTick = 0;
}

function dispose(ctx, state, train) {
	if (state.dh != null) {
		state.dh.close();
	}
	if (state.dhMotor != null) {
		state.dhMotor.close();
	}
	if (state.dhHeadScreen != null) {
		state.dhHeadScreen.close();
	}
	if (state.dhPromScreen != null) {
		state.dhPromScreen.close();
	}
}

function render(ctx, state, train) {
	setPostcreateInfo(ctx, state, train); // train.siding() при вызове в функции create возвращает null, поэтому нужна доп. проверка.
	//renderDispl(ctx, state, train); // неиспользуется из-за того, что вагон качается, а дисплей нет.
	updateDispl(ctx, state, train);
}

function setPostcreateInfo(ctx, state, train) {
	if (!state.postCreateFunctionCalled) {
		
		if (train.siding() == null) {
			return;
		}
		if (train.siding().name.includes('|')) {
		state.infoArr = train.siding().name.split('\\|');
		state.postCreateFunctionCalled = true;
		}
	}
}

function updateDispl(ctx, state, train){
	if (state.rate.shouldUpdate()){
		updateEmuStrings(state, train);
		drawDispl(state, train);
		updateTick(state, train);
	}
}

function updateEmuStrings(state, train) {
  if (train.getThisRoutePlatforms().size() != 0) {
    state.isOnRoute = true;
  } else {
    state.isOnRoute = false
  }
}

function drawDispl(state, train){

        let EMUText = ""
        let EMULine = ""
        //let EMULineScreen = ""
	let color = Color.WHITE;
	let date = new Date();
	let hours = date.getUTCHours() + 3;
	let minutes = date.getMinutes();
	if (hours > 23) hours = hours - 24 + "";
	else hours = hours + "";
	if (minutes < 10) minutes = "0" + (minutes + "");
	else minutes = minutes + "";
	let time = hours + ":" + minutes;

	if (state.displTick < 5) state.dyscreen = Math.trunc(state.displTick * 25.6 + 128);
	else if (state.displTick < 225) state.dyscreen = 170;
	else if (state.displTick < 235) state.dyscreen = Math.trunc(170 - (state.displTick - 225) * 25.6);
	else if (state.displTick < 455) state.dyscreen = -86;
	else state.dyscreen = Math.trunc((state.displTick - 455) * 25.6 - 86);	

	if (train.getThisRoutePlatforms().size() != 0) {
		EMULine = getRouteNum(train);
		EMUText = processName(getEndStation(train))
		EMUText = EMULine + EMUText;
		color = getRouteColor(train);
	let endStationCheck = train.getThisRoutePlatforms()[train.getThisRoutePlatforms().size() - 1].station.name;
		
		if (state.tekline != endStationCheck) {
		state.tekline = endStationCheck;
		EMULineScreen = getRouteNum2(train);
		//Замена некоторых линий на московские иконки
		if (EMULineScreen == "10") {
			EMULineScreen = "*"
		}
		else if (EMULineScreen == "11") {
			EMULineScreen = "("
		}
		else if (EMULineScreen == "11А" || EMULineScreen == "11а" || EMULineScreen == "11A" || EMULineScreen == "11a") {
			EMULineScreen = "%"
		}
		else if (EMULineScreen == "12") {
			EMULineScreen = ")"
		}
		else if (EMULineScreen == "13") {
			EMULineScreen = "0"
		}
		else if (EMULineScreen == "14") {
			EMULineScreen = "+"
		}
		else if (EMULineScreen == "15") {
			EMULineScreen = "&"
		}
		else if (EMULineScreen == "16") {
			EMULineScreen = "!"
		}
		else if (EMULineScreen == "17") {
			EMULineScreen = "{"
		}
		else if (EMULineScreen == "18") {
			EMULineScreen = "$"
		}
		else if (EMULineScreen == "19") {
			EMULineScreen = "}"
		}
		else if (EMULineScreen == "4А" || EMULineScreen == "4а" || EMULineScreen == "4A" || EMULineScreen == "4a") {
			EMULineScreen = ";"
		}
		else if (EMULineScreen == "8А" || EMULineScreen == "8а" || EMULineScreen == "8A" || EMULineScreen == "8a") {
			EMULineScreen = ":"
		}
		else if (EMULineScreen == "D1") {
			EMULineScreen = "<"
		}
		else if (EMULineScreen == "D2") {
			EMULineScreen = "="
		}
		else if (EMULineScreen == "D3") {
			EMULineScreen = ">"
		}
		else if (EMULineScreen == "D4") {
			EMULineScreen = "?"
		}
		else if (EMULineScreen == "D4А" || EMULineScreen == "D4а" || EMULineScreen == "D4A" || EMULineScreen == "D4a") {
			EMULineScreen = "r"
		}
		else if (EMULineScreen == "D5") {
			EMULineScreen = "@"
		}	
		}
	}

	//ЭМУ головной вагон
	let g = state.dh.graphics();

	// PREPARE
	g.setComposite(AlphaComposite.Clear);
	g.fillRect(0, 0, 1580, 128);
	g.setComposite(AlphaComposite.SrcOver);

	// route destination
	g.setColor(Color.WHITE);
	g.setFont(fontpered.deriveFont(Font.PLAIN, 100))

	if (!state.isOnRoute){
		drawStringCenter(g, toDepot, 1580, 115);
	} else {
		drawStringCenter(g, EMUText, 1580, 115);
	}
	state.dh.upload();

	//ЭМУ моторный вагон
       [
            { dhMotor: state.dhMotor, graphicsName: 'left' },
            { dhMotor: state.dhMotor, graphicsName: 'right' },
        ].forEach((element) => {
            let g2 = state.dhMotor.graphicsFor(element.graphicsName);

	// PREPARE
	g2.setComposite(AlphaComposite.Clear);
	g2.fillRect(0, 0, 1613, 128);
	g2.setComposite(AlphaComposite.SrcOver);

            g2.setColor(Color.WHITE);
            g2.setFont(fontbok.deriveFont(Font.PLAIN, 122));
 	if (!state.isOnRoute){
		g2.drawString(toDepot, 0, 128);
	} else {
		g2.drawString(EMUText, 0, 128);
	}
            state.dhMotor.upload();
        });

       [
            { dhHeadScreen: state.dhHeadScreen, graphicsName: 'screenfront' },
            { dhHeadScreen: state.dhHeadScreen, graphicsName: 'screenback' },
        ].forEach((element) => {
	//экран головной вагон
	let g3 = state.dhHeadScreen.graphicsFor(element.graphicsName);
	if (state.isOnRoute){

       		g3.setColor(new Color(0.2, 0.2078431373, 0.2274509804));
       		g3.fillRect(0, 0, 1295, 256);
	        g3.setColor(Color.BLACK);
        	g3.fillRect(0, 0, 1295, state.dyscreen);
		let nextstation = processName(getNextStation(train)) + " ";
		let nextstationeng = processName2(getNextStation(train));
		let str1 = ""
		let str2 = ""
		let str3 = ""
		let nextstationId = getNextStationId(train);
		let nextstationIdThisRoute = getNextStationIdThisRoute(train);
		let nextstationInterchLength = 0;
		let nextstationInterch = [];
		if (state.postCreateFunctionCalled && (nextstationId + 1) < state.infoArr.length) {
		nextstationInterch = state.infoArr[nextstationId + 1].split('\\-');
		nextstationInterchLength = nextstationInterch.length;
		}
		if (isItStation(train) || state.savedstation == nextstation) {
			state.savedstation = nextstation;
			str1 = " "
			str2 = " "
			str3 = " "
			state.displTick = 5;
		}
		else {
			state.savedstation = ""
			str1 = "→ "
			str2 = "Следующая "
			str3 = "The next station is "
		}
 
        g3.setColor(Color.WHITE);
	//Длина стрелки с пробелом
        g3.setFont(fontscreentext.deriveFont(Font.PLAIN, 50));
	let fontMetrics = g3.getFontMetrics();
	let str1width = fontMetrics.stringWidth(str1);
	//Длина текста между стрелкой и названием станции
	let str2width = fontMetrics.stringWidth(str2);
	//Длина названия станции
        g3.setFont(fontscreentext.deriveFont(1, 50));
	fontMetrics = g3.getFontMetrics();
	let nextstwidth = fontMetrics.stringWidth(nextstation);
	//Длина символа линии
	g3.setFont(fontscreensymb.deriveFont(Font.PLAIN, 50));
	fontMetrics = g3.getFontMetrics();
	let linewidth = fontMetrics.stringWidth(EMULineScreen);
	//Длина английского текста
        g3.setFont(fontscreentext.deriveFont(Font.PLAIN, 30));
	fontMetrics = g3.getFontMetrics();
	let str3width = fontMetrics.stringWidth(str3);
	//Длина английского названия станции
        g3.setFont(fontscreentext.deriveFont(1, 30));
	fontMetrics = g3.getFontMetrics();
	let nextstengwidth = fontMetrics.stringWidth(nextstationeng);
	
	let nachsm1 = (1295 - (str1width + str2width + nextstwidth + linewidth)) / 2;
	let nachsm2 = (1295 - (str3width + nextstengwidth)) / 2;

	g3.setFont(fontscreentext.deriveFont(Font.PLAIN, 50));

	//Вывод стрелки или пробелов на чёрном фоне
	if (state.displTick % 20 <= 10) state.dxscreen = -0.5 * (state.displTick % 20);
	else state.dxscreen = state.displTick % 20 * 0.5 - 10;
	g3.setColor(new Color(146 / 255, 146 / 255, 146 / 255));
	g3.drawString(str1, nachsm1 + state.dxscreen, 70 + state.dyscreen - 170);
	g3.setColor(Color.WHITE);
	if ((state.displTick % 20) <= 10) g3.drawString(str1, nachsm1 + state.dxscreen, 70 + state.dyscreen - 170);

	g3.setColor(new Color(color.r / 255, color.g / 255, color.b / 255));
	g3.drawString(str2, nachsm1 + str1width, 70 + state.dyscreen - 170);
	g3.setFont(fontscreentext.deriveFont(1, 50));
	g3.drawString(nextstation, nachsm1 + str1width + str2width, 70 + state.dyscreen - 170);

	//Вывод символов линий
	g3.setColor(Color.WHITE);
	g3.setFont(fontscreensymb.deriveFont(Font.PLAIN, 50));
	if (EMULineScreen == "1" || EMULineScreen == "2" || EMULineScreen == "3" || EMULineScreen == "4" || EMULineScreen == ";" || EMULineScreen == "5" || EMULineScreen == "6" || EMULineScreen == "7" || EMULineScreen == "8" || EMULineScreen == ":" || EMULineScreen == "9" || EMULineScreen == "*" || EMULineScreen == "(" || EMULineScreen == "%" || EMULineScreen == ")" || EMULineScreen == "0" || EMULineScreen == "+" || EMULineScreen == "&" || EMULineScreen == "!" || EMULineScreen == "{" || EMULineScreen == "$" || EMULineScreen == "}") {
	g3.drawString("/", nachsm1 + str1width + str2width + nextstwidth, 70 + state.dyscreen - 170);
}
else if (EMULineScreen == "<" || EMULineScreen == "=" || EMULineScreen == ">" || EMULineScreen == "?" || EMULineScreen == "r" || EMULineScreen == "@") {
	g3.drawString("^", nachsm1 + str1width + str2width + nextstwidth, 70 + state.dyscreen - 170);
}

	g3.setColor(new Color(color.r / 255, color.g / 255, color.b / 255));
	g3.drawString(EMULineScreen, nachsm1 + str1width + str2width + nextstwidth, 70 + state.dyscreen - 170);

	//Вывод текста на английском
	g3.setColor(Color.WHITE);
	g3.setFont(fontscreentext.deriveFont(Font.PLAIN, 30));
	g3.drawString(str3, nachsm2, 120 + state.dyscreen - 170);
	g3.setFont(fontscreentext.deriveFont(1, 30));
	g3.drawString(nextstationeng, nachsm2 + str3width, 120 + state.dyscreen - 170);

	//Линия
	let thisPlatforms = train.getThisRoutePlatforms();
	let linestationcount = thisPlatforms.size();

	if (linestationcount >= 4) {
		if (nextstationIdThisRoute + 3 < linestationcount - 1) {

			//Текущая станция, следующая станция, следующая после следующей ... конечная

				//Вывод стрелки на сером фоне (по y 130)
        			g3.setFont(fontscreentext.deriveFont(Font.PLAIN, 50));
				g3.setColor(new Color(146 / 255, 146 / 255, 146 / 255));
				g3.drawString("→", 20 + state.dxscreen, 396 + state.dyscreen - 170);
				g3.setColor(Color.WHITE);
				if ((state.displTick % 20) <= 10) g3.drawString("→", 20 + state.dxscreen, 396 + state.dyscreen - 170);
				g3.setFont(fontscreentext.deriveFont(1, 30));

			g3.setColor(new Color(146 / 255, 146 / 255, 146 / 255));
			g3.fillRect(0, 481 + state.dyscreen - 170, 82, 490 + state.dyscreen - 170);
			g3.setColor(new Color(color.r / 255, color.g / 255, color.b / 255));
			g3.fillRect(82, 481 + state.dyscreen - 170, 80, 490 + state.dyscreen - 170);
			g3.fillRect(188, 481 + state.dyscreen - 170, 300, 490 + state.dyscreen - 170);
			g3.fillRect(512, 481 + state.dyscreen - 170, 300, 490 + state.dyscreen - 170);
			g3.fillRect(837, 481 + state.dyscreen - 170, 75, 490 + state.dyscreen - 170);
			g3.fillRect(1059, 481 + state.dyscreen - 170, 75, 490 + state.dyscreen - 170);
       			g3.setColor(new Color(0.2, 0.2078431373, 0.2274509804));
			g3.fillRect(0, 490 + state.dyscreen - 170, 1295, 512 + state.dyscreen - 170);

			g3.setColor(new Color(color.r / 255, color.g / 255, color.b / 255));
			g3.setFont(fontscreensymb.deriveFont(Font.PLAIN, 40));
			g3.drawString(",", 161, 499 + state.dyscreen - 170);
			if ((state.displTick % 20) <= 10) g3.drawString(".", 161, 499 + state.dyscreen - 170);
			g3.drawString(",", 486, 499 + state.dyscreen - 170);
			g3.drawString(",", 810, 499 + state.dyscreen - 170);
			g3.drawString(",", 1133, 499 + state.dyscreen - 170);

			g3.setFont(fontscreensymb.deriveFont(Font.PLAIN, 13));
			g3.drawString("/", 936, 490 + state.dyscreen - 170);
			g3.drawString("/", 966, 490 + state.dyscreen - 170);
			g3.drawString("/", 996, 490 + state.dyscreen - 170);
			g3.drawString("/", 1026, 490 + state.dyscreen - 170);
			
			g3.setFont(fontscreentext.deriveFont(0, 30));
			drawStringCenter2(g3, nextstation, 161, 326 + state.dyscreen - 170);
			drawStringCenter2(g3, processName(thisPlatforms[nextstationIdThisRoute + 1].station.name), 486, 326 + state.dyscreen - 170);
			drawStringCenter2(g3, processName(thisPlatforms[nextstationIdThisRoute + 2].station.name), 810, 326 + state.dyscreen - 170);
			drawStringCenter2(g3, processName(thisPlatforms[linestationcount - 1].station.name), 1133, 326 + state.dyscreen - 170);
			g3.setColor(Color.WHITE);	
			g3.setFont(fontscreentext.deriveFont(0, 25));
			drawStringCenter2(g3, nextstationeng, 161, 386 + state.dyscreen - 170);
			drawStringCenter2(g3, processName2(thisPlatforms[nextstationIdThisRoute + 1].station.name), 486, 386 + state.dyscreen - 170);
			drawStringCenter2(g3, processName2(thisPlatforms[nextstationIdThisRoute + 2].station.name), 810, 386 + state.dyscreen - 170);
			drawStringCenter2(g3, processName2(thisPlatforms[linestationcount - 1].station.name), 1133, 386 + state.dyscreen - 170);
		}
		else if (nextstationId + 3 == linestationcount - 1) {
			//Текущая станция, следующая станция, следующая после следующей, конечная

				//Вывод стрелки на сером фоне (по y 130)
        			g3.setFont(fontscreentext.deriveFont(Font.PLAIN, 50));
				g3.setColor(new Color(146 / 255, 146 / 255, 146 / 255));
				g3.drawString("→", 20 + state.dxscreen, 396 + state.dyscreen - 170);
				g3.setColor(Color.WHITE);
				if ((state.displTick % 20) <= 10) g3.drawString("→", 20 + state.dxscreen, 396 + state.dyscreen - 170);
				g3.setFont(fontscreentext.deriveFont(1, 30));

			g3.setColor(new Color(146 / 255, 146 / 255, 146 / 255));
			g3.fillRect(0, 481 + state.dyscreen - 170, 82, 490 + state.dyscreen - 170);
			g3.setColor(new Color(color.r / 255, color.g / 255, color.b / 255));
			g3.fillRect(82, 481 + state.dyscreen - 170, 80, 490 + state.dyscreen - 170);
			g3.fillRect(188, 481 + state.dyscreen - 170, 300, 490 + state.dyscreen - 170);
			g3.fillRect(512, 481 + state.dyscreen - 170, 300, 490 + state.dyscreen - 170);
			g3.fillRect(837, 481 + state.dyscreen - 170, 297, 490 + state.dyscreen - 170);
       			g3.setColor(new Color(0.2, 0.2078431373, 0.2274509804));
			g3.fillRect(0, 492 + state.dyscreen - 170, 1295, 512 + state.dyscreen - 170);

			g3.setColor(new Color(color.r / 255, color.g / 255, color.b / 255));
			g3.setFont(fontscreensymb.deriveFont(Font.PLAIN, 40));
			g3.drawString(",", 161, 500 + state.dyscreen - 170);
			if ((state.displTick % 20) <= 10) g3.drawString(".", 161, 499 + state.dyscreen - 170);
			g3.drawString(",", 486, 500 + state.dyscreen - 170);
			g3.drawString(",", 810, 500 + state.dyscreen - 170);
			g3.drawString(",", 1133, 500 + state.dyscreen - 170);

			g3.setFont(fontscreentext.deriveFont(0, 30));
			drawStringCenter2(g3, nextstation, 161, 326 + state.dyscreen - 170);
			drawStringCenter2(g3, processName(thisPlatforms[nextstationIdThisRoute + 1].station.name), 486, 326 + state.dyscreen - 170);
			drawStringCenter2(g3, processName(thisPlatforms[nextstationIdThisRoute + 2].station.name), 810, 326 + state.dyscreen - 170);
			drawStringCenter2(g3, processName(thisPlatforms[linestationcount - 1].station.name), 1133, 326 + state.dyscreen - 170);
			g3.setColor(Color.WHITE);	
			g3.setFont(fontscreentext.deriveFont(0, 25));
			drawStringCenter2(g3, nextstationeng, 161, 386 + state.dyscreen - 170);
			drawStringCenter2(g3, processName2(thisPlatforms[nextstationIdThisRoute + 1].station.name), 486, 386 + state.dyscreen - 170);
			drawStringCenter2(g3, processName2(thisPlatforms[nextstationIdThisRoute + 2].station.name), 810, 386 + state.dyscreen - 170);
			drawStringCenter2(g3, processName2(thisPlatforms[linestationcount - 1].station.name), 1133, 386 + state.dyscreen - 170);
		}
		else if (nextstationId + 2 == linestationcount - 1) {
			//Предыдущая станция, текущая станция, следующая станция, конечная

				//Вывод стрелки на сером фоне (по y 130)
        			g3.setFont(fontscreentext.deriveFont(Font.PLAIN, 50));
				g3.setColor(new Color(146 / 255, 146 / 255, 146 / 255));
				g3.drawString("→", 300 + state.dxscreen, 396 + state.dyscreen - 170);
				g3.setColor(Color.WHITE);
				if ((state.displTick % 20) <= 10) g3.drawString("→", 300 + state.dxscreen, 396 + state.dyscreen - 170);
				g3.setFont(fontscreentext.deriveFont(1, 30));

			g3.setColor(new Color(146 / 255, 146 / 255, 146 / 255));
			g3.fillRect(0, 481 + state.dyscreen - 170, 162, 490 + state.dyscreen - 170);
			g3.fillRect(188, 481 + state.dyscreen - 170, 220, 490 + state.dyscreen - 170);

			g3.setColor(new Color(color.r / 255, color.g / 255, color.b / 255));
			g3.fillRect(408, 481 + state.dyscreen - 170, 80, 490 + state.dyscreen - 170);
			g3.fillRect(512, 481 + state.dyscreen - 170, 300, 490 + state.dyscreen - 170);
			g3.fillRect(837, 481 + state.dyscreen - 170, 297, 490 + state.dyscreen - 170);
       			g3.setColor(new Color(0.2, 0.2078431373, 0.2274509804));
			g3.fillRect(0, 490 + state.dyscreen - 170, 1295, 512 + state.dyscreen - 170);

			g3.setFont(fontscreensymb.deriveFont(Font.PLAIN, 40));
			g3.setColor(new Color(146 / 255, 146 / 255, 146 / 255));
			g3.drawString(",", 161, 499 + state.dyscreen - 170);
			g3.setColor(new Color(color.r / 255, color.g / 255, color.b / 255));
			if ((state.displTick % 20) <= 10) g3.drawString(".", 486, 499 + state.dyscreen - 170);
			g3.drawString(",", 486, 499 + state.dyscreen - 170);
			g3.drawString(",", 810, 499 + state.dyscreen - 170);
			g3.drawString(",", 1133, 499 + state.dyscreen - 170);
			
			g3.setFont(fontscreentext.deriveFont(0, 30));
			g3.setColor(new Color(146 / 255, 146 / 255, 146 / 255));
			drawStringCenter2(g3, processName(thisPlatforms[nextstationIdThisRoute - 2].station.name), 161, 326 + state.dyscreen - 170);
			drawStringCenter2(g3, processName2(thisPlatforms[nextstationIdThisRoute - 2].station.name), 161, 386 + state.dyscreen - 170);

			g3.setColor(new Color(color.r / 255, color.g / 255, color.b / 255));
			drawStringCenter2(g3, processName(nextstation), 486, 326 + state.dyscreen - 170);
			drawStringCenter2(g3, processName(thisPlatforms[nextstationIdThisRoute + 1].station.name), 810, 326 + state.dyscreen - 170);
			drawStringCenter2(g3, processName(thisPlatforms[linestationcount - 1].station.name), 1133, 326 + state.dyscreen - 170);
			g3.setColor(Color.WHITE);	
			g3.setFont(fontscreentext.deriveFont(0, 25));
			drawStringCenter2(g3, processName2(nextstationeng), 486, 386 + state.dyscreen - 170);
			drawStringCenter2(g3, processName2(thisPlatforms[nextstationIdThisRoute + 1].station.name), 810, 386 + state.dyscreen - 170);
			drawStringCenter2(g3, processName2(thisPlatforms[linestationcount - 1].station.name), 1133, 386 + state.dyscreen - 170);
		}
		else if (nextstationId + 1 == linestationcount - 1) {
			//Предыдущая перед предыдущей, предыдущая станция, текущая станция, конечная
			g3.setColor(new Color(color.r / 255, color.g / 255, color.b / 255));
			g3.setFont(fontscreensymb.deriveFont(Font.PLAIN, 30));
			g3.drawString(".", 161, 500 + state.dyscreen - 170);
			g3.drawString(".", 486, 500 + state.dyscreen - 170);
			g3.drawString(".", 810, 500 + state.dyscreen - 170);
			g3.drawString(",", 1133, 500 + state.dyscreen - 170);
		}
		else {			
			g3.setColor(new Color(color.r / 255, color.g / 255, color.b / 255));
			g3.setFont(fontscreensymb.deriveFont(Font.PLAIN, 30));
			g3.drawString(".", 161, 500 + state.dyscreen - 170);
			g3.drawString(".", 486, 500 + state.dyscreen - 170);
			g3.drawString(".", 810, 500 + state.dyscreen - 170);
			g3.drawString(".", 1133, 500 + state.dyscreen - 170);
		}
				
	}

	if (state.postCreateFunctionCalled) {
	if (state.infoArr[nextstationId + 1] != "") {
		let dxinter = 0;
		for (let i = 0; i < nextstationInterchLength; i++) {
			let interchInfo = nextstationInterch[i].split('\\_');
			let interchLine = interchInfo[1];
			let interchBackgr = interchInfo[2];
			let interchBackgr2 = interchInfo[3];
			let interchColorR = interchInfo[4];
			let interchColorG = interchInfo[5];
			let interchColorB = interchInfo[6];
			g3.setColor(Color.BLACK);
			g3.setFont(fontscreensymb.deriveFont(Font.PLAIN, 60));
			fontMetrics = g3.getFontMetrics();
			let interchWidth = fontMetrics.stringWidth(interchLine);
			g3.drawString(interchBackgr, 648 + dxinter, 220 + state.dyscreen - 170);
			g3.setColor(Color.WHITE);
			g3.drawString(interchBackgr2, 648 + dxinter, 220 + state.dyscreen - 170);
			g3.setColor(new Color(interchColorR / 255, interchColorG / 255, interchColorB / 255));
			g3.drawString(interchLine, 648 + dxinter, 220 + state.dyscreen - 170);
			dxinter = dxinter + interchWidth;		
		}
	}
	}
	}

	else {
 	       g3.setColor(Color.BLACK);
	      	g3.fillRect(0, 0, 1295, 256);
		g3.setColor(Color.WHITE);
		g3.setFont(fontscreentext.deriveFont(1, 50));
		drawStringCenter(g3, time, 1295, 150)
 	}
	state.dhHeadScreen.upload();
	});



       [
            { dhPromScreen: state.dhPromScreen, graphicsName: 'screenfront' },
            { dhPromScreen: state.dhPromScreen, graphicsName: 'screenback' },
        ].forEach((element) => {
//экран промежуточный вагон
	let g4 = state.dhPromScreen.graphicsFor(element.graphicsName);
	if (state.isOnRoute){

       		g4.setColor(new Color(0.2, 0.2078431373, 0.2274509804));
       		g4.fillRect(0, 0, 1295, 256);
	        g4.setColor(Color.BLACK);
        	g4.fillRect(0, 0, 1295, state.dyscreen);
		let nextstation = processName(getNextStation(train)) + " ";
		let nextstationeng = processName2(getNextStation(train));
		let str1 = ""
		let str2 = ""
		let str3 = ""
		let nextstationId = getNextStationId(train);
		let nextstationIdThisRoute = getNextStationIdThisRoute(train);
		let nextstationInterchLength = 0;
		let nextstationInterch = [];
		if (state.postCreateFunctionCalled && (nextstationId + 1) < state.infoArr.length) {
		nextstationInterch = state.infoArr[nextstationId + 1].split('\\-');
		nextstationInterchLength = nextstationInterch.length;
		}
		if (isItStation(train) || state.savedstation == nextstation) {
			state.savedstation = nextstation;
			str1 = " "
			str2 = " "
			str3 = " "
			state.displTick = 5;
		}
		else {
			state.savedstation = ""
			str1 = "→ "
			str2 = "Следующая "
			str3 = "The next station is "
		}
 
        g4.setColor(Color.WHITE);
	//Длина стрелки с пробелом
        g4.setFont(fontscreentext.deriveFont(Font.PLAIN, 50));
	let fontMetrics = g4.getFontMetrics();
	let str1width = fontMetrics.stringWidth(str1);
	//Длина текста между стрелкой и названием станции
	let str2width = fontMetrics.stringWidth(str2);
	//Длина названия станции
        g4.setFont(fontscreentext.deriveFont(1, 50));
	fontMetrics = g4.getFontMetrics();
	let nextstwidth = fontMetrics.stringWidth(nextstation);
	//Длина символа линии
	g4.setFont(fontscreensymb.deriveFont(Font.PLAIN, 50));
	fontMetrics = g4.getFontMetrics();
	let linewidth = fontMetrics.stringWidth(EMULineScreen);
	//Длина английского текста
        g4.setFont(fontscreentext.deriveFont(Font.PLAIN, 30));
	fontMetrics = g4.getFontMetrics();
	let str3width = fontMetrics.stringWidth(str3);
	//Длина английского названия станции
        g4.setFont(fontscreentext.deriveFont(1, 30));
	fontMetrics = g4.getFontMetrics();
	let nextstengwidth = fontMetrics.stringWidth(nextstationeng);
	
	let nachsm1 = (1295 - (str1width + str2width + nextstwidth + linewidth)) / 2;
	let nachsm2 = (1295 - (str3width + nextstengwidth)) / 2;

	g4.setFont(fontscreentext.deriveFont(Font.PLAIN, 50));

	//Вывод стрелки или пробелов на чёрном фоне
	if (state.displTick % 20 <= 10) state.dxscreen = -0.5 * (state.displTick % 20);
	else state.dxscreen = state.displTick % 20 * 0.5 - 10;
	g4.setColor(new Color(146 / 255, 146 / 255, 146 / 255));
	g4.drawString(str1, nachsm1 + state.dxscreen, 70 + state.dyscreen - 170);
	g4.setColor(Color.WHITE);
	if ((state.displTick % 20) <= 10) g4.drawString(str1, nachsm1 + state.dxscreen, 70 + state.dyscreen - 170);

	g4.setColor(new Color(color.r / 255, color.g / 255, color.b / 255));
	g4.drawString(str2, nachsm1 + str1width, 70 + state.dyscreen - 170);
	g4.setFont(fontscreentext.deriveFont(1, 50));
	g4.drawString(nextstation, nachsm1 + str1width + str2width, 70 + state.dyscreen - 170);

	//Вывод символов линий
	g4.setColor(Color.WHITE);
	g4.setFont(fontscreensymb.deriveFont(Font.PLAIN, 50));
	if (EMULineScreen == "1" || EMULineScreen == "2" || EMULineScreen == "3" || EMULineScreen == "4" || EMULineScreen == ";" || EMULineScreen == "5" || EMULineScreen == "6" || EMULineScreen == "7" || EMULineScreen == "8" || EMULineScreen == ":" || EMULineScreen == "9" || EMULineScreen == "*" || EMULineScreen == "(" || EMULineScreen == "%" || EMULineScreen == ")" || EMULineScreen == "0" || EMULineScreen == "+" || EMULineScreen == "&" || EMULineScreen == "!" || EMULineScreen == "{" || EMULineScreen == "$" || EMULineScreen == "}") {
	g4.drawString("/", nachsm1 + str1width + str2width + nextstwidth, 70 + state.dyscreen - 170);
}
else if (EMULineScreen == "<" || EMULineScreen == "=" || EMULineScreen == ">" || EMULineScreen == "?" || EMULineScreen == "r" || EMULineScreen == "@") {
	g4.drawString("^", nachsm1 + str1width + str2width + nextstwidth, 70 + state.dyscreen - 170);
}

	g4.setColor(new Color(color.r / 255, color.g / 255, color.b / 255));
	g4.drawString(EMULineScreen, nachsm1 + str1width + str2width + nextstwidth, 70 + state.dyscreen - 170);

	//Вывод текста на английском
	g4.setColor(Color.WHITE);
	g4.setFont(fontscreentext.deriveFont(Font.PLAIN, 30));
	g4.drawString(str3, nachsm2, 120 + state.dyscreen - 170);
	g4.setFont(fontscreentext.deriveFont(1, 30));
	g4.drawString(nextstationeng, nachsm2 + str3width, 120 + state.dyscreen - 170);

	//Линия
	let thisPlatforms = train.getThisRoutePlatforms();
	let linestationcount = thisPlatforms.size();

	if (linestationcount >= 4) {
		if (nextstationIdThisRoute + 3 < linestationcount - 1) {

			//Текущая станция, следующая станция, следующая после следующей ... конечная

				//Вывод стрелки на сером фоне (по y 130)
        			g4.setFont(fontscreentext.deriveFont(Font.PLAIN, 50));
				g4.setColor(new Color(146 / 255, 146 / 255, 146 / 255));
				g4.drawString("→", 20 + state.dxscreen, 396 + state.dyscreen - 170);
				g4.setColor(Color.WHITE);
				if ((state.displTick % 20) <= 10) g4.drawString("→", 20 + state.dxscreen, 396 + state.dyscreen - 170);
				g4.setFont(fontscreentext.deriveFont(1, 30));

			g4.setColor(new Color(146 / 255, 146 / 255, 146 / 255));
			g4.fillRect(0, 481 + state.dyscreen - 170, 82, 490 + state.dyscreen - 170);
			g4.setColor(new Color(color.r / 255, color.g / 255, color.b / 255));
			g4.fillRect(82, 481 + state.dyscreen - 170, 80, 490 + state.dyscreen - 170);
			g4.fillRect(188, 481 + state.dyscreen - 170, 300, 490 + state.dyscreen - 170);
			g4.fillRect(512, 481 + state.dyscreen - 170, 300, 490 + state.dyscreen - 170);
			g4.fillRect(837, 481 + state.dyscreen - 170, 75, 490 + state.dyscreen - 170);
			g4.fillRect(1059, 481 + state.dyscreen - 170, 75, 490 + state.dyscreen - 170);
       			g4.setColor(new Color(0.2, 0.2078431373, 0.2274509804));
			g4.fillRect(0, 490 + state.dyscreen - 170, 1295, 512 + state.dyscreen - 170);

			g4.setColor(new Color(color.r / 255, color.g / 255, color.b / 255));
			g4.setFont(fontscreensymb.deriveFont(Font.PLAIN, 40));
			g4.drawString(",", 161, 499 + state.dyscreen - 170);
			if ((state.displTick % 20) <= 10) g4.drawString(".", 161, 499 + state.dyscreen - 170);
			g4.drawString(",", 486, 499 + state.dyscreen - 170);
			g4.drawString(",", 810, 499 + state.dyscreen - 170);
			g4.drawString(",", 1133, 499 + state.dyscreen - 170);

			g4.setFont(fontscreensymb.deriveFont(Font.PLAIN, 13));
			g4.drawString("/", 936, 490 + state.dyscreen - 170);
			g4.drawString("/", 966, 490 + state.dyscreen - 170);
			g4.drawString("/", 996, 490 + state.dyscreen - 170);
			g4.drawString("/", 1026, 490 + state.dyscreen - 170);
			
			g4.setFont(fontscreentext.deriveFont(0, 30));
			drawStringCenter2(g4, nextstation, 161, 326 + state.dyscreen - 170);
			drawStringCenter2(g4, processName(thisPlatforms[nextstationIdThisRoute + 1].station.name), 486, 326 + state.dyscreen - 170);
			drawStringCenter2(g4, processName(thisPlatforms[nextstationIdThisRoute + 2].station.name), 810, 326 + state.dyscreen - 170);
			drawStringCenter2(g4, processName(thisPlatforms[linestationcount - 1].station.name), 1133, 326 + state.dyscreen - 170);
			g4.setColor(Color.WHITE);	
			g4.setFont(fontscreentext.deriveFont(0, 25));
			drawStringCenter2(g4, nextstationeng, 161, 386 + state.dyscreen - 170);
			drawStringCenter2(g4, processName2(thisPlatforms[nextstationIdThisRoute + 1].station.name), 486, 386 + state.dyscreen - 170);
			drawStringCenter2(g4, processName2(thisPlatforms[nextstationIdThisRoute + 2].station.name), 810, 386 + state.dyscreen - 170);
			drawStringCenter2(g4, processName2(thisPlatforms[linestationcount - 1].station.name), 1133, 386 + state.dyscreen - 170);
		}
		else if (nextstationId + 3 == linestationcount - 1) {
			//Текущая станция, следующая станция, следующая после следующей, конечная

				//Вывод стрелки на сером фоне (по y 130)
        			g4.setFont(fontscreentext.deriveFont(Font.PLAIN, 50));
				g4.setColor(new Color(146 / 255, 146 / 255, 146 / 255));
				g4.drawString("→", 20 + state.dxscreen, 396 + state.dyscreen - 170);
				g4.setColor(Color.WHITE);
				if ((state.displTick % 20) <= 10) g4.drawString("→", 20 + state.dxscreen, 396 + state.dyscreen - 170);
				g4.setFont(fontscreentext.deriveFont(1, 30));

			g4.setColor(new Color(146 / 255, 146 / 255, 146 / 255));
			g4.fillRect(0, 481 + state.dyscreen - 170, 82, 490 + state.dyscreen - 170);
			g4.setColor(new Color(color.r / 255, color.g / 255, color.b / 255));
			g4.fillRect(82, 481 + state.dyscreen - 170, 80, 490 + state.dyscreen - 170);
			g4.fillRect(188, 481 + state.dyscreen - 170, 300, 490 + state.dyscreen - 170);
			g4.fillRect(512, 481 + state.dyscreen - 170, 300, 490 + state.dyscreen - 170);
			g4.fillRect(837, 481 + state.dyscreen - 170, 297, 490 + state.dyscreen - 170);
       			g4.setColor(new Color(0.2, 0.2078431373, 0.2274509804));
			g4.fillRect(0, 492 + state.dyscreen - 170, 1295, 512 + state.dyscreen - 170);

			g4.setColor(new Color(color.r / 255, color.g / 255, color.b / 255));
			g4.setFont(fontscreensymb.deriveFont(Font.PLAIN, 40));
			g4.drawString(",", 161, 500 + state.dyscreen - 170);
			if ((state.displTick % 20) <= 10) g4.drawString(".", 161, 499 + state.dyscreen - 170);
			g4.drawString(",", 486, 500 + state.dyscreen - 170);
			g4.drawString(",", 810, 500 + state.dyscreen - 170);
			g4.drawString(",", 1133, 500 + state.dyscreen - 170);

			g4.setFont(fontscreentext.deriveFont(0, 30));
			drawStringCenter2(g4, nextstation, 161, 326 + state.dyscreen - 170);
			drawStringCenter2(g4, processName(thisPlatforms[nextstationIdThisRoute + 1].station.name), 486, 326 + state.dyscreen - 170);
			drawStringCenter2(g4, processName(thisPlatforms[nextstationIdThisRoute + 2].station.name), 810, 326 + state.dyscreen - 170);
			drawStringCenter2(g4, processName(thisPlatforms[linestationcount - 1].station.name), 1133, 326 + state.dyscreen - 170);
			g4.setColor(Color.WHITE);	
			g4.setFont(fontscreentext.deriveFont(0, 25));
			drawStringCenter2(g4, nextstationeng, 161, 386 + state.dyscreen - 170);
			drawStringCenter2(g4, processName2(thisPlatforms[nextstationIdThisRoute + 1].station.name), 486, 386 + state.dyscreen - 170);
			drawStringCenter2(g4, processName2(thisPlatforms[nextstationIdThisRoute + 2].station.name), 810, 386 + state.dyscreen - 170);
			drawStringCenter2(g4, processName2(thisPlatforms[linestationcount - 1].station.name), 1133, 386 + state.dyscreen - 170);
		}
		else if (nextstationId + 2 == linestationcount - 1) {
			//Предыдущая станция, текущая станция, следующая станция, конечная

				//Вывод стрелки на сером фоне (по y 130)
        			g4.setFont(fontscreentext.deriveFont(Font.PLAIN, 50));
				g4.setColor(new Color(146 / 255, 146 / 255, 146 / 255));
				g4.drawString("→", 300 + state.dxscreen, 396 + state.dyscreen - 170);
				g4.setColor(Color.WHITE);
				if ((state.displTick % 20) <= 10) g4.drawString("→", 300 + state.dxscreen, 396 + state.dyscreen - 170);
				g4.setFont(fontscreentext.deriveFont(1, 30));

			g4.setColor(new Color(146 / 255, 146 / 255, 146 / 255));
			g4.fillRect(0, 481 + state.dyscreen - 170, 162, 490 + state.dyscreen - 170);
			g4.fillRect(188, 481 + state.dyscreen - 170, 220, 490 + state.dyscreen - 170);

			g4.setColor(new Color(color.r / 255, color.g / 255, color.b / 255));
			g4.fillRect(408, 481 + state.dyscreen - 170, 80, 490 + state.dyscreen - 170);
			g4.fillRect(512, 481 + state.dyscreen - 170, 300, 490 + state.dyscreen - 170);
			g4.fillRect(837, 481 + state.dyscreen - 170, 297, 490 + state.dyscreen - 170);
       			g4.setColor(new Color(0.2, 0.2078431373, 0.2274509804));
			g4.fillRect(0, 490 + state.dyscreen - 170, 1295, 512 + state.dyscreen - 170);

			g4.setFont(fontscreensymb.deriveFont(Font.PLAIN, 40));
			g4.setColor(new Color(146 / 255, 146 / 255, 146 / 255));
			g4.drawString(",", 161, 499 + state.dyscreen - 170);
			g4.setColor(new Color(color.r / 255, color.g / 255, color.b / 255));
			if ((state.displTick % 20) <= 10) g4.drawString(".", 486, 499 + state.dyscreen - 170);
			g4.drawString(",", 486, 499 + state.dyscreen - 170);
			g4.drawString(",", 810, 499 + state.dyscreen - 170);
			g4.drawString(",", 1133, 499 + state.dyscreen - 170);
			
			g4.setFont(fontscreentext.deriveFont(0, 30));
			g4.setColor(new Color(146 / 255, 146 / 255, 146 / 255));
			drawStringCenter2(g4, processName(thisPlatforms[nextstationIdThisRoute - 2].station.name), 161, 326 + state.dyscreen - 170);
			drawStringCenter2(g4, processName2(thisPlatforms[nextstationIdThisRoute - 2].station.name), 161, 386 + state.dyscreen - 170);

			g4.setColor(new Color(color.r / 255, color.g / 255, color.b / 255));
			drawStringCenter2(g4, processName(nextstation), 486, 326 + state.dyscreen - 170);
			drawStringCenter2(g4, processName(thisPlatforms[nextstationIdThisRoute + 1].station.name), 810, 326 + state.dyscreen - 170);
			drawStringCenter2(g4, processName(thisPlatforms[linestationcount - 1].station.name), 1133, 326 + state.dyscreen - 170);
			g4.setColor(Color.WHITE);	
			g4.setFont(fontscreentext.deriveFont(0, 25));
			drawStringCenter2(g4, processName2(nextstationeng), 486, 386 + state.dyscreen - 170);
			drawStringCenter2(g4, processName2(thisPlatforms[nextstationIdThisRoute + 1].station.name), 810, 386 + state.dyscreen - 170);
			drawStringCenter2(g4, processName2(thisPlatforms[linestationcount - 1].station.name), 1133, 386 + state.dyscreen - 170);
		}
		else if (nextstationId + 1 == linestationcount - 1) {
			//Предыдущая перед предыдущей, предыдущая станция, текущая станция, конечная
			g4.setColor(new Color(color.r / 255, color.g / 255, color.b / 255));
			g4.setFont(fontscreensymb.deriveFont(Font.PLAIN, 30));
			g4.drawString(".", 161, 500 + state.dyscreen - 170);
			g4.drawString(".", 486, 500 + state.dyscreen - 170);
			g4.drawString(".", 810, 500 + state.dyscreen - 170);
			g4.drawString(",", 1133, 500 + state.dyscreen - 170);
		}
		else {			
			g4.setColor(new Color(color.r / 255, color.g / 255, color.b / 255));
			g4.setFont(fontscreensymb.deriveFont(Font.PLAIN, 30));
			g4.drawString(".", 161, 500 + state.dyscreen - 170);
			g4.drawString(".", 486, 500 + state.dyscreen - 170);
			g4.drawString(".", 810, 500 + state.dyscreen - 170);
			g4.drawString(".", 1133, 500 + state.dyscreen - 170);
		}
				
	}

	if (state.postCreateFunctionCalled) {
	if (state.infoArr[nextstationId + 1] != "") {
		let dxinter = 0;
		for (let i = 0; i < nextstationInterchLength; i++) {
			let interchInfo = nextstationInterch[i].split('\\_');
			let interchLine = interchInfo[1];
			let interchBackgr = interchInfo[2];
			let interchBackgr2 = interchInfo[3];
			let interchColorR = interchInfo[4];
			let interchColorG = interchInfo[5];
			let interchColorB = interchInfo[6];
			g4.setColor(Color.BLACK);
			g4.setFont(fontscreensymb.deriveFont(Font.PLAIN, 60));
			fontMetrics = g3.getFontMetrics();
			let interchWidth = fontMetrics.stringWidth(interchLine);
			g4.drawString(interchBackgr, 648 + dxinter, 220 + state.dyscreen - 170);
			g4.setColor(Color.WHITE);
			g4.drawString(interchBackgr2, 648 + dxinter, 220 + state.dyscreen - 170);
			g4.setColor(new Color(interchColorR / 255, interchColorG / 255, interchColorB / 255));
			g4.drawString(interchLine, 648 + dxinter, 220 + state.dyscreen - 170);
			dxinter = dxinter + interchWidth;		
		}
	}
	}
	}

	else {
 	       g4.setColor(Color.BLACK);
	      	g4.fillRect(0, 0, 1295, 256);
		g4.setColor(Color.WHITE);
		g4.setFont(fontscreentext.deriveFont(1, 50));
		drawStringCenter(g4, time, 1295, 150)
 	}
	state.dhPromScreen.upload();
	});
}

function processName(a) {
	let aJsStr = "" + a;
	if (a.includes('|')) {

		let strs = aJsStr.split('|')
		aJsStr = strs[0];
	}
	return aJsStr;
}

function processName2(a) {
	let aJsStr = "" + a;
	if (a.includes('|')) {
		let strs = aJsStr.split('|')
		aJsStr = strs[1]
	}
	return aJsStr;
}

function clamp(num, min, max) {
  return Math.min(Math.max(num, min), max);
} 

function getRouteNum(train) {
	let stationList = train.getThisRoutePlatforms();
	let ret = stationList[0].route.lightRailRouteNumber + "";
if (ret != "") ret += " ";
  return ret;
}

function getRouteNum2(train) {
	let stationList = train.getThisRoutePlatforms();
	let ret = stationList[0].route.lightRailRouteNumber + "";
	return ret;
}

function getRouteColor(train) {
	let stationList = train.getThisRoutePlatforms();
	let ret = stationList[0].route.color;
	return decodeColor(ret);
}

function decodeColor(color) {
  let r = (color >> 16) & 0xFF;  // Извлекаем старший байт для красного
  let g = (color >> 8) & 0xFF;   // Извлекаем средний байт для зеленого
  let b = color & 0xFF;          // Извлекаем младший байт для синего
  return { r, g, b };
}

function getEndStation(train) {
  let stationList = train.getThisRoutePlatforms();
  let lastSt = stationList.size() - 1;
  let regularEndStation = stationList[lastSt].station.name;
  let customEndStation = stationList[lastSt].route.platformIds[lastSt].customDestination + "";

  return customEndStation == "" ? regularEndStation.toUpperCase() : customEndStation.toUpperCase();
}

function getNextStation(train) {
  let stationList = train.getThisRoutePlatforms();
  let nextstationindex = train.getThisRoutePlatformsNextIndex();
  
  return stationList[nextstationindex].station.name;
}

function getNextStationId(train) {
  let stationList = train.getAllPlatforms();
  let nextstationindex = train.getAllPlatformsNextIndex();
  
  return nextstationindex;
}

function getNextStationIdThisRoute(train) {
  let stationList = train.getThisRoutePlatforms();
  let nextstationindex = train.getThisRoutePlatformsNextIndex();
  
  return nextstationindex;
}

function isItStation(train) {
	let stoptime = train.path()[train.getRailIndex(train.getRailProgress(0), false)].dwellTime;
	return stoptime != 0;
}

function drawStringCenter(g, string, x, y){
  let fontMetrics = g.getFontMetrics();
  const newX = (x - fontMetrics.stringWidth(string)) / 2;

  g.drawString(string, newX, y)
} 

function drawStringCenter2(g, string, x, y){
  let fontMetrics = g.getFontMetrics();
  const newX = x - fontMetrics.stringWidth(string) / 2;

  g.drawString(string, newX, y)
}