include(Resources.idRelative("mtr:lib/harrys_lib.js"));

var renderWindows = false;

var rawModels = ModelManager.loadPartedRawModel(Resources.manager(), Resources.idRelative("mtr:ep2dm/ep2dm_head.obj"), null);
var head = uploadPartedModels(rawModels, true, true);

var rawModels2 = ModelManager.loadPartedRawModel(Resources.manager(), Resources.idRelative("mtr:ep2dm/ep2dmbogie_head.obj"), null);
var bogiehead = uploadPartedModels(rawModels2, true, true);

var rawModels3 = ModelManager.loadPartedRawModel(Resources.manager(), Resources.idRelative("mtr:ep2dm/ep2dm_motor.obj"), null);
var motor = uploadPartedModels(rawModels3, true, true);

var rawModels4 = ModelManager.loadPartedRawModel(Resources.manager(), Resources.idRelative("mtr:ep2dm/ep2dmbogie_motor.obj"), null);
var bogiemotor = uploadPartedModels(rawModels4, true, true);

var rawModels5 = ModelManager.loadPartedRawModel(Resources.manager(), Resources.idRelative("mtr:ep2dm/ep2dm_prom.obj"), null);
var prom = uploadPartedModels(rawModels5, true, true);

var rawModels6 = ModelManager.loadPartedRawModel(Resources.manager(), Resources.idRelative("mtr:ep2dm/ep2dmbogie_prom.obj"), null);
var bogieprom = uploadPartedModels(rawModels6, true, true);

function create(ctx, state, train) {

	initRoll(train, state);
	initRocking(train, state);

	state.postCreateFunctionCalled = false;

	state.extDoorLightTimer = 0.0;
	state.extDoorLightFlag = false;
	state.oldDoorVal = train.doorValue();
	state.wheelAngle = 0.0; // Градус поворота колеса радиусом 1 метр. Градус колеса радиуса x, очевидно, будет в два 1/x раз больше (или меньше)
	state.extDoorLightLeftMemory = new Array(train.trainCars());
	state.extDoorLightRightMemory = new Array(train.trainCars());

	for (let i = 0; i < train.trainCars(); i++) {
		// door memory
		state.extDoorLightLeftMemory[i] = train.doorLeftOpen[i];
		state.extDoorLightRightMemory[i] = train.doorRightOpen[i];
	}
}


function dispose(ctx, state, train) {

}

function render(ctx, state, train) {
	state.wheelRadius = 0.4792;
	updateLogic(state, train);
	renderLogic(ctx, state, train);
	updateSpeedStates(train, state);
	updateWheelAngle(train, state);	
}

function updateLogic(state, train) {
	updateRoll(train, state, -0.5);
	updateRocking(train, state, 140, 88, 20, 27);
	updateExtLights(train, state);
}

function updateExtLights(train, state) {
	if (train.doorValue() > 0.0 && train.doorValue() < 1.0 && state.oldDoorVal > train.doorValue()) {
		if (!state.extDoorLightFlag) {
			state.extDoorLightTimer = 9.0;
			for (let i = 0; i < train.trainCars(); i++) {
				state.extDoorLightLeftMemory[i] = train.doorLeftOpen[i];
				state.extDoorLightRightMemory[i] = train.doorRightOpen[i];
			}
		}
		state.extDoorLightFlag = true;
	}

	if (state.extDoorLightTimer > 0) {
		state.extDoorLightTimer -= Timing.delta();
	}

	if (state.extDoorLightTimer <= 0) {
		state.extDoorLightTimer = 0;
		state.extDoorLightFlag = false;
	} 

	state.oldDoorVal = train.doorValue();
}

function renderLogic(ctx, state, train) {
	let matrices = new Matrices();
	renderHead(ctx, state, train, 0, matrices);

	if (train.trainCars() > 1) {
		renderMotor(ctx, state, train, 1, matrices);

		if (train.trainCars() == 11) {
			renderProm(ctx, state, train, 2, matrices);
			renderMotor(ctx, state, train, 3, matrices);
			renderProm(ctx, state, train, 4, matrices);
			renderMotor(ctx, state, train, 5, matrices);
			renderMotorRev(ctx, state, train, 6, matrices);
			renderPromRev(ctx, state, train, 7, matrices);
			renderPromRev(ctx, state, train, 8, matrices);
			renderMotorRev(ctx, state, train, 9, matrices);
		}
		else if (train.trainCars() == 10) {
			renderProm(ctx, state, train, 2, matrices);
			renderMotor(ctx, state, train, 3, matrices);
			renderProm(ctx, state, train, 4, matrices);
			renderMotor(ctx, state, train, 5, matrices);
			renderMotorRev(ctx, state, train, 6, matrices);
			renderPromRev(ctx, state, train, 7, matrices);
			renderMotorRev(ctx, state, train, 8, matrices);
		}
		else if (train.trainCars() == 9) {
			renderProm(ctx, state, train, 2, matrices);
			renderMotor(ctx, state, train, 3, matrices);
			renderMotorRev(ctx, state, train, 4, matrices);
			renderPromRev(ctx, state, train, 5, matrices);
			renderPromRev(ctx, state, train, 6, matrices);
			renderMotorRev(ctx, state, train, 7, matrices);
		}
		else if (train.trainCars() == 8) {
			renderProm(ctx, state, train, 2, matrices);
			renderMotor(ctx, state, train, 3, matrices);
			renderMotorRev(ctx, state, train, 4, matrices);
			renderPromRev(ctx, state, train, 5, matrices);
			renderMotorRev(ctx, state, train, 6, matrices);
		}
		else if (train.trainCars() == 7) {
			renderProm(ctx, state, train, 2, matrices);
			renderMotor(ctx, state, train, 3, matrices);
			renderMotorRev(ctx, state, train, 4, matrices);
			renderPromRev(ctx, state, train, 5, matrices);
		}
		else if (train.trainCars() == 6) {
			renderProm(ctx, state, train, 2, matrices);
			renderMotor(ctx, state, train, 3, matrices);
			renderMotorRev(ctx, state, train, 4, matrices);
		}
		else if (train.trainCars() == 5) {
			renderMotorRev(ctx, state, train, 2, matrices);
			renderPromRev(ctx, state, train, 3, matrices);
		}
		else {
			renderMotorRev(ctx, state, train, 2, matrices);
		}
		
		renderTail(ctx, state, train, train.trainCars()-1, matrices);
	}
}

function renderHead(ctx, state, train, i, matrices) {
	let roll = state.rolls[i];
	roll = clamp(roll, -0.03, 0.03);
	let speedKmph = train.speed() * 20 * 3.6;
	let speedCoef = speedKmph > 20.0 ? 1.0 : speedKmph / 40 + 0.5;
	let rockZ = (state.rockingZCoef + i * 0.2) % 1.0;
	let rockX = (state.rockingXCoef +  0.2 * i) % 1.0;
	let totalXrotation = speedCoef * chaoticRotate(rockX) * 0.5;
	let totalZrotation = speedCoef * chaoticRotate2(rockZ) * 5 + roll;
	let wheelAngleCoef = state.wheelAngle/state.wheelRadius; // поворот колеса радиуса wheelRadius

	let renderFrontLights = !train.isReversed();

	let isLeftOpened = train.doorLeftOpen[i];
	let isRightOpened = train.doorRightOpen[i];
	let doorValue = train.doorValue();
	let shouldRenderL = !train.isDoorOpening() && doorValue < 1 && isLeftOpened && (doorValue % 0.1) > 0.05; 
	let shouldRenderR = !train.isDoorOpening() && doorValue < 1 && isRightOpened && (doorValue % 0.1) > 0.05; 

	// BOGIES	
	matrices.pushPose();
	ctx.drawCarModel(bogiehead["TELEGI"], i, matrices);
	renderWheel(ctx, matrices, bogiehead["KOLPARA1"], wheelAngleCoef, i, -0.2104, 8.6058); 
	renderWheel(ctx, matrices, bogiehead["KOLPARA2"], wheelAngleCoef, i, -0.2104, 6.2061);
	renderWheel(ctx, matrices, bogiehead["KOLPARA3"], wheelAngleCoef, i, -0.2104, -6.1886);
	renderWheel(ctx, matrices, bogiehead["KOLPARA4"], wheelAngleCoef, i, -0.2104, -8.5882);
	matrices.popPose();
	
	matrices.pushPose();
	matrices.rotateZ(totalZrotation);
	matrices.rotateZ(totalXrotation);


	ctx.drawCarModel(state.dh.model, i, matrices);
	ctx.drawCarModel(state.dhHeadScreen.model, i, matrices);

	ctx.drawCarModel(head["EXT"], i, matrices);
	ctx.drawCarModel(head["INT"], i, matrices);
	ctx.drawCarModel(head["INTLAMPS"], i, matrices);
	ctx.drawCarModel(head["CTRL"], i, matrices);
	ctx.drawCarModel(head["REVERS"], i, matrices);
	ctx.drawCarModel(head["CABLAMPS"], i, matrices);
	ctx.drawCarModel(head["MOGILI"], i, matrices);
	ctx.drawCarModel(head["TIKVI"], i, matrices);

	if (speedKmph == 0) {
		ctx.drawCarModel(head["TAMBLAMP2"], i, matrices);
	}

	//FARY
	if (renderFrontLights) {
		ctx.drawCarModel(head["FARY"], i, matrices);
		ctx.drawCarModel(head["SKULL_BRIG"], i, matrices);
	} else {
		ctx.drawCarModel(head["BUF"], i, matrices);
		ctx.drawCarModel(head["SKULL_TOILET"], i, matrices);
	}
	//EXTERIOR DOOR INDICATORS
	if (shouldRenderL) {
		ctx.drawCarModel(head["D_LIGHT_L"], i, matrices);
	}
	if (shouldRenderR) {
		ctx.drawCarModel(head["D_LIGHT_R"], i, matrices);
	}
	//DOORS
	renderDoorHalf(ctx, train, state, i, matrices, head["D_LF_EXT"], head["D_LF_INT"], null, null, 0.04, 0.08, 0, 0.64, false)

	renderDoorHalf(ctx, train, state, i, matrices, head["D_LB_EXT"], head["D_LB_INT"], null, null, 0.04, -0.08, 0, -0.64, false)

	renderDoorHalf(ctx, train, state, i, matrices, head["D_RB_EXT"], head["D_RB_INT"], null, null, -0.04, -0.08, 0, -0.64, true)

	renderDoorHalf(ctx, train, state, i, matrices, head["D_RF_EXT"], head["D_RF_INT"], null, null, -0.04, 0.08, 0, 0.64, true)

	matrices.popPose();
}

function renderMotor(ctx, state, train, i, matrices) {
	let roll = state.rolls[i];
	roll = clamp(roll, -0.03, 0.03);
	let speedKmph = train.speed() * 20 * 3.6;
	let speedCoef = speedKmph > 20.0 ? 1.0 : speedKmph / 40 + 0.5;
	let rockZ = (state.rockingZCoef + i * 0.2) % 1.0;
	let rockX = (state.rockingXCoef +  0.2 * i) % 1.0;
	let totalXrotation = speedCoef * chaoticRotate(rockX) * 0.5;
	let totalZrotation = speedCoef * chaoticRotate2(rockZ) * 5 + roll;
	let wheelAngleCoef = state.wheelAngle/state.wheelRadius; // поворот колеса радиуса wheelRadius

	let isLeftOpened = train.doorLeftOpen[i];
	let isRightOpened = train.doorRightOpen[i];
	let doorValue = train.doorValue();
	let shouldRenderL = !train.isDoorOpening() && doorValue < 1 && isLeftOpened && (doorValue % 0.1) > 0.05; 
	let shouldRenderR = !train.isDoorOpening() && doorValue < 1 && isRightOpened && (doorValue % 0.1) > 0.05; 

	// BOGIES	
	matrices.pushPose();
	ctx.drawCarModel(bogiemotor["TELEGI"], i, matrices);
	renderWheel(ctx, matrices, bogiemotor["KOLPARA1"], wheelAngleCoef, i, -0.2104, -8.5876); 
	renderWheel(ctx, matrices, bogiemotor["KOLPARA2"], wheelAngleCoef, i, -0.2104, -6.1879);
	renderWheel(ctx, matrices, bogiemotor["KOLPARA3"], wheelAngleCoef, i, -0.2104, 6.1879);
	renderWheel(ctx, matrices, bogiemotor["KOLPARA4"], wheelAngleCoef, i, -0.2104, 8.5876);
	matrices.popPose();
	
	matrices.pushPose();
	matrices.rotateX(0.0005);
	matrices.rotateZ(totalZrotation);
	matrices.rotateZ(totalXrotation);

	ctx.drawCarModel(state.dhMotor.model, i, matrices);
	ctx.drawCarModel(state.dhPromScreen.model, i, matrices);

	ctx.drawCarModel(motor["EXT"], i, matrices);
	ctx.drawCarModel(motor["INT"], i, matrices);
	ctx.drawCarModel(motor["TIKVI"], i, matrices);
	ctx.drawCarModel(motor["MOGILI"], i, matrices);
	ctx.drawCarModel(motor["INTLAMPS"], i, matrices);

	if (speedKmph == 0) {
		ctx.drawCarModel(motor["TAMBLAMP2"], i, matrices);
	}

	//EXTERIOR DOOR INDICATORS
	if (shouldRenderL) {
		ctx.drawCarModel(motor["D_LIGHT_L"], i, matrices);
	}
	if (shouldRenderR) {
		ctx.drawCarModel(motor["D_LIGHT_R"], i, matrices);
	}
	//DOORS
	renderDoorHalf(ctx, train, state, i, matrices, motor["D_LF_EXT"], motor["D_LF_INT"], null, null, 0.04, 0.08, 0, 0.64, false)

	renderDoorHalf(ctx, train, state, i, matrices, motor["D_LB_EXT"], motor["D_LB_INT"], null, null, 0.04, -0.08, 0, -0.64, false)

	renderDoorHalf(ctx, train, state, i, matrices, motor["D_RB_EXT"], motor["D_RB_INT"], null, null, -0.04, -0.08, 0, -0.64, true)

	renderDoorHalf(ctx, train, state, i, matrices, motor["D_RF_EXT"], motor["D_RF_INT"], null, null, -0.04, 0.08, 0, 0.64, true)

	matrices.popPose();
}

function renderMotorRev(ctx, state, train, i, matrices) {
	let roll = state.rolls[i];
	roll = clamp(roll, -0.03, 0.03);
	let speedKmph = train.speed() * 20 * 3.6;
	let speedCoef = speedKmph > 20.0 ? 1.0 : speedKmph / 40 + 0.5;
	let rockZ = (state.rockingZCoef + i * 0.2) % 1.0;
	let rockX = (state.rockingXCoef +  0.2 * i) % 1.0;
	let totalXrotation = speedCoef * chaoticRotate(rockX) * 0.5;
	let totalZrotation = speedCoef * chaoticRotate2(rockZ) * 5 + roll;
	let wheelAngleCoef = state.wheelAngle/state.wheelRadius; // поворот колеса радиуса wheelRadius

	let isLeftOpened = train.doorLeftOpen[i];
	let isRightOpened = train.doorRightOpen[i];
	let doorValue = train.doorValue();
	let shouldRenderR = !train.isDoorOpening() && doorValue < 1 && isLeftOpened && (doorValue % 0.1) > 0.05; 
	let shouldRenderL = !train.isDoorOpening() && doorValue < 1 && isRightOpened && (doorValue % 0.1) > 0.05; 

	// BOGIES	
	matrices.pushPose();
	ctx.drawCarModel(bogiemotor["TELEGI"], i, matrices);
	renderWheel(ctx, matrices, bogiemotor["KOLPARA1"], wheelAngleCoef, i, -0.2104, -8.5876); 
	renderWheel(ctx, matrices, bogiemotor["KOLPARA2"], wheelAngleCoef, i, -0.2104, -6.1879);
	renderWheel(ctx, matrices, bogiemotor["KOLPARA3"], wheelAngleCoef, i, -0.2104, 6.1879);
	renderWheel(ctx, matrices, bogiemotor["KOLPARA4"], wheelAngleCoef, i, -0.2104, 8.5876);
	matrices.popPose();
	
	matrices.pushPose();
	matrices.rotateX(0.0005);
	matrices.rotateZ(totalZrotation);
	matrices.rotateZ(totalXrotation);
	matrices.rotateY(3.1415);

	ctx.drawCarModel(state.dhMotor.model, i, matrices);
	ctx.drawCarModel(state.dhPromScreen.model, i, matrices);

	ctx.drawCarModel(motor["EXT"], i, matrices);
	ctx.drawCarModel(motor["INT"], i, matrices);
	ctx.drawCarModel(motor["TIKVI"], i, matrices);
	ctx.drawCarModel(motor["MOGILI"], i, matrices);
	ctx.drawCarModel(motor["INTLAMPS"], i, matrices);

	if (speedKmph == 0) {
		ctx.drawCarModel(motor["TAMBLAMP2"], i, matrices);
	}

	//EXTERIOR DOOR INDICATORS
	if (shouldRenderL) {
		ctx.drawCarModel(motor["D_LIGHT_L"], i, matrices);
	}
	if (shouldRenderR) {
		ctx.drawCarModel(motor["D_LIGHT_R"], i, matrices);
	}
	//DOORS
	renderDoorHalf(ctx, train, state, i, matrices, motor["D_LF_EXT"], motor["D_LF_INT"], null, null, 0.04, 0.08, 0, 0.64, true)

	renderDoorHalf(ctx, train, state, i, matrices, motor["D_LB_EXT"], motor["D_LB_INT"], null, null, 0.04, -0.08, 0, -0.64, true)

	renderDoorHalf(ctx, train, state, i, matrices, motor["D_RB_EXT"], motor["D_RB_INT"], null, null, -0.04, -0.08, 0, -0.64, false)

	renderDoorHalf(ctx, train, state, i, matrices, motor["D_RF_EXT"], motor["D_RF_INT"], null, null, -0.04, 0.08, 0, 0.64, false)

	matrices.popPose();
}

function renderProm(ctx, state, train, i, matrices) {
	let roll = state.rolls[i];
	roll = clamp(roll, -0.03, 0.03);
	let speedKmph = train.speed() * 20 * 3.6;
	let speedCoef = speedKmph > 20.0 ? 1.0 : speedKmph / 40 + 0.5;
	let rockZ = (state.rockingZCoef + i * 0.2) % 1.0;
	let rockX = (state.rockingXCoef +  0.2 * i) % 1.0;
	let totalXrotation = speedCoef * chaoticRotate(rockX) * 0.5;
	let totalZrotation = speedCoef * chaoticRotate2(rockZ) * 5 + roll;
	let wheelAngleCoef = state.wheelAngle/state.wheelRadius; // поворот колеса радиуса wheelRadius

	let isLeftOpened = train.doorLeftOpen[i];
	let isRightOpened = train.doorRightOpen[i];
	let doorValue = train.doorValue();
	let shouldRenderL = !train.isDoorOpening() && doorValue < 1 && isLeftOpened && (doorValue % 0.1) > 0.05; 
	let shouldRenderR = !train.isDoorOpening() && doorValue < 1 && isRightOpened && (doorValue % 0.1) > 0.05; 

	// BOGIES	
	matrices.pushPose();
	ctx.drawCarModel(bogieprom["TELEGI"], i, matrices);
	renderWheel(ctx, matrices, bogieprom["KOLPARA1"], wheelAngleCoef, i, -0.2104, 8.5949); 
	renderWheel(ctx, matrices, bogieprom["KOLPARA2"], wheelAngleCoef, i, -0.2104, 6.1953);
	renderWheel(ctx, matrices, bogieprom["KOLPARA3"], wheelAngleCoef, i, -0.2104, -6.1879);
	renderWheel(ctx, matrices, bogieprom["KOLPARA4"], wheelAngleCoef, i, -0.2104, -8.5876);
	matrices.popPose();
	
	matrices.pushPose();
	matrices.rotateX(0.0005);
	matrices.rotateZ(totalZrotation);
	matrices.rotateZ(totalXrotation);

	ctx.drawCarModel(state.dhPromScreen.model, i, matrices);

	ctx.drawCarModel(prom["EXT"], i, matrices);
	ctx.drawCarModel(prom["INT"], i, matrices);
	ctx.drawCarModel(prom["MOGILI"], i, matrices);
	ctx.drawCarModel(prom["TIKVI"], i, matrices);
	ctx.drawCarModel(prom["INTLAMPS"], i, matrices);
	ctx.drawCarModel(prom["SKULS"], i, matrices);

	if (speedKmph == 0) {
		ctx.drawCarModel(prom["TAMBLAMP2"], i, matrices);
	}

	//EXTERIOR DOOR INDICATORS
	if (shouldRenderL) {
		ctx.drawCarModel(prom["D_LIGHT_L"], i, matrices);
	}
	if (shouldRenderR) {
		ctx.drawCarModel(prom["D_LIGHT_R"], i, matrices);
	}
	//DOORS
	renderDoorHalf(ctx, train, state, i, matrices, prom["D_LF_EXT"], prom["D_LF_INT"], null, null, 0.04, 0.08, 0, 0.64, false)

	renderDoorHalf(ctx, train, state, i, matrices, prom["D_LB_EXT"], prom["D_LB_INT"], null, null, 0.04, -0.08, 0, -0.64, false)

	renderDoorHalf(ctx, train, state, i, matrices, prom["D_RB_EXT"], prom["D_RB_INT"], null, null, -0.04, -0.08, 0, -0.64, true)

	renderDoorHalf(ctx, train, state, i, matrices, prom["D_RF_EXT"], prom["D_RF_INT"], null, null, -0.04, 0.08, 0, 0.64, true)

	matrices.popPose();
}

function renderPromRev(ctx, state, train, i, matrices) {
	let roll = state.rolls[i];
	roll = clamp(roll, -0.03, 0.03);
	let speedKmph = train.speed() * 20 * 3.6;
	let speedCoef = speedKmph > 20.0 ? 1.0 : speedKmph / 40 + 0.5;
	let rockZ = (state.rockingZCoef + i * 0.2) % 1.0;
	let rockX = (state.rockingXCoef +  0.2 * i) % 1.0;
	let totalXrotation = speedCoef * chaoticRotate(rockX) * 0.5;
	let totalZrotation = speedCoef * chaoticRotate2(rockZ) * 5 + roll;
	let wheelAngleCoef = state.wheelAngle/state.wheelRadius; // поворот колеса радиуса wheelRadius

	let isLeftOpened = train.doorLeftOpen[i];
	let isRightOpened = train.doorRightOpen[i];
	let doorValue = train.doorValue();
	let shouldRenderR = !train.isDoorOpening() && doorValue < 1 && isLeftOpened && (doorValue % 0.1) > 0.05; 
	let shouldRenderL = !train.isDoorOpening() && doorValue < 1 && isRightOpened && (doorValue % 0.1) > 0.05; 

	// BOGIES	
	matrices.pushPose();
	ctx.drawCarModel(bogieprom["TELEGI"], i, matrices);
	renderWheel(ctx, matrices, bogieprom["KOLPARA1"], wheelAngleCoef, i, -0.2104, 8.5949); 
	renderWheel(ctx, matrices, bogieprom["KOLPARA2"], wheelAngleCoef, i, -0.2104, 6.1953);
	renderWheel(ctx, matrices, bogieprom["KOLPARA3"], wheelAngleCoef, i, -0.2104, -6.1879);
	renderWheel(ctx, matrices, bogieprom["KOLPARA4"], wheelAngleCoef, i, -0.2104, -8.5876);
	matrices.popPose();
	
	matrices.pushPose();
	matrices.rotateX(0.0005);
	matrices.rotateZ(totalZrotation);
	matrices.rotateZ(totalXrotation);
	matrices.rotateY(3.1415);

	ctx.drawCarModel(state.dhPromScreen.model, i, matrices);

	ctx.drawCarModel(prom["EXT"], i, matrices);
	ctx.drawCarModel(prom["INT"], i, matrices);
	ctx.drawCarModel(prom["INTLAMPS"], i, matrices);
	ctx.drawCarModel(prom["MOGILI"], i, matrices);
	ctx.drawCarModel(prom["TIKVI"], i, matrices);
	ctx.drawCarModel(prom["SKULS"], i, matrices);

	if (speedKmph == 0) {
		ctx.drawCarModel(prom["TAMBLAMP2"], i, matrices);
	}

	//EXTERIOR DOOR INDICATORS
	if (shouldRenderL) {
		ctx.drawCarModel(prom["D_LIGHT_L"], i, matrices);
	}
	if (shouldRenderR) {
		ctx.drawCarModel(prom["D_LIGHT_R"], i, matrices);
	}
	//DOORS
	renderDoorHalf(ctx, train, state, i, matrices, prom["D_LF_EXT"], prom["D_LF_INT"], null, null, 0.04, 0.08, 0, 0.64, true)

	renderDoorHalf(ctx, train, state, i, matrices, prom["D_LB_EXT"], prom["D_LB_INT"], null, null, 0.04, -0.08, 0, -0.64, true)

	renderDoorHalf(ctx, train, state, i, matrices, prom["D_RB_EXT"], prom["D_RB_INT"], null, null, -0.04, -0.08, 0, -0.64, false)

	renderDoorHalf(ctx, train, state, i, matrices, prom["D_RF_EXT"], prom["D_RF_INT"], null, null, -0.04, 0.08, 0, 0.64, false)

	matrices.popPose();
}

function renderTail(ctx, state, train, i, matrices) {
	let roll = state.rolls[i];
	roll = clamp(roll, -0.03, 0.03);
	let speedKmph = train.speed() * 20 * 3.6;
	let speedCoef = speedKmph > 20.0 ? 1.0 : speedKmph / 40 + 0.5;
	let rockZ = (state.rockingZCoef + i * 0.2) % 1.0;
	let rockX = (state.rockingXCoef +  0.2 * i) % 1.0;
	let totalXrotation = speedCoef * chaoticRotate(rockX) * 0.5;
	let totalZrotation = speedCoef * chaoticRotate2(rockZ) * 5 + roll;
	let wheelAngleCoef = state.wheelAngle/state.wheelRadius; // поворот колеса радиуса wheelRadius

	let renderFrontLights = !train.isReversed();

	let isLeftOpened = train.doorLeftOpen[i];
	let isRightOpened = train.doorRightOpen[i];
	let doorValue = train.doorValue();
	let shouldRenderR = !train.isDoorOpening() && doorValue < 1 && isLeftOpened && (doorValue % 0.1) > 0.05; 
	let shouldRenderL = !train.isDoorOpening() && doorValue < 1 && isRightOpened && (doorValue % 0.1) > 0.05; 
	
	matrices.pushPose();

	matrices.rotateX(0.0005);
	matrices.rotateZ(totalZrotation);
	matrices.rotateZ(totalXrotation);
	matrices.rotateY(3.1415);

	// BOGIES	
	matrices.pushPose();
	ctx.drawCarModel(bogiehead["TELEGI"], i, matrices);
	renderWheel(ctx, matrices, bogiehead["KOLPARA1"], -wheelAngleCoef, i, -0.2104, 8.6058); 
	renderWheel(ctx, matrices, bogiehead["KOLPARA2"], -wheelAngleCoef, i, -0.2104, 6.2061);
	renderWheel(ctx, matrices, bogiehead["KOLPARA3"], -wheelAngleCoef, i, -0.2104, -6.1886);
	renderWheel(ctx, matrices, bogiehead["KOLPARA4"], -wheelAngleCoef, i, -0.2104, -8.5882);
	matrices.popPose();

	ctx.drawCarModel(state.dh.model, i, matrices);
	ctx.drawCarModel(state.dhHeadScreen.model, i, matrices);

	ctx.drawCarModel(head["EXT"], i, matrices);
	ctx.drawCarModel(head["INT"], i, matrices);
	ctx.drawCarModel(head["INTLAMPS"], i, matrices);
	ctx.drawCarModel(head["CTRL"], i, matrices);
	ctx.drawCarModel(head["REVERS"], i, matrices);
	ctx.drawCarModel(head["CABLAMPS"], i, matrices);
	ctx.drawCarModel(head["MOGILI"], i, matrices);
	ctx.drawCarModel(head["TIKVI"], i, matrices);

	if (speedKmph == 0) {
		ctx.drawCarModel(head["TAMBLAMP2"], i, matrices);
	}

	//FARY
	if (!renderFrontLights) {
		ctx.drawCarModel(head["FARY"], i, matrices);
		ctx.drawCarModel(head["SKULL_BRIG"], i, matrices);
	} else {
		ctx.drawCarModel(head["BUF"], i, matrices);
		ctx.drawCarModel(head["SKULL_TOILET"], i, matrices);
	}
	//EXTERIOR DOOR INDICATORS
	if (shouldRenderL) {
		ctx.drawCarModel(head["D_LIGHT_L"], i, matrices);
	}
	if (shouldRenderR) {
		ctx.drawCarModel(head["D_LIGHT_R"], i, matrices);
	}
	//DOORS
	renderDoorHalf(ctx, train, state, i, matrices, head["D_LF_EXT"], head["D_LF_INT"], null, null, 0.04, 0.08, 0, 0.64, true)

	renderDoorHalf(ctx, train, state, i, matrices, head["D_LB_EXT"], head["D_LB_INT"], null, null, 0.04, -0.08, 0, -0.64, true)

	renderDoorHalf(ctx, train, state, i, matrices, head["D_RB_EXT"], head["D_RB_INT"], null, null, -0.04, -0.08, 0, -0.64, false)

	renderDoorHalf(ctx, train, state, i, matrices, head["D_RF_EXT"], head["D_RF_INT"], null, null, -0.04, 0.08, 0, 0.64, false)

	matrices.popPose();
}

function renderDoorHalf(ctx, train, state, i, matrices, ext, int, win, light, x1, z1, x2, z2, isRight) {
	let doorValue = 0.0
	if (isRight) {
		doorValue = train.doorValue() * train.doorRightOpen[i];
	} else {
		doorValue = train.doorValue() * train.doorLeftOpen[i];
	}

	let doorValueClamped = clamp(doorValue * 1.7, 0, 1);

	let doorA = 0.0
	let doorB = 0.0
	const alpha = 0.3

	if (doorValueClamped < alpha) {
		doorB = 0.0
		doorA = doorValueClamped / alpha
	} else {
		doorB = (doorValueClamped - alpha) / (1 - alpha)
		doorA = 1.0
	}

	let isOpenedMem = !isRight ? state.extDoorLightLeftMemory[i] : state.extDoorLightRightMemory[i];
	let shouldRenderExtLight = isOpenedMem && (state.extDoorLightTimer % 0.4) > 0.2 && state.extDoorLightFlag; 

	doorA = easeIn(doorA)
	doorB = easeOut(doorB)

	matrices.pushPose();
	matrices.translate(x1 * doorA, 0 ,z1 * doorA * doorA);
	matrices.translate(x2 * doorB, 0 ,z2 * doorB);
	ctx.drawCarModel(ext, i, matrices);
	ctx.drawCarModel(int, i, matrices);

	if (renderWindows) {
		ctx.drawCarModel(win, i, matrices);
	}

	if (light != null && shouldRenderExtLight) {
		ctx.drawCarModel(light, i, matrices);
	}
	matrices.popPose();
}

function renderWheel(ctx, matrices, part, angle, i, y, z) {
	matrices.pushPose(); // поворот объекта - смотри в самый низ
	matrices.translate(0.0, y, z);
	matrices.rotate(1.0, 0.0, 0.0, angle);
	matrices.translate(0.0, -y, -z);
	ctx.drawCarModel(part, i, matrices);
	
	matrices.popPose();
}

function easeIn(x) {
	return x*x;
}

function easeOut(x) {
	return 1 - (1 - x) * (1 - x);
}

function chaoticRotate(x) {
	return (x)*(x-1)*(x-0.25)*(x-0.6)*(x-0.8);
}

function chaoticRotate2(x) {
	return (x)*(x-1)*(x-0.15)*(x-0.5)*(x-0.8);
}

