/*
 * Decompiled with CFR 0.152.
 */
package com.artillexstudios.axplayerwarps.commands;

import com.artillexstudios.axplayerwarps.AxPlayerWarps;
import com.artillexstudios.axplayerwarps.commands.annotations.AllWarps;
import com.artillexstudios.axplayerwarps.commands.subcommands.Converter;
import com.artillexstudios.axplayerwarps.commands.subcommands.Reload;
import com.artillexstudios.axplayerwarps.enums.AccessList;
import com.artillexstudios.axplayerwarps.enums.Converters;
import com.artillexstudios.axplayerwarps.libs.axapi.utils.StringUtils;
import com.artillexstudios.axplayerwarps.libs.lamp.annotation.DefaultFor;
import com.artillexstudios.axplayerwarps.libs.lamp.annotation.Subcommand;
import com.artillexstudios.axplayerwarps.libs.lamp.bukkit.annotation.CommandPermission;
import com.artillexstudios.axplayerwarps.libs.lamp.exception.CommandErrorException;
import com.artillexstudios.axplayerwarps.libs.lamp.orphan.OrphanCommand;
import com.artillexstudios.axplayerwarps.warps.Warp;
import com.artillexstudios.axplayerwarps.warps.WarpManager;
import java.util.Map;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.jetbrains.annotations.NotNull;

public class AdminCommand
implements OrphanCommand {
    @DefaultFor(value={"~", "~ help"})
    @CommandPermission(value="axplayerwarps.admin.help")
    public void help(@NotNull CommandSender sender) {
        for (String m : AxPlayerWarps.LANG.getStringList("admin-help")) {
            sender.sendMessage(StringUtils.formatToString(m, new TagResolver[0]));
        }
    }

    @Subcommand(value={"reload"})
    @CommandPermission(value="axplayerwarps.admin.reload")
    public void reload(@NotNull CommandSender sender) {
        Reload.INSTANCE.execute(sender);
    }

    @Subcommand(value={"delete"})
    @CommandPermission(value="axplayerwarps.admin.delete")
    public void delete(@NotNull CommandSender sender, @AllWarps Warp warp) {
        AxPlayerWarps.getThreadedQueue().submit(() -> {
            AxPlayerWarps.getDatabase().deleteWarp(warp);
            AxPlayerWarps.MESSAGEUTILS.sendLang(sender, "admin.deleted", Map.of("%warp%", warp.getName()));
        });
    }

    @Subcommand(value={"delete id"})
    @CommandPermission(value="axplayerwarps.admin.delete")
    public void deleteId(@NotNull CommandSender sender, int id) {
        AxPlayerWarps.getThreadedQueue().submit(() -> {
            Warp warp = null;
            for (Warp w : WarpManager.getWarps()) {
                if (id != w.getId()) continue;
                warp = w;
                break;
            }
            if (warp == null) {
                AxPlayerWarps.MESSAGEUTILS.sendLang(sender, "errors.not-found", Map.of("%warp%", String.valueOf(id)));
                throw new CommandErrorException();
            }
            AxPlayerWarps.getDatabase().deleteWarp(warp);
            AxPlayerWarps.MESSAGEUTILS.sendLang(sender, "admin.deleted", Map.of("%warp%", warp.getName()));
        });
    }

    @Subcommand(value={"setowner"})
    @CommandPermission(value="axplayerwarps.admin.setowner")
    public void setOwner(@NotNull CommandSender sender, @AllWarps Warp warp, OfflinePlayer player) {
        AxPlayerWarps.getThreadedQueue().submit(() -> {
            warp.setOwner(player.getUniqueId());
            AxPlayerWarps.getDatabase().updateWarp(warp);
            AxPlayerWarps.getDatabase().removeFromList(warp, AccessList.WHITELIST, player);
            AxPlayerWarps.getDatabase().removeFromList(warp, AccessList.BLACKLIST, player);
            AxPlayerWarps.MESSAGEUTILS.sendLang(sender, "admin.setowner", Map.of("%warp%", warp.getName(), "%player%", player.getName() == null ? "---" : player.getName()));
        });
    }

    @Subcommand(value={"converter"})
    @CommandPermission(value="axplayerwarps.admin.converter")
    public void converter(CommandSender sender, Converters converters) {
        Converter.INSTANCE.execute(sender, converters);
    }
}

