/*
 * Decompiled with CFR 0.152.
 */
package com.artillexstudios.axplayerwarps.database.impl;

import com.artillexstudios.axplayerwarps.category.Category;
import com.artillexstudios.axplayerwarps.category.CategoryManager;
import com.artillexstudios.axplayerwarps.database.Database;
import com.artillexstudios.axplayerwarps.enums.Access;
import com.artillexstudios.axplayerwarps.enums.AccessList;
import com.artillexstudios.axplayerwarps.hooks.HookManager;
import com.artillexstudios.axplayerwarps.hooks.currency.CurrencyHook;
import com.artillexstudios.axplayerwarps.libs.axapi.utils.Pair;
import com.artillexstudios.axplayerwarps.user.Users;
import com.artillexstudios.axplayerwarps.user.WarpUser;
import com.artillexstudios.axplayerwarps.utils.ThreadUtils;
import com.artillexstudios.axplayerwarps.warps.Warp;
import com.artillexstudios.axplayerwarps.warps.WarpManager;
import com.google.common.collect.HashBiMap;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.World;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.Nullable;

public class Base
implements Database {
    private final HashBiMap<String, UUID> userNameCache = HashBiMap.create();

    public Connection getConnection() {
        return null;
    }

    @Override
    public String getType() {
        return null;
    }

    @Override
    public void setup() {
        this.execute("        CREATE TABLE IF NOT EXISTS axplayerwarps_players (\n        \tid INT NOT NULL AUTO_INCREMENT,\n        \tuuid VARCHAR(36) NOT NULL,\n        \tname VARCHAR(128) NOT NULL,\n        \tPRIMARY KEY (id),\n        \tUNIQUE (uuid)\n        );\n", new Object[0]);
        this.execute("        CREATE TABLE IF NOT EXISTS axplayerwarps_currencies (\n        \tid INT NOT NULL AUTO_INCREMENT,\n        \tcurrency VARCHAR(512) NOT NULL,\n        \tPRIMARY KEY (id),\n        \tUNIQUE (currency)\n        );\n", new Object[0]);
        this.execute("        CREATE TABLE IF NOT EXISTS axplayerwarps_worlds (\n        \tid INT NOT NULL AUTO_INCREMENT,\n        \tworld VARCHAR(512) NOT NULL,\n        \tPRIMARY KEY (id),\n        \tUNIQUE (world)\n        );\n", new Object[0]);
        this.execute("        CREATE TABLE IF NOT EXISTS axplayerwarps_warps (\n        \tid INT NOT NULL AUTO_INCREMENT,\n        \towner_id INT NOT NULL,\n        \tworld_id INT NOT NULL,\n        \tx FLOAT NOT NULL,\n        \ty FLOAT NOT NULL,\n        \tz FLOAT NOT NULL,\n        \tyaw FLOAT NOT NULL,\n        \tpitch FLOAT NOT NULL,\n        \tname VARCHAR(1024) NOT NULL,\n        \tdescription TEXT DEFAULT null,\n        \tcategory_id INT DEFAULT null,\n        \ticon_id INT DEFAULT null,\n        \tcreated BIGINT NOT NULL,\n            currency_id INT DEFAULT null,\n            price DOUBLE NOT NULL DEFAULT '0',\n            earned_money DOUBLE NOT NULL DEFAULT '0',\n            access TINYINT NOT NULL DEFAULT '0',\n        \tPRIMARY KEY (id)\n        );\n", new Object[0]);
        this.execute("        CREATE TABLE IF NOT EXISTS axplayerwarps_visits (\n        \tid INT NOT NULL AUTO_INCREMENT,\n        \tvisitor_id INT NOT NULL,\n        \twarp_id INT,\n        \tdate BIGINT,\n        \tPRIMARY KEY (id)\n        );\n", new Object[0]);
        this.execute("        CREATE TABLE IF NOT EXISTS axplayerwarps_ratings (\n        \tid INT NOT NULL AUTO_INCREMENT,\n        \treviewer_id INT NOT NULL,\n        \twarp_id INT NOT NULL,\n        \tstars TINYINT NOT NULL,\n        \tdate BIGINT,\n        \tPRIMARY KEY (id)\n        );\n", new Object[0]);
        this.execute("        CREATE TABLE IF NOT EXISTS axplayerwarps_categories (\n        \tid INT NOT NULL AUTO_INCREMENT,\n        \tcategory VARCHAR(512) NOT NULL,\n        \tPRIMARY KEY (id),\n        \tUNIQUE (category)\n        );\n", new Object[0]);
        this.execute("        CREATE TABLE IF NOT EXISTS axplayerwarps_materials (\n        \tid INT NOT NULL AUTO_INCREMENT,\n        \tmaterial VARCHAR(512) NOT NULL,\n        \tPRIMARY KEY (id),\n        \tUNIQUE (material)\n        );\n", new Object[0]);
        this.execute("        CREATE TABLE IF NOT EXISTS axplayerwarps_favorites (\n        \tid INT NOT NULL AUTO_INCREMENT,\n        \tplayer_id INT NOT NULL,\n        \twarp_id INT NOT NULL,\n        \tdate BIGINT,\n        \tPRIMARY KEY (id)\n        );\n", new Object[0]);
        this.execute("        CREATE TABLE IF NOT EXISTS axplayerwarps_whitelisted (\n        \tid INT NOT NULL AUTO_INCREMENT,\n        \tplayer_id INT NOT NULL,\n        \twarp_id INT NOT NULL,\n        \tdate BIGINT,\n        \tPRIMARY KEY (id)\n        );\n", new Object[0]);
        this.execute("        CREATE TABLE IF NOT EXISTS axplayerwarps_blacklisted (\n        \tid INT NOT NULL AUTO_INCREMENT,\n        \tplayer_id INT NOT NULL,\n        \twarp_id INT NOT NULL,\n        \tdate BIGINT,\n        \tPRIMARY KEY (id)\n        );\n", new Object[0]);
    }

    private void execute(String sql, Object ... obj) {
        try (Connection conn = this.getConnection();
             PreparedStatement stmt = conn.prepareStatement(sql);){
            int n = 1;
            for (Object o : obj) {
                stmt.setObject(n++, o);
            }
            stmt.executeUpdate();
        }
        catch (SQLException ex) {
            ex.printStackTrace();
        }
    }

    private PreparedStatement createStatement(Connection conn, String sql, Object ... obj) throws SQLException {
        PreparedStatement stmt = conn.prepareStatement(sql);
        int n = 1;
        for (Object o : obj) {
            stmt.setObject(n++, o);
        }
        return stmt;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private int insert(String sql, Object ... obj) {
        try (Connection conn = this.getConnection();
             PreparedStatement stmt = conn.prepareStatement(sql, 1);){
            int n = 1;
            for (Object o : obj) {
                stmt.setObject(n++, o);
            }
            stmt.executeUpdate();
            try (ResultSet rs = stmt.getGeneratedKeys();){
                if (!rs.next()) return -1;
                int n2 = rs.getInt(1);
                return n2;
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return -1;
    }

    @Override
    public int getPlayerId(OfflinePlayer offlinePlayer) {
        ThreadUtils.checkNotMain("This method can only be called async!");
        return this.getPlayerId(offlinePlayer.getUniqueId());
    }

    /*
     * Exception decompiling
     */
    @Override
    public int getPlayerId(UUID uuid) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 5 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public String getPlayerName(UUID uuid) {
        String cached = (String)this.userNameCache.inverse().get((Object)uuid);
        if (cached != null) {
            return cached;
        }
        OfflinePlayer pl = Bukkit.getOfflinePlayer((UUID)uuid);
        if (pl.getName() != null) {
            return pl.getName();
        }
        try (Connection conn = this.getConnection();
             PreparedStatement stmt = this.createStatement(conn, "SELECT name FROM axplayerwarps_players WHERE uuid = ?", uuid.toString());
             ResultSet rs = stmt.executeQuery();){
            if (!rs.next()) return "---";
            String name = rs.getString(1);
            this.userNameCache.put((Object)name, (Object)uuid);
            String string = name;
            return string;
        }
        catch (SQLException ex) {
            ex.printStackTrace();
        }
        return "---";
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    @Nullable
    public UUID getUUIDFromName(String name) {
        ThreadUtils.checkNotMain("This method can only be called async!");
        try (Connection conn = this.getConnection();
             PreparedStatement stmt = this.createStatement(conn, "SELECT uuid FROM axplayerwarps_players WHERE UPPER(name) = UPPER(?)", name);
             ResultSet rs = stmt.executeQuery();){
            if (!rs.next()) return null;
            UUID uUID = UUID.fromString(rs.getString(1));
            return uUID;
        }
        catch (SQLException ex) {
            ex.printStackTrace();
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    @Nullable
    public UUID getUUIDFromId(int id) {
        ThreadUtils.checkNotMain("This method can only be called async!");
        try (Connection conn = this.getConnection();
             PreparedStatement stmt = this.createStatement(conn, "SELECT uuid FROM axplayerwarps_players WHERE id = ?", id);
             ResultSet rs = stmt.executeQuery();){
            if (!rs.next()) return null;
            UUID uUID = UUID.fromString(rs.getString(1));
            return uUID;
        }
        catch (SQLException ex) {
            ex.printStackTrace();
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Pair<UUID, String> getUUIDAndNameFromId(int id) {
        ThreadUtils.checkNotMain("This method can only be called async!");
        try (Connection conn = this.getConnection();
             PreparedStatement stmt = this.createStatement(conn, "SELECT uuid, name FROM axplayerwarps_players WHERE id = ?", id);
             ResultSet rs = stmt.executeQuery();){
            if (!rs.next()) return null;
            Pair<UUID, String> pair = new Pair<UUID, String>(UUID.fromString(rs.getString(1)), rs.getString(2));
            return pair;
        }
        catch (SQLException ex) {
            ex.printStackTrace();
        }
        return null;
    }

    @Override
    public int getWorldId(String world) {
        ThreadUtils.checkNotMain("This method can only be called async!");
        return this.getWorldId(Bukkit.getWorld((String)world));
    }

    /*
     * Exception decompiling
     */
    @Override
    public int getWorldId(World world) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 5 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    @Nullable
    public String getWorldFromId(int id) {
        ThreadUtils.checkNotMain("This method can only be called async!");
        try (Connection conn = this.getConnection();
             PreparedStatement stmt = this.createStatement(conn, "SELECT world FROM axplayerwarps_worlds WHERE id = ?", id);
             ResultSet rs = stmt.executeQuery();){
            if (!rs.next()) return null;
            String string = rs.getString(1);
            return string;
        }
        catch (SQLException ex) {
            ex.printStackTrace();
        }
        return null;
    }

    /*
     * Exception decompiling
     */
    @Override
    public int getCategoryId(String category) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 5 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    @Nullable
    public Category getCategoryFromId(int id) {
        ThreadUtils.checkNotMain("This method can only be called async!");
        try (Connection conn = this.getConnection();
             PreparedStatement stmt = this.createStatement(conn, "SELECT category FROM axplayerwarps_categories WHERE id = ?", id);
             ResultSet rs = stmt.executeQuery();){
            if (!rs.next()) return null;
            Category category = CategoryManager.getCategories().get(rs.getString(1));
            return category;
        }
        catch (SQLException ex) {
            ex.printStackTrace();
        }
        return null;
    }

    /*
     * Exception decompiling
     */
    @Override
    public int getCurrencyId(String currency) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 5 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    @Nullable
    public CurrencyHook getCurrencyFromId(int id) {
        ThreadUtils.checkNotMain("This method can only be called async!");
        try (Connection conn = this.getConnection();
             PreparedStatement stmt = this.createStatement(conn, "SELECT currency FROM axplayerwarps_currencies WHERE id = ?", id);
             ResultSet rs = stmt.executeQuery();){
            if (!rs.next()) return null;
            CurrencyHook currencyHook = HookManager.getCurrencyHook(rs.getString(1));
            return currencyHook;
        }
        catch (SQLException ex) {
            ex.printStackTrace();
        }
        return null;
    }

    @Override
    public int getMaterialId(Material material) {
        ThreadUtils.checkNotMain("This method can only be called async!");
        return this.getMaterialId(material.name());
    }

    /*
     * Exception decompiling
     */
    @Override
    public int getMaterialId(String material) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 5 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    @Nullable
    public Material getMaterialFromId(int id) {
        ThreadUtils.checkNotMain("This method can only be called async!");
        try (Connection conn = this.getConnection();
             PreparedStatement stmt = this.createStatement(conn, "SELECT material FROM axplayerwarps_materials WHERE id = ?", id);
             ResultSet rs = stmt.executeQuery();){
            if (!rs.next()) return null;
            Material material = Material.valueOf((String)rs.getString(1));
            return material;
        }
        catch (SQLException ex) {
            ex.printStackTrace();
        }
        return null;
    }

    @Override
    public int createWarp(OfflinePlayer player, Location l, String warpName) {
        ThreadUtils.checkNotMain("This method can only be called async!");
        return this.insert("INSERT INTO axplayerwarps_warps\n(owner_id, world_id, x, y, z, yaw, pitch, name, created)\nVALUES (?, ?, ?, ?, ?, ?, ?, ?, ?);\n", this.getPlayerId(player), this.getWorldId(l.getWorld()), l.getX(), l.getY(), l.getZ(), Float.valueOf(l.getYaw()), Float.valueOf(l.getPitch()), warpName, System.currentTimeMillis());
    }

    @Override
    public void updateWarp(Warp warp) {
        ThreadUtils.checkNotMain("This method can only be called async!");
        this.execute("UPDATE axplayerwarps_warps SET\nowner_id = ?,\nworld_id = ?,\nx = ?,\ny = ?,\nz = ?,\nyaw = ?,\npitch = ?,\nname = ?,\ndescription = ?,\ncategory_id = ?,\nicon_id = ?,\ncurrency_id = ?,\nprice = ?,\nearned_money = ?,\naccess = ?\nWHERE id = ?\n", this.getPlayerId(warp.getOwner()), this.getWorldId(warp.getLocation().getWorld()), warp.getLocation().getX(), warp.getLocation().getY(), warp.getLocation().getZ(), Float.valueOf(warp.getLocation().getYaw()), Float.valueOf(warp.getLocation().getPitch()), warp.getName(), warp.getDescription(), warp.getCategory() == null ? null : Integer.valueOf(this.getCategoryId(warp.getCategory().raw())), warp.getIcon() == null ? null : Integer.valueOf(this.getMaterialId(warp.getIcon())), warp.getCurrency() == null ? null : Integer.valueOf(this.getCurrencyId(warp.getCurrency().getName())), warp.getTeleportPrice(), warp.getEarnedMoney(), warp.getAccess().ordinal(), warp.getId());
    }

    @Override
    public void deleteWarp(Warp warp) {
        for (WarpUser user : Users.getPlayers().values()) {
            user.getFavorites().removeIf(w -> w.equals(warp));
        }
        this.execute("DELETE FROM axplayerwarps_warps WHERE id = ?;", warp.getId());
        this.execute("DELETE FROM axplayerwarps_visits WHERE warp_id = ?;", warp.getId());
        this.execute("DELETE FROM axplayerwarps_ratings WHERE warp_id = ?;", warp.getId());
        this.execute("DELETE FROM axplayerwarps_favorites WHERE warp_id = ?;", warp.getId());
        this.execute("DELETE FROM axplayerwarps_whitelisted WHERE warp_id = ?;", warp.getId());
        this.execute("DELETE FROM axplayerwarps_blacklisted WHERE warp_id = ?;", warp.getId());
        WarpManager.getWarps().remove(warp);
    }

    @Override
    public void setRating(Player player, Warp warp, int stars) {
        this.removeRating(player, warp);
        warp.getAllRatings().put(player.getUniqueId(), stars);
        ThreadUtils.checkNotMain("This method can only be called async!");
        this.execute("INSERT INTO axplayerwarps_ratings (reviewer_id, warp_id, stars, date) VALUES (?, ?, ?, ?);", this.getPlayerId((OfflinePlayer)player), warp.getId(), stars, System.currentTimeMillis());
    }

    @Override
    public void removeRating(Player player, Warp warp) {
        warp.getAllRatings().remove(player.getUniqueId());
        ThreadUtils.checkNotMain("This method can only be called async!");
        this.execute("DELETE FROM axplayerwarps_ratings WHERE reviewer_id = ? AND warp_id = ?;", this.getPlayerId((OfflinePlayer)player), warp.getId());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    @Nullable
    public Integer getRating(Player player, Warp warp) {
        ThreadUtils.checkNotMain("This method can only be called async!");
        try (Connection conn = this.getConnection();
             PreparedStatement stmt = this.createStatement(conn, "SELECT stars FROM axplayerwarps_ratings WHERE reviewer_id = ? AND warp_id = ?;", this.getPlayerId((OfflinePlayer)player), warp.getId());
             ResultSet rs = stmt.executeQuery();){
            if (!rs.next()) return null;
            Integer n = rs.getInt(1);
            return n;
        }
        catch (SQLException ex) {
            ex.printStackTrace();
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Pair<Integer, Float> getRatings(Warp warp) {
        ThreadUtils.checkNotMain("This method can only be called async!");
        try (Connection conn = this.getConnection();
             PreparedStatement stmt = this.createStatement(conn, "SELECT count(reviewer_id), avg(stars) FROM axplayerwarps_ratings WHERE warp_id = ?;", warp.getId());
             ResultSet rs = stmt.executeQuery();){
            if (!rs.next()) return new Pair<Integer, Float>(0, Float.valueOf(0.0f));
            Pair<Integer, Float> pair = new Pair<Integer, Float>(rs.getInt(1), Float.valueOf(rs.getFloat(2)));
            return pair;
        }
        catch (SQLException ex) {
            ex.printStackTrace();
        }
        return new Pair<Integer, Float>(0, Float.valueOf(0.0f));
    }

    @Override
    public HashMap<UUID, Integer> getAllRatings(Warp warp) {
        ThreadUtils.checkNotMain("This method can only be called async!");
        HashMap<UUID, Integer> ratings = new HashMap<UUID, Integer>();
        try (Connection conn = this.getConnection();
             PreparedStatement stmt = this.createStatement(conn, "SELECT axplayerwarps_players.uuid, axplayerwarps_ratings.stars FROM axplayerwarps_ratings INNER JOIN axplayerwarps_players ON axplayerwarps_ratings.reviewer_id = axplayerwarps_players.id WHERE axplayerwarps_ratings.warp_id = ?;", warp.getId());
             ResultSet rs = stmt.executeQuery();){
            while (rs.next()) {
                ratings.put(UUID.fromString(rs.getString(1)), rs.getInt(2));
            }
        }
        catch (SQLException ex) {
            ex.printStackTrace();
        }
        return ratings;
    }

    @Override
    public void addToFavorites(Player player, Warp warp) {
        this.removeFromFavorites(player, warp);
        Users.get(player).getFavorites().add(warp);
        warp.setFavorites(warp.getFavorites() + 1);
        ThreadUtils.checkNotMain("This method can only be called async!");
        this.execute("INSERT INTO axplayerwarps_favorites (player_id, warp_id, date) VALUES (?, ?, ?);", this.getPlayerId((OfflinePlayer)player), warp.getId(), System.currentTimeMillis());
    }

    @Override
    public void removeFromFavorites(Player player, Warp warp) {
        if (Users.get(player).getFavorites().remove(warp)) {
            warp.setFavorites(warp.getFavorites() - 1);
        }
        ThreadUtils.checkNotMain("This method can only be called async!");
        this.execute("DELETE FROM axplayerwarps_favorites WHERE player_id = ? AND warp_id = ?;", this.getPlayerId((OfflinePlayer)player), warp.getId());
    }

    @Override
    public void removeAllFavorites(Player player) {
        for (Warp warp : Users.get(player).getFavorites()) {
            warp.setFavorites(warp.getFavorites() - 1);
        }
        Users.get(player).getFavorites().clear();
        ThreadUtils.checkNotMain("This method can only be called async!");
        this.execute("DELETE FROM axplayerwarps_favorites WHERE player_id = ?;", this.getPlayerId((OfflinePlayer)player));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public int getFavorites(Warp warp) {
        ThreadUtils.checkNotMain("This method can only be called async!");
        try (Connection conn = this.getConnection();
             PreparedStatement stmt = this.createStatement(conn, "SELECT count(*) FROM axplayerwarps_favorites WHERE warp_id = ?;", warp.getId());
             ResultSet rs = stmt.executeQuery();){
            if (!rs.next()) return 0;
            int n = rs.getInt(1);
            return n;
        }
        catch (SQLException ex) {
            ex.printStackTrace();
        }
        return 0;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public int getFavorites(Player player) {
        ThreadUtils.checkNotMain("This method can only be called async!");
        try (Connection conn = this.getConnection();
             PreparedStatement stmt = this.createStatement(conn, "SELECT count(*) FROM axplayerwarps_favorites WHERE player_id = ?;", this.getPlayerId((OfflinePlayer)player));
             ResultSet rs = stmt.executeQuery();){
            if (!rs.next()) return 0;
            int n = rs.getInt(1);
            return n;
        }
        catch (SQLException ex) {
            ex.printStackTrace();
        }
        return 0;
    }

    @Override
    public List<Warp> getFavoriteWarps(Player player) {
        ThreadUtils.checkNotMain("This method can only be called async!");
        ArrayList<Warp> warps = new ArrayList<Warp>();
        try (Connection conn = this.getConnection();
             PreparedStatement stmt = this.createStatement(conn, "SELECT warp_id FROM axplayerwarps_favorites WHERE player_id = ?;", this.getPlayerId((OfflinePlayer)player));
             ResultSet rs = stmt.executeQuery();){
            while (rs.next()) {
                int id = rs.getInt(1);
                WarpManager.getWarps().stream().filter(warp -> warp.getId() == id).findAny().ifPresent(warps::add);
            }
        }
        catch (SQLException ex) {
            ex.printStackTrace();
        }
        return warps;
    }

    @Override
    public List<Warp> getRecentWarps(Player player) {
        ThreadUtils.checkNotMain("This method can only be called async!");
        ArrayList<Warp> warps = new ArrayList<Warp>();
        try (Connection conn = this.getConnection();
             PreparedStatement stmt = this.createStatement(conn, "SELECT DISTINCT warp_id FROM axplayerwarps_visits WHERE visitor_id = ? ORDER BY date DESC;", this.getPlayerId((OfflinePlayer)player));
             ResultSet rs = stmt.executeQuery();){
            while (rs.next()) {
                int id = rs.getInt(1);
                WarpManager.getWarps().stream().filter(warp -> warp.getId() == id).findAny().ifPresent(warps::add);
            }
        }
        catch (SQLException ex) {
            ex.printStackTrace();
        }
        return warps;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean isFavorite(Player player, Warp warp) {
        ThreadUtils.checkNotMain("This method can only be called async!");
        try (Connection conn = this.getConnection();
             PreparedStatement stmt = this.createStatement(conn, "SELECT id FROM axplayerwarps_favorites WHERE player_id = ? AND warp_id = ? LIMIT 1;", this.getPlayerId((OfflinePlayer)player), warp.getId());
             ResultSet rs = stmt.executeQuery();){
            if (!rs.next()) return false;
            boolean bl = true;
            return bl;
        }
        catch (SQLException ex) {
            ex.printStackTrace();
        }
        return false;
    }

    @Override
    public void addVisit(Player player, Warp warp) {
        warp.setVisits(warp.getVisits() + 1);
        warp.getVisitors().add(player.getUniqueId());
        ThreadUtils.checkNotMain("This method can only be called async!");
        this.execute("INSERT INTO axplayerwarps_visits (visitor_id, warp_id, date) VALUES (?, ?, ?);", this.getPlayerId((OfflinePlayer)player), warp.getId(), System.currentTimeMillis());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public int getVisits(Warp warp) {
        ThreadUtils.checkNotMain("This method can only be called async!");
        try (Connection conn = this.getConnection();
             PreparedStatement stmt = this.createStatement(conn, "SELECT count(*) FROM axplayerwarps_visits WHERE warp_id = ?;", warp.getId());
             ResultSet rs = stmt.executeQuery();){
            if (!rs.next()) return 0;
            int n = rs.getInt(1);
            return n;
        }
        catch (SQLException ex) {
            ex.printStackTrace();
        }
        return 0;
    }

    @Override
    public HashSet<UUID> getVisitors(Warp warp) {
        ThreadUtils.checkNotMain("This method can only be called async!");
        HashSet<UUID> visitors = new HashSet<UUID>();
        try (Connection conn = this.getConnection();
             PreparedStatement stmt = this.createStatement(conn, "SELECT DISTINCT axplayerwarps_players.uuid FROM axplayerwarps_visits INNER JOIN axplayerwarps_players ON axplayerwarps_visits.visitor_id = axplayerwarps_players.id WHERE warp_id = ?;", warp.getId());
             ResultSet rs = stmt.executeQuery();){
            while (rs.next()) {
                visitors.add(UUID.fromString(rs.getString(1)));
            }
        }
        catch (SQLException ex) {
            ex.printStackTrace();
        }
        return visitors;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public int getUniqueVisits(Warp warp) {
        ThreadUtils.checkNotMain("This method can only be called async!");
        try (Connection conn = this.getConnection();
             PreparedStatement stmt = this.createStatement(conn, "SELECT count(*) FROM (SELECT DISTINCT visitor_id FROM axplayerwarps_visits WHERE warp_id = ?);", warp.getId());
             ResultSet rs = stmt.executeQuery();){
            if (!rs.next()) return 0;
            int n = rs.getInt(1);
            return n;
        }
        catch (SQLException ex) {
            ex.printStackTrace();
        }
        return 0;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean warpExists(String name) {
        ThreadUtils.checkNotMain("This method can only be called async!");
        try (Connection conn = this.getConnection();
             PreparedStatement stmt = this.createStatement(conn, "SELECT id FROM axplayerwarps_warps WHERE UPPER(name) = UPPER(?)", name);
             ResultSet rs = stmt.executeQuery();){
            if (!rs.next()) return false;
            boolean bl = true;
            return bl;
        }
        catch (SQLException ex) {
            ex.printStackTrace();
        }
        return false;
    }

    @Override
    public void addToList(Warp warp, AccessList al, OfflinePlayer player) {
        ThreadUtils.checkNotMain("This method can only be called async!");
        this.removeFromList(warp, AccessList.BLACKLIST, player);
        this.removeFromList(warp, AccessList.WHITELIST, player);
        long time = System.currentTimeMillis();
        AccessPlayer accessPlayer = new AccessPlayer(player, time, this.getPlayerName(player.getUniqueId()));
        switch (al) {
            case WHITELIST: {
                warp.getWhitelisted().add(accessPlayer);
                break;
            }
            case BLACKLIST: {
                warp.getBlacklisted().add(accessPlayer);
            }
        }
        this.execute("INSERT INTO " + al.getTable() + " (player_id, warp_id, date) VALUES (?, ?, ?);", this.getPlayerId(player), warp.getId(), time);
    }

    @Override
    public void removeFromList(Warp warp, AccessList al, OfflinePlayer player) {
        ThreadUtils.checkNotMain("This method can only be called async!");
        switch (al) {
            case WHITELIST: {
                warp.getWhitelisted().removeIf(ap -> ap.player().getUniqueId().equals(player.getUniqueId()));
                break;
            }
            case BLACKLIST: {
                warp.getBlacklisted().removeIf(ap -> ap.player().getUniqueId().equals(player.getUniqueId()));
            }
        }
        this.execute("DELETE FROM " + al.getTable() + " WHERE player_id = ? AND warp_id = ?;", this.getPlayerId(player), warp.getId());
    }

    @Override
    public void clearList(Warp warp, AccessList al) {
        ThreadUtils.checkNotMain("This method can only be called async!");
        switch (al) {
            case WHITELIST: {
                warp.getWhitelisted().clear();
                break;
            }
            case BLACKLIST: {
                warp.getBlacklisted().clear();
            }
        }
        this.execute("DELETE FROM " + al.getTable() + " WHERE warp_id = ?;", warp.getId());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean isOnList(Warp warp, AccessList al, OfflinePlayer player) {
        ThreadUtils.checkNotMain("This method can only be called async!");
        try (Connection conn = this.getConnection();
             PreparedStatement stmt = this.createStatement(conn, "SELECT id FROM " + al.getTable() + " WHERE warp_id = ? AND player_id = (SELECT id FROM axplayerwarps_players WHERE uuid = ? LIMIT 1) LIMIT 1", warp.getId(), player.getUniqueId().toString());
             ResultSet rs = stmt.executeQuery();){
            if (!rs.next()) return false;
            boolean bl = true;
            return bl;
        }
        catch (SQLException ex) {
            ex.printStackTrace();
        }
        return false;
    }

    @Override
    public List<AccessPlayer> getAccessList(Warp warp, AccessList al) {
        ThreadUtils.checkNotMain("This method can only be called async!");
        ArrayList<AccessPlayer> list = new ArrayList<AccessPlayer>();
        try (Connection conn = this.getConnection();
             PreparedStatement stmt = this.createStatement(conn, "SELECT axplayerwarps_players.uuid, axplayerwarps_players.name, " + al.getTable() + ".date FROM axplayerwarps_players INNER JOIN " + al.getTable() + " ON axplayerwarps_players.id = " + al.getTable() + ".player_id WHERE " + al.getTable() + ".warp_id = ?", warp.getId());
             ResultSet rs = stmt.executeQuery();){
            while (rs.next()) {
                AccessPlayer ap = new AccessPlayer(Bukkit.getOfflinePlayer((UUID)UUID.fromString(rs.getString(1))), rs.getLong(3), rs.getString(2));
                list.add(ap);
            }
        }
        catch (SQLException ex) {
            ex.printStackTrace();
        }
        return list;
    }

    @Override
    public void loadWarps() {
        ThreadUtils.checkNotMain("This method can only be called async!");
        try (Connection conn = this.getConnection();
             PreparedStatement stmt = this.createStatement(conn, "SELECT * FROM axplayerwarps_warps;", new Object[0]);
             ResultSet rs = stmt.executeQuery();){
            while (rs.next()) {
                Pair<UUID, String> player;
                String world = this.getWorldFromId(rs.getInt("world_id"));
                Location loc = new Location(Bukkit.getWorld((String)world), rs.getDouble("x"), rs.getDouble("y"), rs.getDouble("z"), rs.getFloat("yaw"), rs.getFloat("pitch"));
                Category category = null;
                if (rs.getString("category_id") != null) {
                    category = this.getCategoryFromId(rs.getInt("category_id"));
                }
                CurrencyHook currencyHook = null;
                if (rs.getString("currency_id") != null) {
                    currencyHook = this.getCurrencyFromId(rs.getInt("currency_id"));
                }
                Material material = null;
                if (rs.getString("icon_id") != null) {
                    material = this.getMaterialFromId(rs.getInt("icon_id"));
                }
                if ((player = this.getUUIDAndNameFromId(rs.getInt("owner_id"))) == null) continue;
                Warp warp = new Warp(rs.getInt("id"), rs.getLong("created"), rs.getString("description"), rs.getString("name"), loc, world, category, player.getKey(), player.getValue(), Access.values()[rs.getInt("access")], currencyHook, rs.getDouble("price"), rs.getDouble("earned_money"), material);
                WarpManager.getWarps().add(warp);
            }
        }
        catch (SQLException ex) {
            ex.printStackTrace();
        }
    }

    @Override
    public void disable() {
    }

    public record AccessPlayer(OfflinePlayer player, long added, String name) {
    }
}

