/*
 * Decompiled with CFR 0.152.
 */
package com.artillexstudios.axplayerwarps.libs.lamp.bukkit.brigadier;

import com.artillexstudios.axplayerwarps.libs.lamp.bukkit.BukkitCommandHandler;
import com.artillexstudios.axplayerwarps.libs.lamp.bukkit.brigadier.BukkitVersion;
import com.artillexstudios.axplayerwarps.libs.lamp.bukkit.brigadier.Commodore;
import com.artillexstudios.axplayerwarps.libs.lamp.bukkit.brigadier.PaperCommodore;
import com.artillexstudios.axplayerwarps.libs.lamp.bukkit.brigadier.PaperLifecycleEvents;
import com.artillexstudios.axplayerwarps.libs.lamp.bukkit.brigadier.ReflectionCommodore;
import java.util.Objects;
import java.util.function.Function;

public final class CommodoreProvider {
    private static final Function<BukkitCommandHandler, Commodore> PROVIDER = CommodoreProvider.checkSupported();

    private CommodoreProvider() {
        throw new AssertionError();
    }

    private static Function<BukkitCommandHandler, Commodore> checkSupported() {
        if (!BukkitVersion.isBrigadierSupported()) {
            return null;
        }
        if (BukkitVersion.isPaper()) {
            if (BukkitVersion.supports(1, 20, 6)) {
                return plugin -> new PaperLifecycleEvents((BukkitCommandHandler)plugin);
            }
            if (BukkitVersion.supports(1, 19)) {
                return plugin -> new PaperCommodore((BukkitCommandHandler)plugin);
            }
        }
        return plugin -> new ReflectionCommodore((BukkitCommandHandler)plugin);
    }

    public static boolean isSupported() {
        return PROVIDER != null;
    }

    public static Commodore getCommodore(BukkitCommandHandler plugin) {
        Objects.requireNonNull(plugin, "plugin");
        return PROVIDER == null ? null : PROVIDER.apply(plugin);
    }
}

