/*
 * Decompiled with CFR 0.152.
 */
package com.artillexstudios.axplayerwarps.libs.lamp.locales;

import com.artillexstudios.axplayerwarps.libs.lamp.locales.LocaleReader;
import com.artillexstudios.axplayerwarps.libs.lamp.locales.Locales;
import com.artillexstudios.axplayerwarps.libs.lamp.locales.Translator;
import com.artillexstudios.axplayerwarps.libs.lamp.locales.UTF8Control;
import com.artillexstudios.axplayerwarps.libs.lamp.util.Preconditions;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.jetbrains.annotations.NotNull;

final class SimpleTranslator
implements Translator {
    private static final LinkedList<LocaleReader> EMPTY_LIST = new LinkedList();
    private final Map<Locale, LinkedList<LocaleReader>> registeredBundles = new HashMap<Locale, LinkedList<LocaleReader>>();
    private volatile Locale locale = Locale.ENGLISH;

    SimpleTranslator() {
        this.addResourceBundle("lamp");
        if (SimpleTranslator.classExists("org.bukkit.Bukkit")) {
            this.addResourceBundle("lamp-bukkit");
        }
        if (SimpleTranslator.classExists("org.spongepowered.api.Sponge")) {
            this.addResourceBundle("lamp-sponge");
        }
        if (SimpleTranslator.classExists("com.velocitypowered.api.proxy.ProxyServer")) {
            this.addResourceBundle("lamp-velocity");
        }
        if (SimpleTranslator.classExists("net.md_5.bungee.api.ProxyServer")) {
            this.addResourceBundle("lamp-bungee");
        }
        if (SimpleTranslator.classExists("net.dv8tion.jda.api.JDA")) {
            this.addResourceBundle("lamp-jda");
        }
    }

    @Override
    @NotNull
    public String get(@NotNull String key) {
        return this.get(key, this.locale);
    }

    @Override
    @NotNull
    public String get(@NotNull String key, @NotNull Locale locale) {
        Preconditions.notNull(key, "key");
        Preconditions.notNull(locale, "locale");
        for (LocaleReader registeredBundle : this.registeredBundles.getOrDefault(locale, EMPTY_LIST)) {
            if (!registeredBundle.containsKey(key)) continue;
            return registeredBundle.get(key);
        }
        for (LocaleReader registeredBundle : this.registeredBundles.getOrDefault(this.locale, EMPTY_LIST)) {
            if (!registeredBundle.containsKey(key)) continue;
            return registeredBundle.get(key);
        }
        return key;
    }

    @Override
    public void add(@NotNull LocaleReader reader) {
        LinkedList list = this.registeredBundles.computeIfAbsent(reader.getLocale(), v -> new LinkedList());
        list.push(reader);
    }

    @Override
    @NotNull
    public Locale getLocale() {
        return this.locale;
    }

    @Override
    public void setLocale(@NotNull Locale locale) {
        Preconditions.notNull(locale, "locale");
        this.locale = locale;
    }

    @Override
    public void addResourceBundle(@NotNull String resourceBundle, Locale ... locales) {
        Preconditions.notNull(resourceBundle, "resource bundle");
        Preconditions.notNull(locales, "locales");
        for (Locale locale : locales) {
            try {
                ResourceBundle bundle = ResourceBundle.getBundle(resourceBundle, locale, this.getClass().getClassLoader(), UTF8Control.INSTANCE);
                this.add(bundle);
            }
            catch (MissingResourceException missingResourceException) {
                // empty catch block
            }
        }
    }

    @Override
    public void addResourceBundle(@NotNull String resourceBundle) {
        Preconditions.notNull(resourceBundle, "resource bundle");
        for (Locale locale : Locales.getLocales()) {
            try {
                ResourceBundle bundle = ResourceBundle.getBundle(resourceBundle, locale, this.getClass().getClassLoader(), UTF8Control.INSTANCE);
                this.add(bundle);
            }
            catch (MissingResourceException missingResourceException) {}
        }
    }

    @Override
    public void add(@NotNull ResourceBundle resourceBundle) {
        Preconditions.notNull(resourceBundle, "resource bundle");
        this.add(LocaleReader.wrap(resourceBundle));
    }

    private static boolean classExists(String name) {
        try {
            Class.forName(name);
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }
}

