/*
 * Decompiled with CFR 0.152.
 */
package com.artillexstudios.axplayerwarps.sorting;

import com.artillexstudios.axplayerwarps.sorting.Sort;
import com.artillexstudios.axplayerwarps.warps.Warp;
import java.util.Comparator;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

public class WarpComparator
implements Comparator<Warp> {
    private final Sort sort;
    private final Player player;

    public WarpComparator(Sort sort, Player player) {
        this.sort = sort;
        this.player = player;
    }

    @Override
    public int compare(@NotNull Warp w1, @NotNull Warp w2) {
        switch (this.sort.sorting()) {
            case ALPHABETICAL: {
                return w1.getName().compareTo(w2.getName()) * (this.sort.reverse() ? -1 : 1);
            }
            case VISITS: {
                return Integer.compare(w1.getUniqueVisits(), w2.getUniqueVisits()) * (this.sort.reverse() ? 1 : -1);
            }
            case RATING: {
                return Float.compare(w1.getRating(), w2.getRating()) * (this.sort.reverse() ? 1 : -1);
            }
            case RATING_COUNT: {
                return Integer.compare(w1.getRatingAmount(), w2.getRatingAmount()) * (this.sort.reverse() ? 1 : -1);
            }
            case FAVORITES: {
                return Integer.compare(w1.getFavorites(), w2.getFavorites()) * (this.sort.reverse() ? 1 : -1);
            }
            case DISTANCE: {
                return Double.compare(this.distance(w1), this.distance(w2)) * (this.sort.reverse() ? -1 : 1);
            }
            case CREATION_DATE: {
                return Long.compare(w1.getCreated(), w2.getCreated()) * (this.sort.reverse() ? 1 : -1);
            }
        }
        return 0;
    }

    private double distance(Warp warp) {
        if (!this.player.getWorld().equals((Object)warp.getLocation().getWorld())) {
            return Double.MAX_VALUE;
        }
        return this.player.getLocation().distanceSquared(warp.getLocation());
    }
}

