/*
 * Decompiled with CFR 0.152.
 */
package com.artillexstudios.axplayerwarps.commands;

import com.artillexstudios.axplayerwarps.AxPlayerWarps;
import com.artillexstudios.axplayerwarps.commands.annotations.AllWarps;
import com.artillexstudios.axplayerwarps.commands.annotations.OwnWarps;
import com.artillexstudios.axplayerwarps.commands.subcommands.Create;
import com.artillexstudios.axplayerwarps.commands.subcommands.Info;
import com.artillexstudios.axplayerwarps.commands.subcommands.Open;
import com.artillexstudios.axplayerwarps.guis.EditWarpGui;
import com.artillexstudios.axplayerwarps.libs.axapi.utils.StringUtils;
import com.artillexstudios.axplayerwarps.libs.lamp.annotation.DefaultFor;
import com.artillexstudios.axplayerwarps.libs.lamp.annotation.Optional;
import com.artillexstudios.axplayerwarps.libs.lamp.annotation.Subcommand;
import com.artillexstudios.axplayerwarps.libs.lamp.bukkit.annotation.CommandPermission;
import com.artillexstudios.axplayerwarps.libs.lamp.exception.CommandErrorException;
import com.artillexstudios.axplayerwarps.libs.lamp.orphan.OrphanCommand;
import com.artillexstudios.axplayerwarps.warps.Warp;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

public class MainCommand
implements OrphanCommand {
    @DefaultFor(value={"~"})
    @CommandPermission(value="axplayerwarps.open")
    public void open(@NotNull CommandSender sender, @Optional @CommandPermission(value="axplayerwarps.use") Warp warp) {
        if (warp != null) {
            if (!(sender instanceof Player)) {
                throw new CommandErrorException("must-be-player", new Object[0]);
            }
            Player pl = (Player)sender;
            warp.teleportPlayer(pl);
            return;
        }
        Open.INSTANCE.execute(sender, null);
    }

    @Subcommand(value={"help"})
    @CommandPermission(value="axplayerwarps.help")
    public void help(@NotNull CommandSender sender) {
        for (String m : AxPlayerWarps.LANG.getStringList("help")) {
            sender.sendMessage(StringUtils.formatToString(m, new TagResolver[0]));
        }
    }

    @Subcommand(value={"open"})
    @CommandPermission(value="axplayerwarps.open")
    public void open2(@NotNull CommandSender sender, @CommandPermission(value="axplayerwarps.open.other") @Optional Player player) {
        Open.INSTANCE.execute(sender, player);
    }

    @Subcommand(value={"warp", "go"})
    @CommandPermission(value="axplayerwarps.use")
    public void warp(@NotNull Player sender, @AllWarps Warp warp) {
        warp.teleportPlayer(sender);
    }

    @Subcommand(value={"create", "set"})
    @CommandPermission(value="axplayerwarps.create")
    public void create(@NotNull Player sender, String warpName) {
        Create.INSTANCE.execute(sender, warpName, null);
    }

    @Subcommand(value={"delete"})
    @CommandPermission(value="axplayerwarps.delete")
    public void delete(@NotNull Player sender, @OwnWarps Warp warp) {
        if (!warp.getOwner().equals(sender.getUniqueId())) {
            AxPlayerWarps.MESSAGEUTILS.sendLang((CommandSender)sender, "errors.not-your-warp", new TagResolver[0]);
            return;
        }
        warp.delete();
    }

    @Subcommand(value={"edit", "settings"})
    @CommandPermission(value="axplayerwarps.edit")
    public void edit(@NotNull Player sender, @OwnWarps Warp warp) {
        if (!warp.getOwner().equals(sender.getUniqueId())) {
            AxPlayerWarps.MESSAGEUTILS.sendLang((CommandSender)sender, "errors.not-your-warp", new TagResolver[0]);
            return;
        }
        new EditWarpGui(sender, warp).open();
    }

    @Subcommand(value={"info"})
    @CommandPermission(value="axplayerwarps.info")
    public void info(@NotNull CommandSender sender, @AllWarps Warp warp) {
        Info.INSTANCE.execute(sender, warp);
    }
}

