/*
 * Decompiled with CFR 0.152.
 */
package com.artillexstudios.axplayerwarps.commands.subcommands;

import com.artillexstudios.axplayerwarps.AxPlayerWarps;
import com.artillexstudios.axplayerwarps.enums.Access;
import com.artillexstudios.axplayerwarps.hooks.HookManager;
import com.artillexstudios.axplayerwarps.hooks.currency.CurrencyHook;
import com.artillexstudios.axplayerwarps.libs.axapi.utils.Cooldown;
import com.artillexstudios.axplayerwarps.user.Users;
import com.artillexstudios.axplayerwarps.user.WarpUser;
import com.artillexstudios.axplayerwarps.utils.FormatUtils;
import com.artillexstudios.axplayerwarps.utils.SimpleRegex;
import com.artillexstudios.axplayerwarps.utils.WarpNameUtils;
import com.artillexstudios.axplayerwarps.warps.Warp;
import com.artillexstudios.axplayerwarps.warps.WarpManager;
import java.util.Map;
import java.util.Optional;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import org.bukkit.Location;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.Nullable;

public enum Create {
    INSTANCE;

    private final Cooldown<Player> cooldown = Cooldown.create();

    public void execute(Player sender, String warpName, @Nullable OfflinePlayer setPlayer) {
        CurrencyHook currencyHook;
        double price;
        long warps;
        WarpUser user = Users.get(sender);
        long limit = user.getWarpLimit();
        if (limit <= (warps = WarpManager.getWarps().stream().filter(warp -> warp.getOwner().equals(sender.getUniqueId())).count())) {
            AxPlayerWarps.MESSAGEUTILS.sendLang((CommandSender)sender, "errors.limit-reached", Map.of("%current%", "" + warps, "%limit%", "" + limit));
            return;
        }
        Location warpLocation = sender.getLocation();
        if (SimpleRegex.matches(AxPlayerWarps.CONFIG.getStringList("disallowed-worlds"), warpLocation.getWorld().getName())) {
            AxPlayerWarps.MESSAGEUTILS.sendLang((CommandSender)sender, "errors.disallowed-world", new TagResolver[0]);
            return;
        }
        if (!HookManager.canBuild(sender, warpLocation)) {
            AxPlayerWarps.MESSAGEUTILS.sendLang((CommandSender)sender, "errors.cannot-create-here", new TagResolver[0]);
            return;
        }
        switch (WarpNameUtils.isAllowed(warpName)) {
            case DISALLOWED: {
                AxPlayerWarps.MESSAGEUTILS.sendLang((CommandSender)sender, "errors.disallowed-name-blacklisted", new TagResolver[0]);
                return;
            }
            case CONTAINS_SPACES: {
                AxPlayerWarps.MESSAGEUTILS.sendLang((CommandSender)sender, "errors.disallowed-name-space", new TagResolver[0]);
                return;
            }
            case INVALID_LENGTH: {
                AxPlayerWarps.MESSAGEUTILS.sendLang((CommandSender)sender, "errors.disallowed-name-length", new TagResolver[0]);
                return;
            }
        }
        Optional<Warp> warpOpt = WarpManager.getWarps().stream().filter(warp -> {
            boolean caseSensitive = AxPlayerWarps.CONFIG.getBoolean("warp-naming.case-sensitive", false);
            if (caseSensitive) {
                return warp.getName().equals(warpName);
            }
            return warp.getName().equalsIgnoreCase(warpName);
        }).findAny();
        if (warpOpt.isPresent()) {
            AxPlayerWarps.MESSAGEUTILS.sendLang((CommandSender)sender, "errors.name-exists", new TagResolver[0]);
            return;
        }
        if (AxPlayerWarps.CONFIG.getBoolean("warp-creation-cost.enabled", false)) {
            price = AxPlayerWarps.CONFIG.getDouble("warp-creation-cost.price", 1000.0f);
            String currStr = AxPlayerWarps.CONFIG.getString("warp-creation-cost.currency", "Experience");
            currencyHook = HookManager.getCurrencyHook(currStr);
            if (currencyHook != null) {
                if (currencyHook.getBalance(sender.getUniqueId()) < price) {
                    AxPlayerWarps.MESSAGEUTILS.sendLang((CommandSender)sender, "errors.create-not-enough-currency", Map.of("%price%", FormatUtils.formatCurrency(currencyHook, price)));
                    return;
                }
                if (AxPlayerWarps.CONFIG.getBoolean("warp-creation-cost.confirm", true) && !this.cooldown.hasCooldown(sender)) {
                    this.cooldown.addCooldown(sender, 10000L);
                    AxPlayerWarps.MESSAGEUTILS.sendLang((CommandSender)sender, "create.confirm", Map.of("%price%", FormatUtils.formatCurrency(currencyHook, price)));
                    return;
                }
                currencyHook.takeBalance(sender.getUniqueId(), price);
            }
        } else {
            currencyHook = null;
            price = 0.0;
        }
        AxPlayerWarps.getThreadedQueue().submit(() -> {
            Player usedPlayer = setPlayer == null ? sender : setPlayer;
            int id = AxPlayerWarps.getDatabase().createWarp((OfflinePlayer)usedPlayer, warpLocation, warpName);
            Warp warp = new Warp(id, System.currentTimeMillis(), null, warpName, warpLocation, warpLocation.getWorld().getName(), null, usedPlayer.getUniqueId(), usedPlayer.getName(), Access.PUBLIC, null, 0.0, 0.0, null);
            AxPlayerWarps.MESSAGEUTILS.sendLang((CommandSender)sender, "create.created", Map.of("%warp%", warpName, "%price%", FormatUtils.formatCurrency(currencyHook, price)));
            WarpManager.getWarps().add(warp);
        });
    }
}

