/*
 * Decompiled with CFR 0.152.
 */
package com.artillexstudios.axplayerwarps.libs.gui.actions;

import com.artillexstudios.axplayerwarps.libs.gui.GuiFrame;
import com.artillexstudios.axplayerwarps.libs.gui.actions.Action;
import com.artillexstudios.axplayerwarps.libs.gui.actions.impl.ActionConsoleCommand;
import com.artillexstudios.axplayerwarps.libs.gui.actions.impl.ActionFirework;
import com.artillexstudios.axplayerwarps.libs.gui.actions.impl.ActionMenu;
import com.artillexstudios.axplayerwarps.libs.gui.actions.impl.ActionMessage;
import com.artillexstudios.axplayerwarps.libs.gui.actions.impl.ActionPage;
import com.artillexstudios.axplayerwarps.libs.gui.actions.impl.ActionPlayerCommand;
import com.artillexstudios.axplayerwarps.libs.gui.actions.impl.ActionRefresh;
import com.artillexstudios.axplayerwarps.libs.gui.actions.impl.ActionSound;
import com.artillexstudios.axplayerwarps.libs.gui.utils.CooldownManager;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import org.apache.commons.lang3.StringUtils;
import org.bukkit.entity.Player;

public class GuiActions {
    private static final HashMap<String, Action> ACTIONS = new HashMap();
    private static final Action CONSOLE_COMMAND = GuiActions.register(new ActionConsoleCommand());
    private static final Action FIREWORK = GuiActions.register(new ActionFirework());
    private static final Action PLAYER_COMMAND = GuiActions.register(new ActionPlayerCommand());
    private static final Action SOUND = GuiActions.register(new ActionSound());
    private static final Action MESSAGE = GuiActions.register(new ActionMessage());
    private static final Action MENU = GuiActions.register(new ActionMenu());
    private static final Action PAGE = GuiActions.register(new ActionPage());
    private static final Action REFRESH = GuiActions.register(new ActionRefresh());

    public static HashMap<String, Action> getActions() {
        return ACTIONS;
    }

    public static Action register(Action action) {
        ACTIONS.put(action.getId(), action);
        return action;
    }

    public static void run(Player player, GuiFrame gui, List<String> actions) {
        if (CooldownManager.getOrAddCooldown(player)) {
            return;
        }
        for (String rawAction : actions) {
            if (rawAction == null || rawAction.isBlank()) continue;
            String id = StringUtils.substringBetween((String)rawAction, (String)"[", (String)"]").toLowerCase(Locale.ENGLISH);
            String arguments = StringUtils.substringAfter((String)rawAction, (String)"] ");
            Action action = ACTIONS.get(id);
            if (action == null) continue;
            action.run(player, gui, arguments);
        }
    }
}

