/*
 * Decompiled with CFR 0.152.
 */
package com.artillexstudios.axplayerwarps.warps;

import com.artillexstudios.axplayerwarps.AxPlayerWarps;
import com.artillexstudios.axplayerwarps.libs.axapi.scheduler.Scheduler;
import com.artillexstudios.axplayerwarps.libs.axapi.utils.Cooldown;
import com.artillexstudios.axplayerwarps.libs.axapi.utils.Pair;
import com.artillexstudios.axplayerwarps.warps.Warp;
import java.util.Iterator;
import java.util.Map;
import java.util.WeakHashMap;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class WarpQueue {
    private static final Map<Player, Pair<Warp, Long>> queue = new WeakHashMap<Player, Pair<Warp, Long>>();
    private static final Cooldown<Player> cooldown = Cooldown.create();

    public static void start() {
        Scheduler.get().runTimer(() -> {
            long time = AxPlayerWarps.CONFIG.getLong("teleport-delay-seconds");
            try {
                Iterator<Map.Entry<Player, Pair<Warp, Long>>> it = queue.entrySet().iterator();
                while (it.hasNext()) {
                    Map.Entry<Player, Pair<Warp, Long>> e = it.next();
                    if (cooldown.hasCooldown(e.getKey())) continue;
                    cooldown.addCooldown(e.getKey(), 1000L);
                    long spent = (System.currentTimeMillis() - e.getValue().getValue()) / 1000L;
                    if (spent >= time) {
                        e.getValue().getKey().completeTeleportPlayer(e.getKey());
                        it.remove();
                        continue;
                    }
                    AxPlayerWarps.MESSAGEUTILS.sendLang((CommandSender)e.getKey(), "teleport.in", Map.of("%seconds%", "" + (time - spent)));
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }, 2L, 2L);
    }

    public static void addToQueue(Player player, Warp warp) {
        queue.put(player, new Pair<Warp, Long>(warp, System.currentTimeMillis()));
    }

    public static Map<Player, Pair<Warp, Long>> getQueue() {
        return queue;
    }
}

