/*
 * Decompiled with CFR 0.152.
 */
package com.artillexstudios.axplayerwarps.guis;

import com.artillexstudios.axplayerwarps.AxPlayerWarps;
import com.artillexstudios.axplayerwarps.category.Category;
import com.artillexstudios.axplayerwarps.category.CategoryManager;
import com.artillexstudios.axplayerwarps.enums.Access;
import com.artillexstudios.axplayerwarps.enums.AccessList;
import com.artillexstudios.axplayerwarps.guis.BlacklistGui;
import com.artillexstudios.axplayerwarps.guis.WhitelistGui;
import com.artillexstudios.axplayerwarps.hooks.HookManager;
import com.artillexstudios.axplayerwarps.hooks.currency.CurrencyHook;
import com.artillexstudios.axplayerwarps.input.InputManager;
import com.artillexstudios.axplayerwarps.libs.axapi.config.Config;
import com.artillexstudios.axplayerwarps.libs.axapi.items.WrappedItemStack;
import com.artillexstudios.axplayerwarps.libs.axapi.items.component.DataComponents;
import com.artillexstudios.axplayerwarps.libs.axapi.libs.boostedyaml.settings.dumper.DumperSettings;
import com.artillexstudios.axplayerwarps.libs.axapi.libs.boostedyaml.settings.general.GeneralSettings;
import com.artillexstudios.axplayerwarps.libs.axapi.libs.boostedyaml.settings.loader.LoaderSettings;
import com.artillexstudios.axplayerwarps.libs.axapi.libs.boostedyaml.settings.updater.UpdaterSettings;
import com.artillexstudios.axplayerwarps.libs.axapi.scheduler.Scheduler;
import com.artillexstudios.axplayerwarps.libs.axapi.utils.ItemBuilder;
import com.artillexstudios.axplayerwarps.libs.axapi.utils.NumberUtils;
import com.artillexstudios.axplayerwarps.libs.axapi.utils.StringUtils;
import com.artillexstudios.axplayerwarps.libs.axapi.utils.placeholder.Placeholder;
import com.artillexstudios.axplayerwarps.libs.gui.GuiFrame;
import com.artillexstudios.axplayerwarps.libs.gui.actions.GuiActions;
import com.artillexstudios.axplayerwarps.libs.gui.item.AxGuiItem;
import com.artillexstudios.axplayerwarps.libs.gui.replacements.Replacements;
import com.artillexstudios.axplayerwarps.placeholders.Placeholders;
import com.artillexstudios.axplayerwarps.user.Users;
import com.artillexstudios.axplayerwarps.user.WarpUser;
import com.artillexstudios.axplayerwarps.utils.StarUtils;
import com.artillexstudios.axplayerwarps.utils.WarpNameUtils;
import com.artillexstudios.axplayerwarps.warps.Warp;
import com.artillexstudios.gui.builder.gui.SimpleBuilder;
import com.artillexstudios.gui.guis.Gui;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.ItemStack;

public class EditWarpGui
extends GuiFrame {
    private static final Config GUI = new Config(new File(AxPlayerWarps.getInstance().getDataFolder(), "guis/edit-warp.yml"), AxPlayerWarps.getInstance().getResource("guis/edit-warp.yml"), GeneralSettings.builder().setUseDefaults(false).build(), LoaderSettings.builder().build(), DumperSettings.DEFAULT, UpdaterSettings.builder().build());
    private final Gui gui;
    private final Warp warp;
    private final WarpUser user;

    public EditWarpGui(Player player, Warp warp) {
        super(GUI.getInt("auto-update-ticks", -1), GUI, player);
        this.user = Users.get(player);
        this.setPlaceholder(new Placeholder((pl, s) -> {
            Integer rating = warp.getAllRatings().get(player.getUniqueId());
            s = s.replace("%given_rating_decimal%", rating == null ? "" : Placeholders.df.format(rating));
            s = s.replace("%given_rating_stars%", rating == null ? AxPlayerWarps.LANG.getString("placeholders.no-rating") : StarUtils.getFormatted(rating.intValue(), 5));
            s = s.replace("%blacklisted%", "" + warp.getAccessList(AccessList.BLACKLIST).size());
            s = s.replace("%whitelisted%", "" + warp.getAccessList(AccessList.WHITELIST).size());
            s = Placeholders.parse(warp, (OfflinePlayer)pl, s);
            return s;
        }));
        this.warp = warp;
        this.gui = ((SimpleBuilder)((SimpleBuilder)((SimpleBuilder)Gui.gui().disableAllInteractions()).title(StringUtils.format(GUI.getString("title", ""), Map.of("%warp%", warp.getName())))).rows(GUI.getInt("rows", 5))).create();
        this.setGui(this.gui);
        this.user.addGui(this);
        this.gui.setPlayerInventoryAction(event -> {
            if (event.getCurrentItem() == null) {
                return;
            }
            warp.setIcon(event.getCurrentItem().getType());
            AxPlayerWarps.getThreadedQueue().submit(() -> {
                AxPlayerWarps.getDatabase().updateWarp(warp);
                AxPlayerWarps.MESSAGEUTILS.sendLang((CommandSender)player, "editor.update-icon", new TagResolver[0]);
            });
            this.open();
        });
    }

    public static boolean reload() {
        return GUI.reload();
    }

    @Override
    public void open() {
        AxGuiItem guiItem = this.createItem("name-icon", (InventoryClickEvent event) -> {
            GuiActions.run(this.player, this, this.file.getStringList("name-icon.actions"));
            if (event.isShiftClick() && event.isRightClick()) {
                this.warp.setIcon(null);
                AxPlayerWarps.getThreadedQueue().submit(() -> {
                    AxPlayerWarps.getDatabase().updateWarp(this.warp);
                    AxPlayerWarps.MESSAGEUTILS.sendLang((CommandSender)this.player, "editor.remove-icon", new TagResolver[0]);
                });
                this.open();
                return;
            }
            InputManager.getInput(this.player, "rename", result -> {
                if (result.isBlank()) {
                    AxPlayerWarps.MESSAGEUTILS.sendLang((CommandSender)this.player, "errors.invalid-name", new TagResolver[0]);
                    this.open();
                    return;
                }
                switch (WarpNameUtils.isAllowed(result)) {
                    case DISALLOWED: {
                        AxPlayerWarps.MESSAGEUTILS.sendLang((CommandSender)this.player, "errors.disallowed-name-blacklisted", new TagResolver[0]);
                        return;
                    }
                    case CONTAINS_SPACES: {
                        AxPlayerWarps.MESSAGEUTILS.sendLang((CommandSender)this.player, "errors.disallowed-name-space", new TagResolver[0]);
                        return;
                    }
                    case INVALID_LENGTH: {
                        AxPlayerWarps.MESSAGEUTILS.sendLang((CommandSender)this.player, "errors.disallowed-name-length", new TagResolver[0]);
                        return;
                    }
                }
                AxPlayerWarps.getThreadedQueue().submit(() -> {
                    if (!this.warp.setName(result.replace(" ", "_"))) {
                        AxPlayerWarps.MESSAGEUTILS.sendLang((CommandSender)this.player, "errors.name-exists", new TagResolver[0]);
                    } else {
                        AxPlayerWarps.getDatabase().updateWarp(this.warp);
                        AxPlayerWarps.MESSAGEUTILS.sendLang((CommandSender)this.player, "editor.update-name", new TagResolver[0]);
                    }
                    Scheduler.get().run(() -> this.open());
                });
            });
        });
        ItemStack mt = guiItem.getItemStack();
        if (this.warp.getIcon() != null) {
            mt.setType(this.warp.getIcon());
        }
        guiItem.setItemStack(mt);
        this.createItem("location", (InventoryClickEvent event) -> {
            GuiActions.run(this.player, this, this.file.getStringList("location.actions"));
            this.warp.setLocation(this.player.getLocation());
            AxPlayerWarps.getThreadedQueue().submit(() -> {
                AxPlayerWarps.getDatabase().updateWarp(this.warp);
                AxPlayerWarps.MESSAGEUTILS.sendLang((CommandSender)this.player, "editor.update-location", new TagResolver[0]);
            });
            this.open();
        });
        this.createItem("transfer", (InventoryClickEvent event) -> {
            GuiActions.run(this.player, this, this.file.getStringList("transfer.actions"));
            this.warp.setLocation(this.player.getLocation());
            InputManager.getInput(this.player, "transfer", result -> AxPlayerWarps.getThreadedQueue().submit(() -> {
                UUID uuid = AxPlayerWarps.getDatabase().getUUIDFromName((String)result);
                if (uuid == null) {
                    AxPlayerWarps.MESSAGEUTILS.sendLang((CommandSender)this.player, "errors.player-not-found", new TagResolver[0]);
                } else {
                    Player transferTo = Bukkit.getPlayer((UUID)uuid);
                    this.warp.setOwner(uuid);
                    AxPlayerWarps.getDatabase().updateWarp(this.warp);
                    OfflinePlayer pl = Bukkit.getOfflinePlayer((UUID)uuid);
                    AxPlayerWarps.getDatabase().removeFromList(this.warp, AccessList.WHITELIST, pl);
                    AxPlayerWarps.getDatabase().removeFromList(this.warp, AccessList.BLACKLIST, pl);
                    if (transferTo != null) {
                        AxPlayerWarps.MESSAGEUTILS.sendLang((CommandSender)transferTo, "editor.new-owner", Map.of("%player%", this.player.getName(), "%warp%", this.warp.getName()));
                    }
                    AxPlayerWarps.MESSAGEUTILS.sendLang((CommandSender)this.player, "editor.transferred", Map.of("%player%", pl.getName() == null ? "---" : pl.getName()));
                }
                Scheduler.get().runAt(this.player.getLocation(), () -> this.player.closeInventory());
            }));
        });
        this.createItem("access", (InventoryClickEvent event) -> {
            GuiActions.run(this.player, this, this.file.getStringList("access.actions"));
            Access currAccess = this.warp.getAccess();
            ArrayList<Access> accesses = new ArrayList<Access>(List.of(Access.values()));
            int idx = accesses.indexOf((Object)currAccess);
            if (event.isLeftClick()) {
                if (++idx >= accesses.size()) {
                    idx = 0;
                }
            } else if (event.isRightClick()) {
                if (event.isShiftClick()) {
                    idx = 0;
                } else if (--idx < 0) {
                    idx = accesses.size() - 1;
                }
            }
            this.warp.setAccess(accesses.get(idx));
            AxPlayerWarps.getThreadedQueue().submit(() -> AxPlayerWarps.getDatabase().updateWarp(this.warp));
            this.open();
        });
        this.createItem("category", (InventoryClickEvent event) -> {
            int idx;
            GuiActions.run(this.player, this, this.file.getStringList("category.actions"));
            Category category = this.warp.getCategory();
            ArrayList<Category> categories = new ArrayList<Category>(CategoryManager.getCategories().values());
            int n = idx = category == null ? -1 : categories.indexOf(category);
            if (event.isLeftClick()) {
                if (++idx >= categories.size()) {
                    idx = 0;
                }
            } else if (event.isRightClick()) {
                if (idx == -1) {
                    idx = 0;
                }
                if (event.isShiftClick()) {
                    idx = -1;
                } else if (--idx < 0) {
                    idx = categories.size() - 1;
                }
            }
            this.warp.setCategory(idx == -1 ? null : categories.get(idx));
            AxPlayerWarps.getThreadedQueue().submit(() -> AxPlayerWarps.getDatabase().updateWarp(this.warp));
            this.open();
        });
        this.createItem("price", (InventoryClickEvent event) -> {
            int idx;
            GuiActions.run(this.player, this, this.file.getStringList("price.actions"));
            if (this.warp.getEarnedMoney() > 0.0) {
                this.warp.withdrawMoney();
            }
            CurrencyHook currency = this.warp.getCurrency();
            ArrayList<CurrencyHook> currencies = HookManager.getCurrency();
            int n = idx = currency == null ? -1 : currencies.indexOf(currency);
            if (event.isLeftClick()) {
                if (event.isShiftClick()) {
                    InputManager.getInput(this.player, "price", result -> {
                        if (!NumberUtils.isInt(result)) {
                            AxPlayerWarps.MESSAGEUTILS.sendLang((CommandSender)this.player, "errors.not-a-number", new TagResolver[0]);
                        } else {
                            int price = Integer.parseInt(result);
                            if (price < 1) {
                                AxPlayerWarps.MESSAGEUTILS.sendLang((CommandSender)this.player, "errors.must-be-positive", new TagResolver[0]);
                                this.open();
                                return;
                            }
                            this.warp.setTeleportPrice(price);
                            AxPlayerWarps.getThreadedQueue().submit(() -> AxPlayerWarps.getDatabase().updateWarp(this.warp));
                        }
                        this.open();
                    });
                    return;
                }
                if (++idx >= currencies.size()) {
                    idx = 0;
                }
            } else if (event.isRightClick()) {
                if (idx == -1) {
                    idx = 0;
                }
                if (event.isShiftClick()) {
                    idx = -1;
                    this.warp.setTeleportPrice(0.0);
                } else if (--idx < 0) {
                    idx = currencies.size() - 1;
                }
            }
            this.warp.setCurrency(idx == -1 ? null : currencies.get(idx));
            AxPlayerWarps.getThreadedQueue().submit(() -> AxPlayerWarps.getDatabase().updateWarp(this.warp));
            this.open();
        });
        this.createItem("delete", (InventoryClickEvent event) -> {
            if (event.isShiftClick() && event.isRightClick()) {
                GuiActions.run(this.player, this, this.file.getStringList("delete.actions"));
                this.warp.delete();
                Scheduler.get().runLaterAt(this.player.getLocation(), () -> this.player.closeInventory(), 1L);
            }
        });
        this.createItem("bank", (InventoryClickEvent event) -> {
            GuiActions.run(this.player, this, this.file.getStringList("bank.actions"));
            this.warp.withdrawMoney();
            this.open();
        });
        ItemBuilder builder = ItemBuilder.create(this.file.getSection("description"));
        WrappedItemStack wrap = WrappedItemStack.wrap(builder.get());
        ArrayList<String> lore = new ArrayList<String>();
        String[] description = this.warp.getDescription().split("\n", AxPlayerWarps.CONFIG.getInt("warp-description.max-lines", 3));
        for (Component line : wrap.get(DataComponents.lore()).lines()) {
            String serialized = (String)Placeholders.mm.serialize(line);
            if (serialized.contains("%description%")) {
                for (String s : description) {
                    lore.add(serialized.replace("%description%", s));
                }
                continue;
            }
            lore.add(serialized);
        }
        builder.setLore(lore);
        this.createItem("description", builder.get(), event -> {
            ArrayList<String> desc;
            GuiActions.run(this.player, this, this.file.getStringList("description.actions"));
            String realDesc = this.warp.getRealDescription();
            ArrayList<String> arrayList = desc = realDesc == null ? new ArrayList<String>() : new ArrayList<String>(Arrays.stream(realDesc.split("\n")).toList());
            if (event.isLeftClick()) {
                if (AxPlayerWarps.CONFIG.getInt("warp-description.max-lines") <= desc.size()) {
                    AxPlayerWarps.MESSAGEUTILS.sendLang((CommandSender)this.player, "errors.max-lines", new TagResolver[0]);
                    this.open();
                    return;
                }
                InputManager.getInput(this.player, "add-line", result -> {
                    desc.add((String)result);
                    this.warp.setDescription(desc);
                    AxPlayerWarps.getThreadedQueue().submit(() -> {
                        AxPlayerWarps.getDatabase().updateWarp(this.warp);
                        Scheduler.get().run(() -> this.open());
                    });
                });
                return;
            }
            if (event.isRightClick()) {
                if (event.isShiftClick()) {
                    desc.clear();
                    this.warp.setDescription(desc);
                    AxPlayerWarps.getThreadedQueue().submit(() -> AxPlayerWarps.getDatabase().updateWarp(this.warp));
                    this.open();
                    return;
                }
                desc.removeLast();
                this.warp.setDescription(desc);
                AxPlayerWarps.getThreadedQueue().submit(() -> AxPlayerWarps.getDatabase().updateWarp(this.warp));
                this.open();
            }
        }, new Replacements(), List.of());
        this.createItem("whitelist", (InventoryClickEvent event) -> {
            GuiActions.run(this.player, this, this.file.getStringList("whitelist.actions"));
            new WhitelistGui(this.player, this.warp).open();
        });
        this.createItem("blacklist", (InventoryClickEvent event) -> {
            GuiActions.run(this.player, this, this.file.getStringList("blacklist.actions"));
            new BlacklistGui(this.player, this.warp).open();
        });
        this.gui.update();
        this.gui.open((HumanEntity)this.player);
    }
}

