/*
 * Decompiled with CFR 0.152.
 */
package com.artillexstudios.axplayerwarps.hooks.currency;

import com.artillexstudios.axplayerwarps.hooks.currency.CurrencyHook;
import com.artillexstudios.axplayerwarps.libs.axapi.utils.StringUtils;
import com.willfp.ecobits.currencies.Currencies;
import com.willfp.ecobits.currencies.Currency;
import com.willfp.ecobits.currencies.CurrencyUtils;
import java.math.BigDecimal;
import java.util.UUID;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.jetbrains.annotations.NotNull;

public class EcoBitsHook
implements CurrencyHook {
    private Currency currency = null;
    private final String internal;
    private final String name;

    public EcoBitsHook(String internal, String name) {
        this.internal = internal;
        this.name = name;
    }

    @Override
    public void setup() {
        this.currency = Currencies.getByID((String)this.internal);
        if (this.currency == null) {
            Bukkit.getConsoleSender().sendMessage(StringUtils.formatToString("&#FF0000[AxPlayerWarps] EcoBits currency named &#DD0000" + this.internal + " &#FF0000not found! Change the currency-name or disable the hook to get rid of this warning!", new TagResolver[0]));
        }
    }

    @Override
    public String getName() {
        return "EcoBits-" + this.internal;
    }

    @Override
    public String getDisplayName() {
        return this.name;
    }

    @Override
    public boolean worksOffline() {
        return false;
    }

    @Override
    public boolean usesDouble() {
        return true;
    }

    @Override
    public boolean isPersistent() {
        return false;
    }

    @Override
    public double getBalance(@NotNull UUID player) {
        if (this.currency == null) {
            return 0.0;
        }
        return CurrencyUtils.getBalance((OfflinePlayer)Bukkit.getOfflinePlayer((UUID)player), (Currency)this.currency).doubleValue();
    }

    @Override
    public void giveBalance(@NotNull UUID player, double amount) {
        if (this.currency == null) {
            return;
        }
        CurrencyUtils.adjustBalance((OfflinePlayer)Bukkit.getOfflinePlayer((UUID)player), (Currency)this.currency, (BigDecimal)BigDecimal.valueOf(amount));
    }

    @Override
    public void takeBalance(@NotNull UUID player, double amount) {
        if (this.currency == null) {
            return;
        }
        CurrencyUtils.adjustBalance((OfflinePlayer)Bukkit.getOfflinePlayer((UUID)player), (Currency)this.currency, (BigDecimal)BigDecimal.valueOf(amount * -1.0));
    }
}

