/*
 * Decompiled with CFR 0.152.
 */
package com.artillexstudios.axplayerwarps.hooks.currency;

import com.artillexstudios.axplayerwarps.hooks.currency.CurrencyHook;
import com.artillexstudios.axplayerwarps.libs.axapi.utils.StringUtils;
import dev.unnm3d.rediseconomy.api.RedisEconomyAPI;
import dev.unnm3d.rediseconomy.currency.Currency;
import java.util.UUID;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import org.bukkit.Bukkit;
import org.jetbrains.annotations.NotNull;

public class RedisEconomyHook
implements CurrencyHook {
    private Currency currency = null;
    private final String internal;
    private final String name;

    public RedisEconomyHook(String internal, String name) {
        this.internal = internal;
        this.name = name;
    }

    @Override
    public void setup() {
        RedisEconomyAPI api = RedisEconomyAPI.getAPI();
        this.currency = api.getCurrencyByName(this.internal);
        if (this.currency == null) {
            Bukkit.getConsoleSender().sendMessage(StringUtils.formatToString("&#FF0000[AxPlayerWarps] RedisEconomy currency named &#DD0000" + this.internal + " &#FF0000not found! Change the currency-name or disable the hook to get rid of this warning!", new TagResolver[0]));
        }
    }

    @Override
    public String getName() {
        return "RedisEconomy-" + this.internal;
    }

    @Override
    public String getDisplayName() {
        return this.name;
    }

    @Override
    public boolean worksOffline() {
        return true;
    }

    @Override
    public boolean usesDouble() {
        return true;
    }

    @Override
    public boolean isPersistent() {
        return false;
    }

    @Override
    public double getBalance(@NotNull UUID player) {
        if (this.currency == null) {
            return 0.0;
        }
        return this.currency.getBalance(player);
    }

    @Override
    public void giveBalance(@NotNull UUID player, double amount) {
        if (this.currency == null) {
            return;
        }
        this.currency.depositPlayer(player, null, amount, null);
    }

    @Override
    public void takeBalance(@NotNull UUID player, double amount) {
        if (this.currency == null) {
            return;
        }
        this.currency.withdrawPlayer(player, null, amount, null);
    }
}

