/*
 * Decompiled with CFR 0.152.
 */
package com.artillexstudios.axplayerwarps.libs.axintegrations.integration.prices;

import com.artillexstudios.axplayerwarps.libs.axintegrations.integration.prices.PriceIntegration;
import com.artillexstudios.axplayerwarps.libs.axintegrations.integration.prices.implementation.AxGensPriceIntegration;
import com.artillexstudios.axplayerwarps.libs.axintegrations.integration.prices.implementation.CMIPriceIntegration;
import com.artillexstudios.axplayerwarps.libs.axintegrations.integration.prices.implementation.DynamicShop3PriceIntegration;
import com.artillexstudios.axplayerwarps.libs.axintegrations.integration.prices.implementation.EconomyShopGUIPriceIntegration;
import com.artillexstudios.axplayerwarps.libs.axintegrations.integration.prices.implementation.EssentialsPriceIntegration;
import com.artillexstudios.axplayerwarps.libs.axintegrations.integration.prices.implementation.ExcellentShopPriceIntegration;
import com.artillexstudios.axplayerwarps.libs.axintegrations.integration.prices.implementation.ShopGUIPlusPriceIntegration;
import com.artillexstudios.axplayerwarps.libs.axintegrations.integration.prices.implementation.ZShopPriceIntegration;
import com.artillexstudios.axplayerwarps.libs.axintegrations.registry.IntegrationRegistry;
import java.util.Collection;
import java.util.function.Supplier;

public final class PriceIntegrations {
    private static final IntegrationRegistry<PriceIntegration> registry = new IntegrationRegistry();

    public static void init() {
        PriceIntegrations.register(AxGensPriceIntegration::new);
        PriceIntegrations.register(CMIPriceIntegration::new);
        PriceIntegrations.register(DynamicShop3PriceIntegration::new);
        PriceIntegrations.register(EconomyShopGUIPriceIntegration::new);
        PriceIntegrations.register(EssentialsPriceIntegration::new);
        PriceIntegrations.register(ExcellentShopPriceIntegration::new);
        PriceIntegrations.register(ShopGUIPlusPriceIntegration::new);
        PriceIntegrations.register(ZShopPriceIntegration::new);
    }

    public static Collection<PriceIntegration> values() {
        return registry.values();
    }

    public static void register(Supplier<PriceIntegration> integration) {
        PriceIntegration instance;
        try {
            instance = integration.get();
        }
        catch (Throwable throwable) {
            return;
        }
        if (!instance.canRegister()) {
            return;
        }
        registry.register(instance);
        instance.register();
    }
}

