/*
 * Decompiled with CFR 0.152.
 */
package com.artillexstudios.axplayerwarps.libs.lamp.bukkit.brigadier;

import com.artillexstudios.axplayerwarps.libs.lamp.bukkit.BukkitCommandActor;
import com.artillexstudios.axplayerwarps.libs.lamp.bukkit.BukkitCommandHandler;
import com.artillexstudios.axplayerwarps.libs.lamp.bukkit.brigadier.BrigadierUtil;
import com.artillexstudios.axplayerwarps.libs.lamp.bukkit.brigadier.Commodore;
import com.artillexstudios.axplayerwarps.libs.lamp.bukkit.core.BukkitCommandExecutor;
import com.artillexstudios.axplayerwarps.libs.lamp.command.ArgumentStack;
import com.artillexstudios.axplayerwarps.libs.lamp.command.CommandActor;
import com.artillexstudios.axplayerwarps.libs.lamp.exception.ArgumentParseException;
import com.artillexstudios.axplayerwarps.libs.lamp.util.Strings;
import com.destroystokyo.paper.event.brigadier.CommandRegisteredEvent;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.tree.LiteralCommandNode;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.bukkit.Bukkit;
import org.bukkit.Warning;
import org.bukkit.command.Command;
import org.bukkit.command.PluginCommand;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.command.UnknownCommandEvent;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;

final class PaperCommodore
extends Commodore
implements Listener {
    private final Map<String, LiteralCommandNode<?>> commands = new HashMap();
    private final BukkitCommandHandler handler;
    private final String fallbackPrefix;

    PaperCommodore(@NotNull BukkitCommandHandler handler) {
        this.handler = handler;
        Plugin plugin = handler.getPlugin();
        this.fallbackPrefix = plugin.getName().toLowerCase().trim();
        this.registerListener(plugin);
    }

    private void registerListener(Plugin plugin) {
        Bukkit.getPluginManager().registerEvents((Listener)new UnknownCommandListener(), plugin);
        try {
            Warning.WarningState prevState = Bukkit.getWarningState();
            Class<?> craftServer = Bukkit.getServer().getClass();
            Field warningState = craftServer.getDeclaredField("warningState");
            warningState.setAccessible(true);
            warningState.set(Bukkit.getServer(), Warning.WarningState.OFF);
            Bukkit.getPluginManager().registerEvents((Listener)new CommandRegisterListener(), plugin);
            warningState.set(Bukkit.getServer(), prevState);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    @Override
    public void register(LiteralCommandNode<?> node) {
        Objects.requireNonNull(node, "node");
        this.commands.put(node.getLiteral(), node);
    }

    @Override
    public void register(Command command, LiteralCommandNode<?> node) {
        Objects.requireNonNull(command, "command");
        Objects.requireNonNull(node, "node");
        Collection<String> aliases = PaperCommodore.getAliases(command);
        if (!aliases.contains(node.getLiteral())) {
            node = BrigadierUtil.renameLiteralNode(node, command.getName());
        }
        for (String alias : aliases) {
            if (node.getLiteral().equals(alias)) {
                this.commands.put(node.getLiteral(), node);
                continue;
            }
            LiteralCommandNode redirectNode = ((LiteralArgumentBuilder)LiteralArgumentBuilder.literal((String)alias).redirect(node)).build();
            this.commands.put(redirectNode.getLiteral(), redirectNode);
        }
    }

    static void ensureSetup() {
    }

    static {
        try {
            Class.forName("com.destroystokyo.paper.event.brigadier.AsyncPlayerSendCommandsEvent");
        }
        catch (ClassNotFoundException e) {
            throw new UnsupportedOperationException("Not running on modern Paper!", e);
        }
    }

    public final class CommandRegisterListener
    implements Listener {
        @EventHandler
        public void onCommandRegistered(CommandRegisteredEvent<?> event) {
            if (!(event.getCommand() instanceof PluginCommand)) {
                return;
            }
            PluginCommand pCommand = (PluginCommand)event.getCommand();
            if (!(pCommand.getExecutor() instanceof BukkitCommandExecutor)) {
                return;
            }
            LiteralCommandNode node = (LiteralCommandNode)PaperCommodore.this.commands.get(event.getCommandLabel());
            if (node != null) {
                event.setLiteral(node);
            }
        }
    }

    public final class UnknownCommandListener
    implements Listener {
        @EventHandler
        public void onUnknownCommand(UnknownCommandEvent event) {
            if (event.getCommandLine().isEmpty()) {
                return;
            }
            try {
                ArgumentStack args = ArgumentStack.parse(Strings.stripNamespace(PaperCommodore.this.fallbackPrefix, event.getCommandLine()));
                if (PaperCommodore.this.commands.containsKey(args.getFirst())) {
                    event.setMessage(null);
                    BukkitCommandActor actor = BukkitCommandActor.wrap(event.getSender(), PaperCommodore.this.handler);
                    try {
                        PaperCommodore.this.handler.dispatch((CommandActor)actor, args);
                    }
                    catch (Throwable t) {
                        PaperCommodore.this.handler.getExceptionHandler().handleException(t, actor);
                    }
                }
            }
            catch (ArgumentParseException argumentParseException) {
                // empty catch block
            }
        }
    }
}

