/*
 * Decompiled with CFR 0.152.
 */
package com.artillexstudios.axplayerwarps.libs.lamp.command;

import com.artillexstudios.axplayerwarps.libs.lamp.command.CommandParameter;
import com.artillexstudios.axplayerwarps.libs.lamp.core.LinkedArgumentStack;
import com.artillexstudios.axplayerwarps.libs.lamp.util.QuotedStringTokenizer;
import java.util.Collection;
import java.util.Deque;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Unmodifiable;
import org.jetbrains.annotations.UnmodifiableView;

public interface ArgumentStack
extends Deque<String>,
List<String>,
Cloneable {
    @NotNull
    public String join(String var1);

    @NotNull
    public String join(@NotNull String var1, int var2);

    public String popForParameter(@NotNull CommandParameter var1);

    @NotNull
    public @UnmodifiableView List<String> asImmutableView();

    @NotNull
    public @Unmodifiable List<String> asImmutableCopy();

    @NotNull
    public ArgumentStack copy();

    @NotNull
    public static ArgumentStack parse(String ... arguments) {
        if (arguments.length == 0) {
            return ArgumentStack.empty();
        }
        return new LinkedArgumentStack(QuotedStringTokenizer.parse(String.join((CharSequence)" ", arguments)));
    }

    @NotNull
    public static ArgumentStack parse(@NotNull Collection<String> arguments) {
        if (arguments.size() == 0) {
            return ArgumentStack.empty();
        }
        return new LinkedArgumentStack(QuotedStringTokenizer.parse(String.join((CharSequence)" ", arguments)));
    }

    @NotNull
    public static ArgumentStack parseForAutoCompletion(String ... arguments) {
        return new LinkedArgumentStack(QuotedStringTokenizer.parseForAutoCompletion(String.join((CharSequence)" ", arguments)));
    }

    @NotNull
    public static ArgumentStack parseForAutoCompletion(@NotNull Collection<String> arguments) {
        return new LinkedArgumentStack(QuotedStringTokenizer.parseForAutoCompletion(String.join((CharSequence)" ", arguments)));
    }

    @NotNull
    public static ArgumentStack copyExact(String ... arguments) {
        if (arguments.length == 0) {
            return ArgumentStack.empty();
        }
        return new LinkedArgumentStack(arguments);
    }

    @NotNull
    public static ArgumentStack copyExact(@NotNull List<String> arguments) {
        if (arguments.size() == 0) {
            return ArgumentStack.empty();
        }
        return new LinkedArgumentStack((Collection<? extends String>)arguments);
    }

    @NotNull
    public static ArgumentStack empty() {
        return new LinkedArgumentStack(new String[0]);
    }
}

