/*
 * Decompiled with CFR 0.152.
 */
package com.artillexstudios.axplayerwarps.libs.lamp.core;

import com.artillexstudios.axplayerwarps.libs.lamp.annotation.AutoComplete;
import com.artillexstudios.axplayerwarps.libs.lamp.autocomplete.SuggestionProvider;
import com.artillexstudios.axplayerwarps.libs.lamp.autocomplete.SuggestionProviderFactory;
import com.artillexstudios.axplayerwarps.libs.lamp.command.CommandParameter;
import com.artillexstudios.axplayerwarps.libs.lamp.util.Strings;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class AutoCompleterAnnotationFactory
implements SuggestionProviderFactory {
    private final Map<String, SuggestionProvider> tabProviders;

    public AutoCompleterAnnotationFactory(Map<String, SuggestionProvider> tabProviders) {
        this.tabProviders = tabProviders;
    }

    @Override
    @Nullable
    public SuggestionProvider createSuggestionProvider(@NotNull CommandParameter parameter) {
        AutoComplete ann = parameter.getDeclaringCommand().getAnnotation(AutoComplete.class);
        if (ann != null) {
            return this.parseTabAnnotation(ann, parameter.getCommandIndex());
        }
        return null;
    }

    private SuggestionProvider parseTabAnnotation(@NotNull AutoComplete annotation, int commandIndex) {
        if (annotation.value().isEmpty()) {
            return SuggestionProvider.EMPTY;
        }
        String[] values = Strings.SPACE.split(annotation.value());
        try {
            String providerV = values[commandIndex];
            if (providerV.equals("*")) {
                return null;
            }
            if (providerV.startsWith("@")) {
                SuggestionProvider provider = this.tabProviders.get(providerV.substring(1));
                if (provider == null) {
                    throw new IllegalStateException("No such tab suggestion provider: " + providerV.substring(1));
                }
                return provider;
            }
            List<String> suggestions = Arrays.asList(Strings.VERTICAL_BAR.split(providerV));
            return SuggestionProvider.of(suggestions);
        }
        catch (IndexOutOfBoundsException e) {
            return null;
        }
    }
}

