/*
 * Decompiled with CFR 0.152.
 */
package com.artillexstudios.axplayerwarps.placeholders;

import com.artillexstudios.axplayerwarps.AxPlayerWarps;
import com.artillexstudios.axplayerwarps.database.impl.Base;
import com.artillexstudios.axplayerwarps.libs.axapi.items.WrappedItemStack;
import com.artillexstudios.axplayerwarps.libs.axapi.items.component.DataComponents;
import com.artillexstudios.axplayerwarps.libs.axapi.items.component.type.ItemLore;
import com.artillexstudios.axplayerwarps.libs.axapi.utils.StringUtils;
import com.artillexstudios.axplayerwarps.utils.FormatUtils;
import com.artillexstudios.axplayerwarps.utils.StarUtils;
import com.artillexstudios.axplayerwarps.utils.TimeUtils;
import com.artillexstudios.axplayerwarps.warps.Warp;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.minimessage.MiniMessage;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import org.bukkit.OfflinePlayer;
import org.bukkit.World;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.Nullable;

public class Placeholders {
    public static final DecimalFormat df = new DecimalFormat("#.##");
    public static final MiniMessage mm = MiniMessage.builder().build();

    public static String parse(Base.AccessPlayer accessPlayer, @Nullable OfflinePlayer player, String t) {
        t = t.replace("%player%", accessPlayer.name());
        t = t.replace("%added-date%", TimeUtils.formatDate(accessPlayer.added()));
        return t;
    }

    public static List<String> parseList(Base.AccessPlayer accessPlayer, @Nullable OfflinePlayer player, List<String> t) {
        t.replaceAll(s -> Placeholders.parse(accessPlayer, player, s));
        return t;
    }

    public static String parse(Warp warp, @Nullable OfflinePlayer player, String t) {
        t = t.replace("%name%", warp.getName());
        t = t.replace("%owner%", AxPlayerWarps.getDatabase().getPlayerName(warp.getOwner()));
        t = t.replace("%created%", TimeUtils.formatDate(warp.getCreated()));
        World world = warp.getLocation().getWorld();
        t = t.replace("%world%", world == null ? "---" : world.getName());
        t = t.replace("%x%", df.format(warp.getLocation().getX()));
        t = t.replace("%y%", df.format(warp.getLocation().getY()));
        t = t.replace("%z%", df.format(warp.getLocation().getZ()));
        t = t.replace("%yaw%", df.format(warp.getLocation().getYaw()));
        t = t.replace("%pitch%", df.format(warp.getLocation().getPitch()));
        t = warp.getCategory() != null ? t.replace("%category%", AxPlayerWarps.CONFIG.getString("categories." + warp.getCategory().raw() + ".name")) : t.replace("%category%", AxPlayerWarps.LANG.getString("placeholders.no-category"));
        double price = warp.getCurrency() == null ? 0.0 : warp.getTeleportPrice();
        boolean isFree = warp.getCurrency() == null || warp.getTeleportPrice() == 0.0;
        t = t.replace("%price%", isFree ? AxPlayerWarps.LANG.getString("placeholders.free") : warp.getCurrency().getDisplayName().replace("%price%", df.format(price)));
        t = t.replace("%price-full%", FormatUtils.formatCurrency(warp.getCurrency(), warp.getTeleportPrice()));
        t = t.replace("%access%", AxPlayerWarps.LANG.getString("access." + warp.getAccess().name().toLowerCase()));
        double earned = warp.getEarnedMoney();
        t = t.replace("%earned_money%", FormatUtils.formatCurrency(warp.getCurrency(), earned));
        float rating = warp.getRating();
        t = t.replace("%rating_decimal%", df.format(rating));
        int starAm = Math.round(rating);
        t = t.replace("%rating_stars%", StarUtils.getFormatted(starAm, 5));
        t = t.replace("%rating_amount%", "" + warp.getRatingAmount());
        t = t.replace("%visitors%", "" + warp.getVisits());
        t = t.replace("%visitors_unique%", "" + warp.getUniqueVisits());
        t = t.replace("%favorites%", "" + warp.getFavorites());
        t = t.replace("%icon%", warp.getIcon().name().toLowerCase());
        return t;
    }

    public static List<String> parseList(Warp warp, @Nullable OfflinePlayer player, List<String> t) {
        t.replaceAll(s -> Placeholders.parse(warp, player, s));
        return t;
    }

    public static ItemStack parseItem(Warp warp, @Nullable OfflinePlayer player, ItemStack it) {
        WrappedItemStack wrap = WrappedItemStack.wrap(it);
        Component nameComponent = wrap.get(DataComponents.customName());
        ItemLore itemLore = wrap.get(DataComponents.lore());
        wrap.set(DataComponents.customName(), Placeholders.parse(warp, player, nameComponent));
        wrap.set(DataComponents.lore(), new ItemLore(Placeholders.parseListComponent(warp, player, itemLore.lines())));
        return wrap.toBukkit();
    }

    public static Component parse(Warp warp, @Nullable OfflinePlayer player, Component t) {
        String string = (String)mm.serialize(t);
        string = Placeholders.parse(warp, player, string);
        return StringUtils.format(string, new TagResolver[0]);
    }

    public static List<Component> parseListComponent(Warp warp, @Nullable OfflinePlayer player, List<Component> t) {
        ArrayList<String> strings = new ArrayList<String>();
        for (Component s : t) {
            String string = (String)mm.serialize(s);
            string = Placeholders.parse(warp, player, string);
            strings.add(string);
        }
        return StringUtils.formatList(strings, new TagResolver[0]);
    }
}

