/*
 * Decompiled with CFR 0.152.
 */
package fr.hugman.artisanat.client.texture.atlas;

import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import fr.hugman.artisanat.client.texture.atlas.OutputIdentifier;
import it.unimi.dsi.fastutil.ints.Int2IntMap;
import it.unimi.dsi.fastutil.ints.Int2IntOpenHashMap;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.IntUnaryOperator;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1011;
import net.minecraft.class_2960;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import net.minecraft.class_7368;
import net.minecraft.class_7764;
import net.minecraft.class_7771;
import net.minecraft.class_7948;
import net.minecraft.class_7958;
import net.minecraft.class_8684;
import net.minecraft.class_9848;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

@Environment(value=EnvType.CLIENT)
public record ArtisanatPalettedPermutationsAtlasSource(Map<class_2960, OutputIdentifier> textures, class_2960 paletteKey, Map<String, class_2960> permutations) implements class_7948
{
    static final Logger LOGGER = LogUtils.getLogger();
    public static final MapCodec<ArtisanatPalettedPermutationsAtlasSource> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.unboundedMap((Codec)class_2960.field_25139, OutputIdentifier.CODEC).fieldOf("textures").forGetter(source -> source.textures), (App)class_2960.field_25139.fieldOf("palette_key").forGetter(source -> source.paletteKey), (App)Codec.unboundedMap((Codec)Codec.STRING, (Codec)class_2960.field_25139).fieldOf("permutations").forGetter(source -> source.permutations)).apply((Applicative)instance, ArtisanatPalettedPermutationsAtlasSource::new));

    public void method_47673(class_3300 resourceManager, class_7948.class_7949 regions) {
        Supplier supplier = Suppliers.memoize(() -> ArtisanatPalettedPermutationsAtlasSource.open(resourceManager, this.paletteKey));
        HashMap map = new HashMap();
        this.permutations.forEach((arg_0, arg_1) -> ArtisanatPalettedPermutationsAtlasSource.lambda$load$6(map, (java.util.function.Supplier)supplier, resourceManager, arg_0, arg_1));
        for (Map.Entry<class_2960, OutputIdentifier> textureOutput : this.textures.entrySet()) {
            class_2960 identifier = textureOutput.getKey();
            class_2960 identifier2 = class_7948.field_42075.method_45112(identifier);
            Optional optional = resourceManager.method_14486(identifier2);
            if (optional.isEmpty()) {
                LOGGER.warn("Unable to find texture {}", (Object)identifier2);
                continue;
            }
            class_7958 atlasSprite = new class_7958(identifier2, (class_3298)optional.get(), map.size());
            for (Map.Entry entry : map.entrySet()) {
                class_2960 identifier3 = textureOutput.getValue().apply((String)entry.getKey());
                regions.method_47670(identifier3, (class_7948.class_7950)new PalettedSpriteRegion(atlasSprite, (java.util.function.Supplier)entry.getValue(), identifier3));
            }
        }
    }

    private static IntUnaryOperator toMapper(int[] from, int[] to) {
        if (to.length != from.length) {
            LOGGER.warn("Palette mapping has different sizes: {} and {}", (Object)from.length, (Object)to.length);
            throw new IllegalArgumentException();
        }
        Int2IntOpenHashMap int2IntMap = new Int2IntOpenHashMap(to.length);
        for (int i = 0; i < from.length; ++i) {
            int j = from[i];
            if (class_9848.method_61320((int)j) == 0) continue;
            int2IntMap.put(class_9848.method_61335((int)j), to[i]);
        }
        return arg_0 -> ArtisanatPalettedPermutationsAtlasSource.lambda$toMapper$7((Int2IntMap)int2IntMap, arg_0);
    }

    private static int[] open(class_3300 resourceManager, class_2960 texture) {
        Optional optional = resourceManager.method_14486(field_42075.method_45112(texture));
        if (optional.isEmpty()) {
            LOGGER.error("Failed to load palette image {}", (Object)texture);
            throw new IllegalArgumentException();
        }
        try {
            int[] var5;
            try (InputStream inputStream = ((class_3298)optional.get()).method_14482();
                 class_1011 nativeImage = class_1011.method_4309((InputStream)inputStream);){
                var5 = nativeImage.method_61942();
            }
            return var5;
        }
        catch (Exception var11) {
            LOGGER.error("Couldn't load texture {}", (Object)texture, (Object)var11);
            throw new IllegalArgumentException();
        }
    }

    public MapCodec<? extends class_7948> method_67288() {
        return CODEC;
    }

    private static /* synthetic */ int lambda$toMapper$7(Int2IntMap int2IntMap, int color) {
        int ix = class_9848.method_61320((int)color);
        if (ix == 0) {
            return color;
        }
        int jx = class_9848.method_61335((int)color);
        int k = int2IntMap.getOrDefault(jx, class_9848.method_61334((int)jx));
        int l = class_9848.method_61320((int)k);
        return class_9848.method_61330((int)(ix * l / 255), (int)k);
    }

    private static /* synthetic */ void lambda$load$6(Map map, java.util.function.Supplier supplier, class_3300 resourceManager, String key, class_2960 texture) {
        map.put(key, Suppliers.memoize(() -> ArtisanatPalettedPermutationsAtlasSource.lambda$load$5((java.util.function.Supplier)supplier, resourceManager, texture)));
    }

    private static /* synthetic */ IntUnaryOperator lambda$load$5(java.util.function.Supplier supplier, class_3300 resourceManager, class_2960 texture) {
        return ArtisanatPalettedPermutationsAtlasSource.toMapper((int[])supplier.get(), ArtisanatPalettedPermutationsAtlasSource.open(resourceManager, texture));
    }

    @Environment(value=EnvType.CLIENT)
    record PalettedSpriteRegion(class_7958 baseImage, java.util.function.Supplier<IntUnaryOperator> palette, class_2960 permutationLocation) implements class_7948.class_7950
    {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Nullable
        public class_7764 apply(class_8684 spriteOpener) {
            Object var3;
            try {
                class_1011 nativeImage = this.baseImage.method_47697().method_48462(this.palette.get());
                class_7764 class_77642 = new class_7764(this.permutationLocation, new class_7771(nativeImage.method_4307(), nativeImage.method_4323()), nativeImage, class_7368.field_38688);
                return class_77642;
            }
            catch (IOException | IllegalArgumentException var7) {
                LOGGER.error("unable to apply palette to {}", (Object)this.permutationLocation, (Object)var7);
                var3 = null;
            }
            finally {
                this.baseImage.method_47698();
            }
            return var3;
        }

        public void method_47676() {
            this.baseImage.method_47698();
        }
    }
}

