package fr.hugman.artisanat.block;

import fr.hugman.artisanat.Artisanat;
import fr.hugman.artisanat.block.groups.*;
import fr.hugman.artisanat.block.helper.BlockBuilder;
import fr.hugman.artisanat.block.helper.BlockFactory;
import fr.hugman.artisanat.block.type.ArtisanatBlockSetTypes;
import fr.hugman.artisanat.util.CustomRegisterable;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2436;
import net.minecraft.class_5321;
import net.minecraft.class_7924;

public class ArtisanatBlocks {
    //TODO: add stripped variants
    public static final WoodBlocks OAK_WOOD_BLOCKS = register("oak_wood", WoodBlocks.of(class_2246.field_10126, ArtisanatBlockSetTypes.OAK_WOOD));
    public static final WoodBlocks SPRUCE_WOOD_BLOCKS = register("spruce_wood", WoodBlocks.of(class_2246.field_10155, ArtisanatBlockSetTypes.SPRUCE_WOOD));
    public static final WoodBlocks BIRCH_WOOD_BLOCKS = register("birch_wood", WoodBlocks.of(class_2246.field_10307, ArtisanatBlockSetTypes.BIRCH_WOOD));
    public static final WoodBlocks JUNGLE_WOOD_BLOCKS = register("jungle_wood", WoodBlocks.of(class_2246.field_10303, ArtisanatBlockSetTypes.JUNGLE_WOOD));
    public static final WoodBlocks ACACIA_WOOD_BLOCKS = register("acacia_wood", WoodBlocks.of(class_2246.field_9999, ArtisanatBlockSetTypes.ACACIA_WOOD));
    public static final WoodBlocks CHERRY_WOOD_BLOCKS = register("cherry_wood", WoodBlocks.of(class_2246.field_42733, ArtisanatBlockSetTypes.CHERRY_WOOD));
    public static final WoodBlocks DARK_OAK_WOOD_BLOCKS = register("dark_oak_wood", WoodBlocks.of(class_2246.field_10178, ArtisanatBlockSetTypes.DARK_OAK_WOOD));
    public static final WoodBlocks PALE_OAK_WOOD_BLOCKS = register("pale_oak_wood", WoodBlocks.of(class_2246.field_54734, ArtisanatBlockSetTypes.PALE_OAK_WOOD));
    public static final WoodBlocks MANGROVE_WOOD_BLOCKS = register("mangrove_wood", WoodBlocks.of(class_2246.field_37549, ArtisanatBlockSetTypes.MANGROVE_WOOD));
    public static final WoodBlocks CRIMSON_HYPHAE_BLOCKS = register("crimson_hyphae", WoodBlocks.of(class_2246.field_22505, ArtisanatBlockSetTypes.CRIMSON_HYPHAE));
    public static final WoodBlocks WARPED_HYPHAE_BLOCKS = register("warped_hyphae", WoodBlocks.of(class_2246.field_22503, ArtisanatBlockSetTypes.WARPED_HYPHAE));

    public static final BSSWBlocks COBBLESTONE_BRICKS = register("cobblestone_bricks", BSSWBlocks.of(new BlockBuilder(class_2246.field_10445)));
    public static final BSSWBlocks MOSSY_COBBLESTONE_BRICKS = register("mossy_cobblestone_bricks", BSSWBlocks.of(new BlockBuilder(class_2246.field_9989)));

    public static final BSSWBlocks GRANITE_BRICKS = register("granite_bricks", BSSWBlocks.of(new BlockBuilder(class_2246.field_10474)));
    public static final BSSWBlocks DIORITE_BRICKS = register("diorite_bricks", BSSWBlocks.of(new BlockBuilder(class_2246.field_10508)));
    public static final BSSWBlocks ANDESITE_BRICKS = register("andesite_bricks", BSSWBlocks.of(new BlockBuilder(class_2246.field_10115)));

    public static final BSSWBlocks SANDSTONE_BRICKS = register("sandstone_bricks", BSSWBlocks.of(new BlockBuilder(class_2246.field_9979)));
    public static final BSSBlocks POLISHED_SANDSTONE = register("polished_sandstone", BSSBlocks.of(new BlockBuilder(class_2246.field_9979)));
    public static final BSSWBlocks RED_SANDSTONE_BRICKS = register("red_sandstone_bricks", BSSWBlocks.of(new BlockBuilder(class_2246.field_10344)));
    public static final BSSBlocks POLISHED_RED_SANDSTONE = register("polished_red_sandstone", BSSBlocks.of(new BlockBuilder(class_2246.field_10344)));
    public static final BSSBlocks SMOOTH_STONE_PAVING = register("smooth_stone_paving", BSSBlocks.of(new BlockBuilder(class_2246.field_10360)));
    public static final BSSWBlocks CHISELED_PRISMARINE = register("chiseled_prismarine", BSSWBlocks.of(new BlockBuilder(class_2246.field_10135)));
    public static final BSSBlocks PRISMARINE_BRICK_PAVING = register("prismarine_brick_paving", BSSBlocks.of(new BlockBuilder(class_2246.field_10006)));

    public static final StainedBSSWBlocks STAINED_BRICK_BLOCKS = register("bricks", StainedBSSWBlocks.of(class_2246.field_10104));
    public static final BSSWBlocks BRICK_TILE_BLOCKS = register("brick_tiles", BSSWBlocks.of(class_2246.field_10104));
    public static final StainedBSSWBlocks STAINED_BRICK_TILE_BLOCKS = register("brick_tiles", StainedBSSWBlocks.of(class_2246.field_10104));

    public static final SSWPBBlocks TERRACOTTA_BLOCKS = register("terracotta", SSWPBBlocks.of(class_2246.field_10415));
    public static final StainedSSWPBBlocks STAINED_TERRACOTTA_BLOCKS = register("terracotta", StainedSSWPBBlocks.terracotta());
    public static final BSSWBlocks TERRACOTTA_BRICKS = register("terracotta_bricks", BSSWBlocks.of(new BlockBuilder(class_2246.field_10415)));
    public static final StainedBSSWBlocks STAINED_TERRACOTTA_BRICKS = register("terracotta_bricks", StainedBSSWBlocks.of(class_2246.field_10415));

    public static final class_2248 DARK_PRISMARINE_WALL = register("dark_prismarine_wall", BlockFactory.wall(class_2246.field_10297));
    public static final StainedBSSWBlocks STAINED_DARK_PRISMARINE_BLOCKS = register("dark_prismarine", StainedBSSWBlocks.of(class_2246.field_10297));

    public static final StainedSSWPBBlocks CONCRETE_BLOCKS = register("concrete", StainedSSWPBBlocks.concrete());
    public static final StainedBSSWBlocks CONCRETE_BRICKS = register("concrete_bricks", StainedBSSWBlocks.of(class_2246.field_10107));

    public static final StainedBSSBlocks QUARTZ_PAVING_BLOCKS = register("quartz_paving", StainedBSSBlocks.of(class_2246.field_10153));

    public static final OreBlocks COAL_BLOCKS = register("coal", OreBlocks.of(class_2246.field_10381));
    public static final OreBlocks IRON_BLOCKS = register("iron", OreBlocks.of(class_2246.field_10085));
    public static final OreBlocks GOLD_BLOCKS = register("gold", OreBlocks.of(class_2246.field_10205));
    public static final OreBlocks LAPIS_BLOCKS = register("lapis", OreBlocks.of(class_2246.field_10441));
    public static final OreBlocks REDSTONE_BLOCKS = register("redstone", OreBlocks.of(new BlockBuilder(class_2246.field_10002).factory(class_2436::new)));
    public static final OreBlocks EMERALD_BLOCKS = register("emerald", OreBlocks.of(class_2246.field_10234));
    public static final OreBlocks DIAMOND_BLOCKS = register("diamond", OreBlocks.of(class_2246.field_10201));
    public static final OreBlocks NETHERITE_BLOCKS = register("netherite", OreBlocks.of(class_2246.field_22108));

    public static final CopperBlocks UNPLATED_COPPER_BLOCKS = register("", CopperBlocks.of("unplated", ""));
    public static final CopperBlocks COPPER_BRICKS = register("", CopperBlocks.of("", "bricks"));
    public static final CopperBlocks COPPER_TILES = register("", CopperBlocks.of("", "tiles"));

    public static class_5321<class_2248> keyOf(String id) {
        return class_5321.method_29179(class_7924.field_41254, Artisanat.id(id));
    }

    private static class_2248 register(class_5321<class_2248> key, BlockBuilder builder) {
        return builder.register(key);
    }

    private static class_2248 register(String id, BlockBuilder builder) {
        return register(keyOf(id), builder);
    }

    private static <B> B register(String id, CustomRegisterable<B> registerable) {
        return registerable.register(id);
    }
}
