package fr.hugman.artisanat.block.groups;

import com.mojang.datafixers.util.Pair;
import fr.hugman.artisanat.block.ArtisanatBlocks;
import fr.hugman.artisanat.block.helper.BlockBuilder;
import fr.hugman.artisanat.util.CustomRegisterable;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_5812;
import net.minecraft.class_5955;

public record CopperBlocks(
        Map<Pair<class_5955.class_5811, Boolean>, class_2248> map
) {
    public static Builder of(String prefix, String suffix) {
        if (!prefix.isEmpty()) prefix = prefix + "_";
        if (!suffix.isEmpty()) suffix = "_" + suffix;
        return new Builder(prefix, suffix);
    }

    public class_2248 get(class_5955.class_5811 level, boolean waxed) {
        return map.get(Pair.of(level, waxed));
    }

    public static class Builder implements CustomRegisterable<CopperBlocks> {
        private final String prefix;
        private final String suffix;

        public Builder(String prefix, String suffix) {
            this.prefix = prefix;
            this.suffix = suffix;
        }

        public CopperBlocks register(String path) {
            var map = new HashMap<Pair<class_5955.class_5811, Boolean>, class_2248>();
            String[] oxidationLevels = {"copper", "exposed_copper", "weathered_copper", "oxidized_copper"};
            for (class_5955.class_5811 level : class_5955.class_5811.values()) {
                for (boolean waxed : new boolean[]{true, false}) {
                    var defSuffix = (suffix.isEmpty() && level == class_5955.class_5811.field_28704 ? "_block" : suffix);
                    var name = (waxed ? "waxed_" : "") + prefix + oxidationLevels[level.ordinal()] + defSuffix;
                    map.put(Pair.of(level, waxed), makeBlock(level, waxed, name));
                }
            }
            return new CopperBlocks(map);
        }

        private class_2248 makeBlock(class_5955.class_5811 level, boolean waxed, String name) {
            var builder = new BlockBuilder(switch (level) {
                case class_5955.class_5811.field_28704 -> class_2246.field_27119;
                case class_5955.class_5811.field_28705 -> class_2246.field_27118;
                case class_5955.class_5811.field_28706 -> class_2246.field_27117;
                case class_5955.class_5811.field_28707 -> class_2246.field_27116;
            });

            if (!waxed) {
                builder.factory(s -> new class_5812(level, s));
            }

            return builder.register(ArtisanatBlocks.keyOf(name));
        }
    }
}
