package fr.hugman.artisanat.block.groups;

import fr.hugman.artisanat.block.ArtisanatBlocks;
import fr.hugman.artisanat.block.helper.BlockFactory;
import fr.hugman.artisanat.util.CustomRegisterable;
import net.minecraft.class_2248;
import net.minecraft.class_8177;

/**
 * Contains a slab, stairs, wall, pressure plate and button variants for a registered block.
 */
public record SSWPBBlocks(
        class_2248 slab,
        class_2248 stairs,
        class_2248 wall,
        class_2248 pressurePlate,
        class_2248 button
) {
    /**
     * @param baseBlock block that MUST be registered
     */
    public static Builder of(class_2248 baseBlock) {
        return new Builder(baseBlock);
    }

    public class_2248[] all() {
        return new class_2248[]{slab, stairs, wall, pressurePlate, button};
    }

    public static class Builder implements CustomRegisterable<SSWPBBlocks> {
        private final class_2248 baseBlock;
        private class_8177 setType;

        private Builder(class_2248 baseBlock) {
            this.baseBlock = baseBlock;
            this.setType = class_8177.field_42821;
        }

        public Builder setType(class_8177 setType) {
            this.setType = setType;
            return this;
        }

        public SSWPBBlocks register(String path) {
            return new SSWPBBlocks(
                    BlockFactory.slab(baseBlock).register(ArtisanatBlocks.keyOf(path + "_slab")),
                    BlockFactory.stairs(baseBlock).register(ArtisanatBlocks.keyOf(path + "_stairs")),
                    BlockFactory.wall(baseBlock).register(ArtisanatBlocks.keyOf(path + "_wall")),
                    BlockFactory.pressurePlate(baseBlock, setType).register(ArtisanatBlocks.keyOf(path + "_pressure_plate")),
                    BlockFactory.stoneButton(baseBlock, setType).register(ArtisanatBlocks.keyOf(path + "_button"))
            );
        }
    }
}
