package fr.hugman.artisanat.block.groups;

import fr.hugman.artisanat.block.helper.BlockBuilder;
import fr.hugman.artisanat.util.CustomRegisterable;
import java.util.*;
import net.minecraft.class_1767;
import net.minecraft.class_2248;

/**
 * Contains stained blocks and their slabs, stairs and walls variants.
 */
public record StainedBSSBlocks(Map<class_1767, BSSBlocks> colorMap) {
    public static Builder of(BlockBuilder baseBlock) {
        return new Builder(baseBlock);
    }

    public static Builder of(class_2248 baseBlock) {
        return of(new BlockBuilder(baseBlock));
    }

    public class_2248[] all() {
        List<class_2248> blocks = new ArrayList<>();
        for (BSSBlocks bssBlocks : colorMap.values()) {
            blocks.addAll(Arrays.asList(bssBlocks.all()));
        }
        return blocks.toArray(new class_2248[0]);
    }

    public static class Builder implements CustomRegisterable<StainedBSSBlocks> {
        private final BlockBuilder block;

        private Builder(BlockBuilder block) {
            this.block = block;
        }

        public StainedBSSBlocks register(String path) {
            var colorMap = new HashMap<class_1767, BSSBlocks>();
            for (class_1767 color : class_1767.values()) {
                String blockPath = color.method_7792() + "_" + path;
                colorMap.put(color, BSSBlocks.of(block).register(blockPath));
            }
            return new StainedBSSBlocks(colorMap);
        }
    }
}
