package fr.hugman.artisanat.block.groups;

import fr.hugman.artisanat.block.helper.BlockBuilder;
import fr.hugman.artisanat.util.CustomRegisterable;
import java.util.*;
import net.minecraft.class_1767;
import net.minecraft.class_2248;

/**
 * Contains stained blocks and their slabs, stairs and walls variants.
 */
public record StainedBSSWBlocks(Map<class_1767, BSSWBlocks> colorMap) {
    public static Builder of(BlockBuilder baseBlock) {
        return new Builder(baseBlock);
    }

    public static Builder of(class_2248 baseBlock) {
        return of(new BlockBuilder(baseBlock));
    }

    public class_2248[] all() {
        List<class_2248> blocks = new ArrayList<>();
        for (BSSWBlocks bsswBlocks : colorMap.values()) {
            blocks.addAll(Arrays.asList(bsswBlocks.all()));
        }
        return blocks.toArray(new class_2248[0]);
    }

    public static class Builder implements CustomRegisterable<StainedBSSWBlocks> {
        private final BlockBuilder block;

        private Builder(BlockBuilder block) {
            this.block = block;
        }

        public StainedBSSWBlocks register(String path) {
            var colorMap = new HashMap<class_1767, BSSWBlocks>();
            for (class_1767 color : class_1767.values()) {
                String blockPath = color.method_7792() + "_" + path;
                colorMap.put(color, BSSWBlocks.of(block).register(blockPath));
            }
            return new StainedBSSWBlocks(colorMap);
        }
    }

    public class_2248 get(class_1767 color) {
        return colorMap.get(color).block();
    }
}
