package fr.hugman.artisanat.block.groups;

import com.google.common.collect.ImmutableMap;
import fr.hugman.artisanat.util.CustomRegisterable;
import java.util.*;
import net.minecraft.class_1767;
import net.minecraft.class_2246;
import net.minecraft.class_2248;

public record StainedSSWPBBlocks(Map<class_1767, SSWPBBlocks> colorMap) {
    public static final Map<class_1767, class_2248> TERRACOTTA_MAP = ImmutableMap.<class_1767, class_2248>builder()
            .put(class_1767.field_7952, class_2246.field_10611)
            .put(class_1767.field_7946, class_2246.field_10184)
            .put(class_1767.field_7958, class_2246.field_10015)
            .put(class_1767.field_7951, class_2246.field_10325)
            .put(class_1767.field_7947, class_2246.field_10143)
            .put(class_1767.field_7961, class_2246.field_10014)
            .put(class_1767.field_7954, class_2246.field_10444)
            .put(class_1767.field_7944, class_2246.field_10349)
            .put(class_1767.field_7967, class_2246.field_10590)
            .put(class_1767.field_7955, class_2246.field_10235)
            .put(class_1767.field_7945, class_2246.field_10570)
            .put(class_1767.field_7966, class_2246.field_10409)
            .put(class_1767.field_7957, class_2246.field_10123)
            .put(class_1767.field_7942, class_2246.field_10526)
            .put(class_1767.field_7964, class_2246.field_10328)
            .put(class_1767.field_7963, class_2246.field_10626)
            .build();
    public static final Map<class_1767, class_2248> CONCRETE_MAP = ImmutableMap.<class_1767, class_2248>builder()
            .put(class_1767.field_7952, class_2246.field_10107)
            .put(class_1767.field_7946, class_2246.field_10210)
            .put(class_1767.field_7958, class_2246.field_10585)
            .put(class_1767.field_7951, class_2246.field_10242)
            .put(class_1767.field_7947, class_2246.field_10542)
            .put(class_1767.field_7961, class_2246.field_10421)
            .put(class_1767.field_7954, class_2246.field_10434)
            .put(class_1767.field_7944, class_2246.field_10038)
            .put(class_1767.field_7967, class_2246.field_10172)
            .put(class_1767.field_7955, class_2246.field_10308)
            .put(class_1767.field_7945, class_2246.field_10206)
            .put(class_1767.field_7966, class_2246.field_10011)
            .put(class_1767.field_7957, class_2246.field_10439)
            .put(class_1767.field_7942, class_2246.field_10367)
            .put(class_1767.field_7964, class_2246.field_10058)
            .put(class_1767.field_7963, class_2246.field_10458)
            .build();

    public static Builder of(Map<class_1767, class_2248> baseBlockColorMap) {
        return new Builder(baseBlockColorMap);
    }

    public static Builder terracotta() {
        return of(TERRACOTTA_MAP);
    }

    public static Builder concrete() {
        return of(CONCRETE_MAP);
    }

    public class_2248[] all() {
        List<class_2248> blocks = new ArrayList<>();
        for (SSWPBBlocks sswpbBlocks : colorMap.values()) {
            blocks.addAll(Arrays.asList(sswpbBlocks.all()));
        }
        return blocks.toArray(new class_2248[0]);
    }

    public static class Builder implements CustomRegisterable<StainedSSWPBBlocks> {
        private final Map<class_1767, class_2248> baseBlockColorMap;

        private Builder(Map<class_1767, class_2248> baseBlockColorMap) {
            this.baseBlockColorMap = baseBlockColorMap;
        }

        public StainedSSWPBBlocks register(String path) {
            var colorMap = new HashMap<class_1767, SSWPBBlocks>();
            for (class_1767 color : class_1767.values()) {
                String blockPath = color.method_7792() + "_" + path;
                colorMap.put(color, SSWPBBlocks.of(this.baseBlockColorMap.get(color)).register(blockPath));
            }
            return new StainedSSWPBBlocks(colorMap);
        }
    }
}
