package fr.hugman.artisanat.block.groups;

import fr.hugman.artisanat.block.ArtisanatBlocks;
import fr.hugman.artisanat.block.helper.BlockFactory;
import fr.hugman.artisanat.util.CustomRegisterable;
import net.minecraft.class_2248;
import net.minecraft.class_8177;

/**
 * Contains wood blocks in other shapes.
 */
public record WoodBlocks(
        class_2248 slab,
        class_2248 stairs,
        class_2248 button
) {
    /**
     * @param baseBlock block that MUST be registered
     * @param setType   the wood block set type
     */
    public static Builder of(class_2248 baseBlock, class_8177 setType) {
        return new Builder(baseBlock, setType);
    }

    public class_2248[] all() {
        return new class_2248[]{slab, stairs, button};
    }

    public static class Builder implements CustomRegisterable<WoodBlocks> {
        private final class_2248 baseBlock;
        private final class_8177 setType;

        private Builder(class_2248 baseBlock, class_8177 setType) {
            this.baseBlock = baseBlock;
            this.setType = setType;
        }

        public WoodBlocks register(String path) {
            return new WoodBlocks(
                    BlockFactory.slab(baseBlock).register(ArtisanatBlocks.keyOf(path + "_slab")),
                    BlockFactory.stairs(baseBlock).register(ArtisanatBlocks.keyOf(path + "_stairs")),
                    BlockFactory.woodenButton(baseBlock, setType).register(ArtisanatBlocks.keyOf(path + "_button"))
            );
        }
    }
}
