package fr.hugman.artisanat.block.helper;

import net.minecraft.block.*;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2269;
import net.minecraft.class_2323;
import net.minecraft.class_2349;
import net.minecraft.class_2354;
import net.minecraft.class_2440;
import net.minecraft.class_2482;
import net.minecraft.class_2510;
import net.minecraft.class_2533;
import net.minecraft.class_2544;
import net.minecraft.class_2766;
import net.minecraft.class_3619;
import net.minecraft.class_4719;
import net.minecraft.class_4970;
import net.minecraft.class_8177;
import java.util.function.Function;

public final class BlockFactory {
    public static BlockBuilder of(Function<class_4970.class_2251, class_2248> factory, class_4970.class_2251 settings) {
        return new BlockBuilder(factory, settings);
    }

    public static BlockBuilder of(class_4970.class_2251 settings) {
        return new BlockBuilder(settings);
    }

    public static BlockBuilder copy(class_2248 block) {
        return new BlockBuilder(block);
    }

    public static BlockBuilder slab(class_2248 baseBlock) {
        return copy(baseBlock).factory(class_2482::new);
    }

    public static BlockBuilder stairs(class_2248 baseBlock) {
        return copy(baseBlock).factory(s -> new class_2510(baseBlock.method_9564(), s));
    }

    public static BlockBuilder wall(class_2248 baseBlock) {
        return copy(baseBlock).factory(class_2544::new).settings(class_4970.class_2251.method_55226(baseBlock).method_51369());
    }

    public static BlockBuilder fence(class_2248 baseBlock) {
        return copy(baseBlock).factory(class_2354::new).settings(class_4970.class_2251.method_55226(baseBlock));
    }

    public static BlockBuilder fenceGate(class_2248 baseBlock, class_4719 woodType) {
        return copy(baseBlock).factory(s -> new class_2349(woodType, s)).settings(class_4970.class_2251.method_55226(baseBlock).method_51369());
    }

    public static BlockBuilder trapdoor(class_2248 baseBlock, class_8177 setType) {
        return copy(baseBlock).factory(s -> new class_2533(setType, s)).settings(class_4970.class_2251.method_55226(baseBlock)
                .method_9632(3.0f)
                .method_22488()
                .method_26235(class_2246::method_26114));
    }

    public static BlockBuilder door(class_2248 baseBlock, class_8177 setType) {
        return copy(baseBlock).factory(s -> new class_2323(setType, s)).settings(class_4970.class_2251.method_55226(baseBlock)
                .method_9632(3.0f)
                .method_22488()
                .method_50012(class_3619.field_15971));
    }

    public static BlockBuilder woodenButton(class_2248 baseBlock, class_8177 setType) {
        return copy(baseBlock).factory(s -> new class_2269(setType, 30, s)).settings(class_4970.class_2251.method_9637()
                .method_9632(0.5f)
                .method_9634()
                .method_50012(class_3619.field_15971)
                .method_9626(baseBlock.method_9564().method_26231()));
    }

    public static BlockBuilder stoneButton(class_2248 baseBlock, class_8177 setType) {
        return copy(baseBlock).factory(s -> new class_2269(setType, 30, s)).settings(class_4970.class_2251.method_9637()
                .method_9632(0.5f)
                .method_9634()
                .method_50012(class_3619.field_15971)
                .method_9626(baseBlock.method_9564().method_26231()));
    }

    public static BlockBuilder pressurePlate(class_2248 baseBlock, class_8177 setType) {
        return copy(baseBlock).factory(s -> new class_2440(setType, s)).settings(class_4970.class_2251.method_55226(baseBlock)
                .method_51369()
                .method_51368(class_2766.field_12653)
                .method_9632(0.5f)
                .method_50012(class_3619.field_15971)
                .method_29292()
                .method_9634());
    }
}
