package fr.hugman.artisanat.client.texture.atlas;

import com.google.common.base.Suppliers;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.ints.Int2IntMap;
import it.unimi.dsi.fastutil.ints.Int2IntOpenHashMap;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1011;
import net.minecraft.class_2960;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import net.minecraft.class_7764;
import net.minecraft.class_7771;
import net.minecraft.class_7948;
import net.minecraft.class_7958;
import net.minecraft.class_8684;
import net.minecraft.class_9848;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.IntUnaryOperator;
import java.util.function.Supplier;

@Environment(EnvType.CLIENT)
public record ArtisanatPalettedPermutationsAtlasSource(
		Map<class_2960, OutputIdentifier> textures,
		class_2960 paletteKey,
		Map<String, class_2960> permutations
) implements class_7948 {
	static final Logger LOGGER = LogUtils.getLogger();
	public static final MapCodec<ArtisanatPalettedPermutationsAtlasSource> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group(
			Codec.unboundedMap(class_2960.field_25139, OutputIdentifier.CODEC).fieldOf("textures").forGetter(source -> source.textures),
			class_2960.field_25139.fieldOf("palette_key").forGetter(source -> source.paletteKey),
			Codec.unboundedMap(Codec.STRING, class_2960.field_25139).fieldOf("permutations").forGetter(source -> source.permutations)
	).apply(instance, ArtisanatPalettedPermutationsAtlasSource::new));

	@Override
	public void method_47673(class_3300 resourceManager, class_7949 regions) {
		Supplier<int[]> supplier = Suppliers.memoize(() -> open(resourceManager, this.paletteKey));
		Map<String, Supplier<IntUnaryOperator>> map = new HashMap<>();
		this.permutations.forEach((key, texture) -> map.put(key, Suppliers.memoize(() -> toMapper(supplier.get(), open(resourceManager, texture)))));

		for (var textureOutput : this.textures.entrySet()) {
			var identifier = textureOutput.getKey();
			class_2960 identifier2 = class_7948.field_42075.method_45112(identifier);
			Optional<class_3298> optional = resourceManager.method_14486(identifier2);
			if (optional.isEmpty()) {
				LOGGER.warn("Unable to find texture {}", identifier2);
			} else {
				class_7958 atlasSprite = new class_7958(identifier2, optional.get(), map.size());

				for (Map.Entry<String, Supplier<IntUnaryOperator>> entry : map.entrySet()) {
					class_2960 identifier3 = textureOutput.getValue().apply(entry.getKey());
					regions.method_47670(identifier3, new PalettedSpriteRegion(atlasSprite, entry.getValue(), identifier3));
				}
			}
		}
	}

	private static IntUnaryOperator toMapper(int[] from, int[] to) {
		if (to.length != from.length) {
			LOGGER.warn("Palette mapping has different sizes: {} and {}", from.length, to.length);
			throw new IllegalArgumentException();
		} else {
			Int2IntMap int2IntMap = new Int2IntOpenHashMap(to.length);

			for (int i = 0; i < from.length; i++) {
				int j = from[i];
				if (class_9848.method_61320(j) != 0) {
					int2IntMap.put(class_9848.method_61335(j), to[i]);
				}
			}

			return color -> {
				int ix = class_9848.method_61320(color);
				if (ix == 0) {
					return color;
				} else {
					int jx = class_9848.method_61335(color);
					int k = int2IntMap.getOrDefault(jx, class_9848.method_61334(jx));
					int l = class_9848.method_61320(k);
					return class_9848.method_61330(ix * l / 255, k);
				}
			};
		}
	}

	private static int[] open(class_3300 resourceManager, class_2960 texture) {
		Optional<class_3298> optional = resourceManager.method_14486(field_42075.method_45112(texture));
		if (optional.isEmpty()) {
			LOGGER.error("Failed to load palette image {}", texture);
			throw new IllegalArgumentException();
		} else {
			try {
				InputStream inputStream = optional.get().method_14482();

				int[] var5;
				try (class_1011 nativeImage = class_1011.method_4309(inputStream)) {
					var5 = nativeImage.method_61942();
				} catch (Throwable var10) {
					if (inputStream != null) {
						try {
							inputStream.close();
						} catch (Throwable var7) {
							var10.addSuppressed(var7);
						}
					}

					throw var10;
				}

				if (inputStream != null) {
					inputStream.close();
				}

				return var5;
			} catch (Exception var11) {
				LOGGER.error("Couldn't load texture {}", texture, var11);
				throw new IllegalArgumentException();
			}
		}
	}

	@Override
	public MapCodec<? extends class_7948> method_67288() {
		return CODEC;
	}

	@Environment(EnvType.CLIENT)
	record PalettedSpriteRegion(
			class_7958 baseImage,
			Supplier<IntUnaryOperator> palette,
			class_2960 permutationLocation
	) implements class_7950 {
		@Nullable
		public class_7764 apply(class_8684 spriteOpener) {
			Object var3;
			try {
				class_1011 nativeImage = this.baseImage.method_47697().method_48462(this.palette.get());
				return new class_7764(
						this.permutationLocation, new class_7771(nativeImage.method_4307(), nativeImage.method_4323()), nativeImage
				);
			} catch (IllegalArgumentException | IOException var7) {
				ArtisanatPalettedPermutationsAtlasSource.LOGGER.error("unable to apply palette to {}", this.permutationLocation, var7);
				var3 = null;
			} finally {
				this.baseImage.method_47698();
			}

			return (class_7764) var3;
		}

		@Override
		public void method_47676() {
			this.baseImage.method_47698();
		}
	}
}