package fr.hugman.artisanat.itemgroup;

import fr.hugman.artisanat.block.ArtisanatBlocks;
import fr.hugman.artisanat.block.groups.*;
import net.fabricmc.fabric.api.itemgroup.v1.FabricItemGroupEntries;
import net.fabricmc.fabric.api.itemgroup.v1.ItemGroupEvents;
import net.minecraft.class_1767;
import net.minecraft.class_1935;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_5955;
import net.minecraft.class_7706;
import java.util.Map;

public class ArtisanatItemGroupAdditions {
    // The order is reversed for iterative purposes
    public static class_1767[] COLOR_ORDER = {
            class_1767.field_7954, class_1767.field_7958, class_1767.field_7945, class_1767.field_7966,
            class_1767.field_7951, class_1767.field_7955, class_1767.field_7942, class_1767.field_7961,
            class_1767.field_7947, class_1767.field_7946, class_1767.field_7964, class_1767.field_7957,
            class_1767.field_7963, class_1767.field_7944, class_1767.field_7967, class_1767.field_7952
    };

    public static void registerEvents() {
        ItemGroupEvents.modifyEntriesEvent(class_7706.field_40195).register(entries -> {
            add(entries, ArtisanatBlocks.OAK_WOOD_BLOCKS, class_2246.field_10126);
            add(entries, ArtisanatBlocks.SPRUCE_WOOD_BLOCKS, class_2246.field_10155);
            add(entries, ArtisanatBlocks.BIRCH_WOOD_BLOCKS, class_2246.field_10307);
            add(entries, ArtisanatBlocks.JUNGLE_WOOD_BLOCKS, class_2246.field_10303);
            add(entries, ArtisanatBlocks.ACACIA_WOOD_BLOCKS, class_2246.field_9999);
            add(entries, ArtisanatBlocks.CHERRY_WOOD_BLOCKS, class_2246.field_42733);
            add(entries, ArtisanatBlocks.DARK_OAK_WOOD_BLOCKS, class_2246.field_10178);
            add(entries, ArtisanatBlocks.PALE_OAK_WOOD_BLOCKS, class_2246.field_54734);
            add(entries, ArtisanatBlocks.MANGROVE_WOOD_BLOCKS, class_2246.field_37549);
            add(entries, ArtisanatBlocks.CRIMSON_HYPHAE_BLOCKS, class_2246.field_22505);
            add(entries, ArtisanatBlocks.WARPED_HYPHAE_BLOCKS, class_2246.field_22503);

            add(entries, ArtisanatBlocks.COBBLESTONE_BRICKS, class_2246.field_10625);
            add(entries, ArtisanatBlocks.MOSSY_COBBLESTONE_BRICKS, class_2246.field_9990);
            add(entries, ArtisanatBlocks.GRANITE_BRICKS, class_2246.field_10072);
            add(entries, ArtisanatBlocks.DIORITE_BRICKS, class_2246.field_10517);
            add(entries, ArtisanatBlocks.ANDESITE_BRICKS, class_2246.field_10489);
            add(entries, ArtisanatBlocks.SANDSTONE_BRICKS, class_2246.field_10630);
            add(entries, ArtisanatBlocks.POLISHED_SANDSTONE, class_2246.field_10262);
            add(entries, ArtisanatBlocks.RED_SANDSTONE_BRICKS, class_2246.field_10413);
            add(entries, ArtisanatBlocks.POLISHED_RED_SANDSTONE, class_2246.field_10283);
            add(entries, ArtisanatBlocks.SMOOTH_STONE_PAVING, class_2246.field_10136);
            add(entries, ArtisanatBlocks.CHISELED_PRISMARINE, class_2246.field_10530);
            add(entries, ArtisanatBlocks.PRISMARINE_BRICK_PAVING, class_2246.field_10236);
            add(entries, ArtisanatBlocks.BRICK_TILE_BLOCKS, class_2246.field_10269);
            entries.addAfter(class_2246.field_10623, ArtisanatBlocks.DARK_PRISMARINE_WALL);

            add(entries, ArtisanatBlocks.IRON_BLOCKS, class_2246.field_10085);
            add(entries, ArtisanatBlocks.GOLD_BLOCKS, class_2246.field_10205);
            add(entries, ArtisanatBlocks.REDSTONE_BLOCKS, class_2246.field_10002);
            add(entries, ArtisanatBlocks.LAPIS_BLOCKS, class_2246.field_10441);
            add(entries, ArtisanatBlocks.REDSTONE_BLOCKS, class_2246.field_10002);
            add(entries, ArtisanatBlocks.EMERALD_BLOCKS, class_2246.field_10234);
            add(entries, ArtisanatBlocks.DIAMOND_BLOCKS, class_2246.field_10201);
            add(entries, ArtisanatBlocks.NETHERITE_BLOCKS, class_2246.field_22108);
            addCopperBlocks(entries);
        });
        ItemGroupEvents.modifyEntriesEvent(class_7706.field_41059).register(entries -> {
            add(entries, ArtisanatBlocks.STAINED_BRICK_TILE_BLOCKS, class_2246.field_10393);
            add(entries, ArtisanatBlocks.STAINED_BRICK_BLOCKS, class_2246.field_10393);

            add(entries, ArtisanatBlocks.TERRACOTTA_BRICKS, class_2246.field_10444);
            add(entries, ArtisanatBlocks.STAINED_TERRACOTTA_BRICKS, ArtisanatBlocks.TERRACOTTA_BRICKS.wall());
            add(entries, ArtisanatBlocks.TERRACOTTA_BLOCKS, class_2246.field_10415);
            add(entries, ArtisanatBlocks.STAINED_TERRACOTTA_BLOCKS, StainedSSWPBBlocks.TERRACOTTA_MAP);
            add(entries, ArtisanatBlocks.STAINED_DARK_PRISMARINE_BLOCKS, class_2246.field_10522);

            add(entries, ArtisanatBlocks.CONCRETE_BRICKS, class_2246.field_10434);
            add(entries, ArtisanatBlocks.CONCRETE_BLOCKS, StainedSSWPBBlocks.CONCRETE_MAP);

            add(entries, ArtisanatBlocks.QUARTZ_PAVING_BLOCKS, class_2246.field_10522);
        });

    }

    private static void add(FabricItemGroupEntries entries, WoodBlocks woodBlocks, class_1935 baseBlock) {
        entries.addAfter(baseBlock, woodBlocks.all());
    }

    private static void add(FabricItemGroupEntries entries, BSSBlocks bss, class_1935 baseBlock) {
        entries.addAfter(baseBlock, bss.all());
    }

    private static void add(FabricItemGroupEntries entries, BSSWBlocks bssw, class_1935 baseBlock) {
        entries.addAfter(baseBlock, bssw.all());
    }

    private static void add(FabricItemGroupEntries entries, StainedBSSBlocks stainedBSSBlocks, class_1935 baseBlock) {
        for (class_1767 dyeColor : COLOR_ORDER) {
            BSSBlocks bss = stainedBSSBlocks.colorMap().get(dyeColor);
            if (bss != null) {
                add(entries, bss, baseBlock);
            }
        }
    }

    private static void add(FabricItemGroupEntries entries, StainedBSSWBlocks stainedBSSWBlocks, class_1935 baseBlock) {
        for (class_1767 dyeColor : COLOR_ORDER) {
            BSSWBlocks bssw = stainedBSSWBlocks.colorMap().get(dyeColor);
            if (bssw != null) {
                add(entries, bssw, baseBlock);
            }
        }
    }

    private static void add(FabricItemGroupEntries entries, SSWPBBlocks sswpb, class_1935 baseBlock) {
        entries.addAfter(baseBlock, sswpb.all());
    }

    public static void add(FabricItemGroupEntries entries, StainedSSWPBBlocks stainedSswpb, Map<class_1767, class_2248> colorMap) {
        stainedSswpb.colorMap().forEach((dyeColor, sswpBlocks) -> add(entries, sswpBlocks, colorMap.get(dyeColor)));
    }

    private static void add(FabricItemGroupEntries entries, OreBlocks oreBlocks, class_1935 baseBlock) {
        entries.addAfter(baseBlock, oreBlocks.all());
    }

    private static void addCopperBlocks(FabricItemGroupEntries entries) {
        class_5955.class_5811[] levels = class_5955.class_5811.values();

        // Unplated
        class_2248[] baseBlocks = {
                class_2246.field_27119, class_2246.field_27118, class_2246.field_27117, class_2246.field_27116,
                class_2246.field_27133, class_2246.field_27135, class_2246.field_27134, class_2246.field_33407
        };
        for (int i = 0; i < levels.length; i++) {
            entries.addAfter(baseBlocks[i], ArtisanatBlocks.UNPLATED_COPPER_BLOCKS.get(levels[i], false));
            entries.addAfter(baseBlocks[i + 4], ArtisanatBlocks.UNPLATED_COPPER_BLOCKS.get(levels[i], true));
        }

        // Bricks & Tiles
        class_2248[] chiseledBlocks = {
                class_2246.field_47057, class_2246.field_47056, class_2246.field_47055, class_2246.field_47054,
                class_2246.field_47061, class_2246.field_47060, class_2246.field_47059, class_2246.field_47058
        };
        for (int i = 0; i < levels.length; i++) {
            entries.addAfter(chiseledBlocks[i],
                    ArtisanatBlocks.COPPER_BRICKS.get(levels[i], false),
                    ArtisanatBlocks.COPPER_TILES.get(levels[i], false)
            );
            entries.addAfter(chiseledBlocks[i + 4],
                    ArtisanatBlocks.COPPER_BRICKS.get(levels[i], true),
                    ArtisanatBlocks.COPPER_TILES.get(levels[i], true)
            );
        }
    }
}
