/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscompat.api.client.widgets.map;

import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.material.MapColor;

public class ChunkImage {
    private final Level level;
    private final ChunkPos chunkPos;
    private final int yLevel;
    private DynamicTexture texture;

    public ChunkImage(Level level, ChunkPos chunk, int yLevel) {
        this.level = level;
        this.chunkPos = chunk;
        this.yLevel = yLevel;
    }

    public void bindTexture() {
        if (this.texture == null) {
            this.texture = new DynamicTexture(this.createImage());
        }
        RenderSystem.setShaderTexture((int)0, (int)this.texture.m_117963_());
    }

    public void dispose() {
        if (this.texture != null) {
            this.texture.close();
            this.texture = null;
        }
    }

    private NativeImage createImage() {
        int width = 16;
        int height = 16;
        NativeImage image = new NativeImage(NativeImage.Format.RGBA, 16, 16, false);
        int startX = this.chunkPos.m_45604_();
        int startZ = this.chunkPos.m_45605_();
        for (int x = 0; x < width; ++x) {
            for (int z = 0; z < height; ++z) {
                int westY;
                int northY;
                BlockPos pos;
                if (this.shouldDrawAtSameLayer()) {
                    pos = this.getFirstBlockGoingDown(startX + x, this.yLevel + 1, startZ + z);
                    northY = this.getFirstBlockGoingDown(startX + x, this.yLevel + 1, startZ + z - 1).m_123342_();
                    westY = this.getFirstBlockGoingDown(startX + x - 1, this.yLevel + 1, startZ + z).m_123342_();
                } else {
                    pos = this.level.m_5452_(Heightmap.Types.WORLD_SURFACE, new BlockPos(startX + x, 0, startZ + z)).m_7495_();
                    northY = this.level.m_6924_(Heightmap.Types.WORLD_SURFACE, pos.m_123341_(), pos.m_123343_() - 1) - 1;
                    westY = this.level.m_6924_(Heightmap.Types.WORLD_SURFACE, pos.m_123341_() - 1, pos.m_123343_()) - 1;
                }
                BlockState state = this.level.m_8055_(pos);
                MapColor color = state.m_284242_((BlockGetter)this.level, pos);
                int rgb = color == null ? MapColor.f_283808_.f_283871_ : color.f_283871_;
                int red = rgb >> 16 & 0xFF;
                int green = rgb >> 8 & 0xFF;
                int blue = rgb & 0xFF;
                if (pos.m_123342_() > northY && northY >= this.level.m_141937_() || pos.m_123342_() > westY && westY >= this.level.m_141937_()) {
                    if (red == 0 && green == 0 && blue == 0) {
                        red = 3;
                        green = 3;
                        blue = 3;
                    } else {
                        if (red > 0 && red < 3) {
                            red = 3;
                        }
                        if (green > 0 && green < 3) {
                            green = 3;
                        }
                        if (blue > 0 && blue < 3) {
                            blue = 3;
                        }
                        red = Math.min((int)((double)red / 0.7), 255);
                        green = Math.min((int)((double)green / 0.7), 255);
                        blue = Math.min((int)((double)blue / 0.7), 255);
                    }
                }
                if (pos.m_123342_() < northY && northY >= this.level.m_141937_() || pos.m_123342_() < westY && westY >= this.level.m_141937_()) {
                    red = Math.max((int)((double)red * 0.7), 0);
                    green = Math.max((int)((double)green * 0.7), 0);
                    blue = Math.max((int)((double)blue * 0.7), 0);
                }
                image.m_84988_(x, z, 0xFF000000 | blue << 16 | green << 8 | red);
            }
        }
        return image;
    }

    private BlockPos getFirstBlockGoingDown(int x, int y, int z) {
        BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos(x, y, z);
        while (this.level.m_46859_((BlockPos)pos) && pos.m_123342_() >= this.level.m_141937_()) {
            pos.m_142448_(pos.m_123342_() - 1);
        }
        return pos;
    }

    private boolean shouldDrawAtSameLayer() {
        return this.level.m_6042_().f_63856_();
    }
}

