/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscompat.api.client.widgets.map;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import io.github.lightman314.lightmanscompat.api.client.widgets.map.ChunkFrame;
import io.github.lightman314.lightmanscompat.api.client.widgets.map.ChunkImage;
import io.github.lightman314.lightmanscompat.api.client.widgets.map.IMapWidgetHandler;
import io.github.lightman314.lightmanscurrency.api.misc.client.rendering.EasyGuiGraphics;
import io.github.lightman314.lightmanscurrency.client.gui.easy.interfaces.ITooltipWidget;
import io.github.lightman314.lightmanscurrency.client.gui.widget.easy.EasyButton;
import io.github.lightman314.lightmanscurrency.util.VersionUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import org.joml.Matrix4f;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class MapChunkWidget
extends EasyButton
implements ITooltipWidget {
    public static final ResourceLocation WIDGETS = VersionUtil.modResource((String)"lcompat", (String)"textures/gui/ftbchunks/map_widgets.png");
    private final ChunkPos chunk;
    private final Function<ChunkPos, ChunkFrame> frame;
    private final Function<ChunkPos, List<Component>> tooltips;
    private final ChunkImage image;

    protected MapChunkWidget(Builder builder) {
        super((EasyButton.EasyButtonBuilder)builder);
        this.chunk = builder.chunk;
        this.frame = builder.frame;
        this.tooltips = builder.tooltips;
        this.image = new ChunkImage((Level)Minecraft.m_91087_().f_91073_, this.chunk, builder.yLevel);
    }

    protected void renderWidget(EasyGuiGraphics gui) {
        this.image.bindTexture();
        RenderSystem.setShader(GameRenderer::m_172817_);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        float x = this.m_252754_() + 1;
        float y = this.m_252907_() + 1;
        float width = 16.0f;
        float height = 16.0f;
        Matrix4f matrix = gui.getPose().m_85850_().m_252922_();
        Tesselator tesselator = Tesselator.m_85913_();
        BufferBuilder buffer = tesselator.m_85915_();
        buffer.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85817_);
        buffer.m_252986_(matrix, x, y + height, 0.0f).m_7421_(0.0f, 1.0f).m_5752_();
        buffer.m_252986_(matrix, x + width, y + height, 0.0f).m_7421_(1.0f, 1.0f).m_5752_();
        buffer.m_252986_(matrix, x + width, y, 0.0f).m_7421_(1.0f, 0.0f).m_5752_();
        buffer.m_252986_(matrix, x, y, 0.0f).m_7421_(0.0f, 0.0f).m_5752_();
        tesselator.m_85914_();
        ChunkFrame frame = this.frame.apply(this.chunk);
        int v = this.m_274382_() && this.m_142518_() ? 18 : 0;
        gui.blit(WIDGETS, 0, 0, frame.u, v, 18, 18);
    }

    public static Builder builder() {
        return new Builder();
    }

    public List<Component> getTooltipText() {
        return this.tooltips.apply(this.chunk);
    }

    public void discard() {
        this.image.dispose();
    }

    public static class Builder
    extends EasyButton.EasyButtonBuilder<Builder> {
        private ChunkPos chunk = new ChunkPos(0, 0);
        private int yLevel = 0;
        private Function<ChunkPos, ChunkFrame> frame = c -> ChunkFrame.NEUTRAL;
        private Function<ChunkPos, List<Component>> tooltips = c -> new ArrayList();
        private IMapWidgetHandler handler = (l, c) -> {};

        private Builder() {
            super(18, 18);
        }

        protected Builder getSelf() {
            return this;
        }

        public Builder withChunk(ChunkPos chunk) {
            this.chunk = chunk;
            return this;
        }

        public Builder withYLevel(int yLevel) {
            this.yLevel = yLevel;
            return this;
        }

        public Builder withFrame(Function<ChunkPos, ChunkFrame> frame) {
            this.frame = frame;
            return this;
        }

        public Builder withTooltips(Function<ChunkPos, List<Component>> tooltips) {
            this.tooltips = tooltips;
            return this;
        }

        public Builder withHandler(IMapWidgetHandler handler) {
            this.handler = handler;
            return this;
        }

        public MapChunkWidget build() {
            return new MapChunkWidget((Builder)((Builder)this.pressAction(() -> this.handler.handleMapSelection(true, this.chunk))).altPressAction(() -> this.handler.handleMapSelection(false, this.chunk)));
        }
    }
}

