/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscompat.ftbchunks;

import io.github.lightman314.lightmanscompat.api.claimshop.ClaimGroupData;
import io.github.lightman314.lightmanscompat.ftbchunks.claim_shop.notifications.LandPurchaseNotification;
import io.github.lightman314.lightmanscompat.ftbchunks.claim_shop.notifications.RentDueNotification;
import io.github.lightman314.lightmanscompat.ftbchunks.claim_shop.notifications.RentExpiredNotification;
import io.github.lightman314.lightmanscompat.ftbchunks.claim_shop.notifications.RentPaymentNotification;
import io.github.lightman314.lightmanscompat.ftbchunks.claim_shop.trader.ClaimShopData;
import io.github.lightman314.lightmanscompat.ftbchunks.client.FTBChunksClientEvents;
import io.github.lightman314.lightmanscompat.ftbchunks.client.FTBChunksClientModEvents;
import io.github.lightman314.lightmanscompat.ftbchunks.core.FTBChunksBlockEntities;
import io.github.lightman314.lightmanscompat.ftbchunks.core.FTBChunksBlocks;
import io.github.lightman314.lightmanscompat.ftbchunks.core.FTBChunksMenus;
import io.github.lightman314.lightmanscompat.ftbchunks.packets.CRequestClaimData;
import io.github.lightman314.lightmanscompat.ftbchunks.packets.SClaimDataReply;
import io.github.lightman314.lightmanscompat.ftbchunks.util.ClaimInteractionHandler;
import io.github.lightman314.lightmanscompat.network.LCompatPacketHandler;
import io.github.lightman314.lightmanscurrency.LightmansCurrency;
import io.github.lightman314.lightmanscurrency.ModCreativeGroups;
import io.github.lightman314.lightmanscurrency.api.notifications.NotificationAPI;
import io.github.lightman314.lightmanscurrency.api.traders.TraderAPI;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.BuildCreativeModeTabContentsEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.ParallelDispatchEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class FTBChunksNode {
    public static final Logger LOGGER = LogManager.getLogger();

    public static void setup(IEventBus bus, boolean isClient) {
        FTBChunksBlocks.init();
        FTBChunksBlockEntities.init();
        FTBChunksMenus.init();
        bus.addListener(FTBChunksNode::registerCreativeTabs);
        bus.addListener(FTBChunksNode::commonSetup);
        ClaimInteractionHandler.initialize();
        ClaimGroupData.init();
        if (isClient) {
            bus.register(FTBChunksClientModEvents.class);
            MinecraftForge.EVENT_BUS.register(FTBChunksClientEvents.class);
        }
        LCompatPacketHandler.registerNode(FTBChunksNode::registerPackets);
    }

    private static void registerCreativeTabs(BuildCreativeModeTabContentsEvent event) {
        if (event.getTab() == ModCreativeGroups.TRADER_GROUP.get()) {
            event.m_246326_((ItemLike)FTBChunksBlocks.CLAIM_SHOP.get());
        }
    }

    private static void commonSetup(FMLCommonSetupEvent event) {
        LightmansCurrency.safeEnqueueWork((ParallelDispatchEvent)event, (String)"Error during FTBChunks Compat common setup", () -> {
            TraderAPI.getApi().RegisterTrader(ClaimShopData.TYPE);
            NotificationAPI.getApi().RegisterNotification(LandPurchaseNotification.TYPE);
            NotificationAPI.getApi().RegisterNotification(RentPaymentNotification.TYPE);
            NotificationAPI.getApi().RegisterNotification(RentDueNotification.TYPE);
            NotificationAPI.getApi().RegisterNotification(RentExpiredNotification.TYPE);
        });
    }

    private static void registerPackets(LCompatPacketHandler.PacketRegistration registration) {
        registration.register(CRequestClaimData.class, CRequestClaimData.HANDLER);
        registration.register(SClaimDataReply.class, SClaimDataReply.HANDLER);
    }
}

