/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscompat.ftbchunks.claim_shop.notifications;

import io.github.lightman314.lightmanscompat.ftbchunks.FTBChunksText;
import io.github.lightman314.lightmanscurrency.api.misc.player.PlayerReference;
import io.github.lightman314.lightmanscurrency.api.money.value.MoneyValue;
import io.github.lightman314.lightmanscurrency.api.notifications.Notification;
import io.github.lightman314.lightmanscurrency.api.notifications.NotificationCategory;
import io.github.lightman314.lightmanscurrency.api.notifications.NotificationType;
import io.github.lightman314.lightmanscurrency.api.taxes.notifications.SingleLineTaxableNotification;
import io.github.lightman314.lightmanscurrency.common.notifications.categories.TraderCategory;
import io.github.lightman314.lightmanscurrency.util.VersionUtil;
import java.util.function.Supplier;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class LandPurchaseNotification
extends SingleLineTaxableNotification {
    public static final NotificationType<LandPurchaseNotification> TYPE = new NotificationType(VersionUtil.modResource((String)"lcompat", (String)"ftb_land_purchase"), LandPurchaseNotification::new);
    private PlayerReference player;
    private MoneyValue price;
    private TraderCategory category;

    private LandPurchaseNotification() {
    }

    protected LandPurchaseNotification(PlayerReference player, MoneyValue price, MoneyValue taxesPaid, TraderCategory category) {
        super(taxesPaid);
        this.player = player;
        this.price = price;
        this.category = category;
    }

    public static Supplier<Notification> of(PlayerReference player, MoneyValue price, MoneyValue taxesPaid, TraderCategory traderCategory) {
        return () -> new LandPurchaseNotification(player, price, taxesPaid, traderCategory);
    }

    protected Component getNormalMessage() {
        return FTBChunksText.NOTIFICATION_LAND_PURCHASE.get(new Object[]{this.player.getName(this.isClient()), this.price});
    }

    protected void saveNormal(CompoundTag tag) {
        tag.m_128365_("Player", (Tag)this.player.save());
        tag.m_128365_("Price", (Tag)this.price.save());
        tag.m_128365_("Category", (Tag)this.category.save());
    }

    protected void loadNormal(CompoundTag tag) {
        this.player = PlayerReference.load((CompoundTag)tag.m_128469_("Player"));
        this.price = MoneyValue.load((CompoundTag)tag.m_128469_("Price"));
        this.category = new TraderCategory(tag.m_128469_("Category"));
    }

    protected NotificationType<?> getType() {
        return TYPE;
    }

    public NotificationCategory getCategory() {
        return this.category;
    }

    protected boolean canMerge(Notification notification) {
        return false;
    }
}

