/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscompat.ftbchunks.claim_shop.notifications;

import io.github.lightman314.lightmanscompat.ftbchunks.FTBChunksText;
import io.github.lightman314.lightmanscurrency.api.notifications.Notification;
import io.github.lightman314.lightmanscurrency.api.notifications.NotificationCategory;
import io.github.lightman314.lightmanscurrency.api.notifications.NotificationType;
import io.github.lightman314.lightmanscurrency.api.notifications.SingleLineNotification;
import io.github.lightman314.lightmanscurrency.common.notifications.categories.TraderCategory;
import io.github.lightman314.lightmanscurrency.util.TimeUtil;
import io.github.lightman314.lightmanscurrency.util.VersionUtil;
import java.util.function.Supplier;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class RentDueNotification
extends SingleLineNotification {
    public static final NotificationType<RentDueNotification> TYPE = new NotificationType(VersionUtil.modResource((String)"lcompat", (String)"rent_due"), RentDueNotification::new);
    private long timeRemaining = 0L;
    private TraderCategory category;

    protected RentDueNotification() {
    }

    private RentDueNotification(long timeRemaining, TraderCategory trader) {
        this.timeRemaining = timeRemaining;
        this.category = trader;
    }

    public static Supplier<Notification> of(long timeRemaining, TraderCategory trader) {
        return () -> new RentDueNotification(timeRemaining, trader);
    }

    protected Component getMessage() {
        return FTBChunksText.NOTIFICATION_RENT_DUE.get(new Object[]{new TimeUtil.TimeData(this.timeRemaining).getString()});
    }

    protected NotificationType<?> getType() {
        return TYPE;
    }

    public NotificationCategory getCategory() {
        return this.category;
    }

    protected void saveAdditional(CompoundTag tag) {
        tag.m_128356_("TimeRemaining", this.timeRemaining);
        tag.m_128365_("Trader", (Tag)this.category.save());
    }

    protected void loadAdditional(CompoundTag tag) {
        this.timeRemaining = tag.m_128454_("TimeRemaining");
        this.category = new TraderCategory(tag.m_128469_("Trader"));
    }

    protected boolean canMerge(Notification notification) {
        return false;
    }
}

