/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscompat.ftbchunks.claim_shop.trader.client.menu.shop.tabs;

import io.github.lightman314.lightmanscompat.api.client.widgets.map.MapRegionWidget;
import io.github.lightman314.lightmanscompat.ftbchunks.FTBChunksText;
import io.github.lightman314.lightmanscompat.ftbchunks.claim_shop.trader.ClaimShopData;
import io.github.lightman314.lightmanscompat.ftbchunks.claim_shop.trader.client.menu.shop.ClaimShopClientTab;
import io.github.lightman314.lightmanscompat.ftbchunks.claim_shop.trader.client.menu.shop.ClaimShopMenuScreen;
import io.github.lightman314.lightmanscompat.ftbchunks.claim_shop.trader.menu.shop.ClaimShopMenu;
import io.github.lightman314.lightmanscompat.ftbchunks.claim_shop.trader.menu.shop.tabs.CustomerTab;
import io.github.lightman314.lightmanscompat.ftbchunks.util.FTBTeamHelper;
import io.github.lightman314.lightmanscompat.util.client.TooltipAddon;
import io.github.lightman314.lightmanscurrency.api.misc.EasyText;
import io.github.lightman314.lightmanscurrency.api.misc.client.rendering.EasyGuiGraphics;
import io.github.lightman314.lightmanscurrency.api.misc.icons.IconData;
import io.github.lightman314.lightmanscurrency.api.misc.icons.IconUtil;
import io.github.lightman314.lightmanscurrency.api.misc.player.PlayerReference;
import io.github.lightman314.lightmanscurrency.api.money.value.MoneyValue;
import io.github.lightman314.lightmanscurrency.api.traders.TradeContext;
import io.github.lightman314.lightmanscurrency.client.gui.easy.interfaces.IEasyScreen;
import io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.TraderScreen;
import io.github.lightman314.lightmanscurrency.client.gui.widget.button.trade.AlertData;
import io.github.lightman314.lightmanscurrency.client.gui.widget.easy.EasyAddonHelper;
import io.github.lightman314.lightmanscurrency.client.gui.widget.easy.EasyTextButton;
import io.github.lightman314.lightmanscurrency.client.util.ScreenArea;
import io.github.lightman314.lightmanscurrency.client.util.ScreenPosition;
import io.github.lightman314.lightmanscurrency.util.TimeUtil;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.level.ChunkPos;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class CustomerClientTab
extends ClaimShopClientTab<CustomerTab> {
    private final ScreenPosition INFO_WIDGET_POSITION = ScreenPosition.of((int)175, (int)160);

    public CustomerClientTab(Object screen, CustomerTab commonTab) {
        super(screen, commonTab);
    }

    protected void initialize(ScreenArea screenArea, boolean firstOpen) {
        ClaimShopData shop = ((ClaimShopMenu)this.menu).getTrader();
        if (shop != null) {
            MapRegionWidget w = (MapRegionWidget)((Object)this.addChild((Object)((MapRegionWidget.Builder)MapRegionWidget.builder().position(screenArea.pos.offset(22, 14))).withRadius(3).withCenterChunk(shop.getWorldPosition()).withSimpleFrame(this::isChunkSelected).build()));
            w.setActive(false);
        }
        this.addChild(((EasyTextButton.Builder)((EasyTextButton.Builder)((EasyTextButton.Builder)((EasyTextButton.Builder)((EasyTextButton.Builder)EasyTextButton.builder().position(screenArea.pos.offset(22, 140))).width(126)).text(this::tradeButtonText).pressAction(((CustomerTab)this.commonTab)::ExecuteTrade)).addon(TooltipAddon.tooltips(this::tradeButtonTooltip))).addon(EasyAddonHelper.activeCheck(this::allowTradeInteraction))).build());
    }

    public void renderBG(EasyGuiGraphics gui) {
        gui.blit(TraderScreen.GUI_TEXTURE, this.INFO_WIDGET_POSITION, 244, 0, 10, 10);
        ClaimShopData shop = ((ClaimShopMenu)this.menu).getTrader();
        gui.drawString((Component)(shop == null ? EasyText.empty() : shop.getTitle()), 4, 5, 0x404040);
        for (Slot slot : ((CustomerTab)this.commonTab).getMoneySlots()) {
            gui.renderSlot((IEasyScreen)this.screen, slot);
        }
        Component valueText = ((CustomerTab)this.commonTab).getContext(shop).getAvailableFunds().getRandomValueLine();
        gui.drawString(valueText, 185 - gui.font.m_92852_((FormattedText)valueText) - 10, ((ClaimShopMenuScreen)this.screen).getYSize() - 94, 0x404040);
    }

    public void renderAfterWidgets(EasyGuiGraphics gui) {
        if (this.INFO_WIDGET_POSITION.offset((IEasyScreen)this.screen).isMouseInArea(gui.mousePos, 10, 10)) {
            gui.renderComponentTooltip(((CustomerTab)this.commonTab).getContext(((ClaimShopMenu)this.menu).getTrader()).getAvailableFundsDescription());
        }
    }

    private boolean isChunkSelected(ChunkPos chunk) {
        ClaimShopData shop = ((ClaimShopMenu)this.menu).getTrader();
        return shop != null && shop.getChunkTargets().contains(chunk);
    }

    private Component tradeButtonText() {
        ClaimShopData shop = ((ClaimShopMenu)this.menu).getTrader();
        int chunkCount = shop == null ? 0 : shop.getChunkTargets().size();
        return shop != null && shop.isRentMode() ? FTBChunksText.BUTTON_CLAIM_SHOP_RENT.get(new Object[]{chunkCount}) : FTBChunksText.BUTTON_CLAIM_SHOP_PURCHASE.get(new Object[]{chunkCount});
    }

    private List<Component> tradeButtonTooltip() {
        ArrayList<Component> tooltip = new ArrayList<Component>();
        ClaimShopData shop = ((ClaimShopMenu)this.menu).getTrader();
        if (shop == null) {
            return tooltip;
        }
        List alerts = shop.runPreTradeEvent(shop.getTrade(), ((CustomerTab)this.commonTab).getContext(shop)).getAlertInfo();
        alerts.sort(AlertData::compare);
        MoneyValue price = shop.getTrade().getCost(((CustomerTab)this.commonTab).getContext(shop));
        if (shop.isRentMode()) {
            long timeRemaining;
            tooltip.add((Component)FTBChunksText.TOOLTIP_CLAIM_SHOP_RENT_PRICE.get(new Object[]{price.getText(), new TimeUtil.TimeData(shop.getRentDuration()).getShortString()}));
            PlayerReference renter = shop.getCustomer();
            if (shop.isCurrentlyRented() && renter != null && (timeRemaining = shop.rentTimeRemaining()) > 0L) {
                Component teamName = FTBTeamHelper.getPlayersTeamName(renter, true);
                if (teamName == null) {
                    teamName = renter.getNameComponent(true);
                }
                tooltip.add((Component)FTBChunksText.TOOLTIP_CLAIM_SHOP_RENT_STATUS.get(new Object[]{teamName, new TimeUtil.TimeData(timeRemaining).getShortString(2)}));
            }
        } else {
            tooltip.add((Component)FTBChunksText.TOOLTIP_CLAIM_SHOP_PURCHASE_PRICE.get(new Object[]{price.getText()}));
        }
        for (AlertData alert : alerts) {
            tooltip.add((Component)alert.getFormattedMessage());
        }
        return tooltip;
    }

    private boolean allowTradeInteraction() {
        ClaimShopData shop = ((ClaimShopMenu)this.menu).getTrader();
        if (shop == null) {
            return false;
        }
        TradeContext context = ((CustomerTab)this.commonTab).getContext(shop);
        if (shop.runPreTradeEvent(shop.getTrade(), context).isCanceled()) {
            return false;
        }
        MoneyValue price = shop.getTrade().getCost(context);
        return context.hasFunds(price);
    }

    public IconData getIcon() {
        return IconUtil.ICON_TRADER;
    }

    @Nullable
    public Component getTooltip() {
        return FTBChunksText.TOOLTIP_CLAIM_SHOP_CUSTOMER.get(new Object[0]);
    }
}

