/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscompat.ftbchunks.claim_shop.trader.settings;

import io.github.lightman314.lightmanscompat.ftbchunks.FTBChunksText;
import io.github.lightman314.lightmanscompat.ftbchunks.claim_shop.trader.ClaimShopData;
import io.github.lightman314.lightmanscurrency.api.money.value.MoneyValue;
import io.github.lightman314.lightmanscurrency.api.settings.data.LoadContext;
import io.github.lightman314.lightmanscurrency.api.settings.data.SavedSettingData;
import io.github.lightman314.lightmanscurrency.api.traders.TraderData;
import io.github.lightman314.lightmanscurrency.api.traders.settings.TraderSettingsNode;
import io.github.lightman314.lightmanscurrency.util.TimeUtil;
import java.util.HashSet;
import java.util.function.Consumer;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.level.ChunkPos;

public class ClaimTradeSettings
extends TraderSettingsNode<ClaimShopData> {
    public ClaimTradeSettings(ClaimShopData host) {
        super("trade", (TraderData)host);
    }

    public MutableComponent getName() {
        return FTBChunksText.DATA_CATEGORY_CLAIM_SHOP_TRADE.get(new Object[0]);
    }

    public boolean allowLoading(LoadContext context) {
        return context.hasPermission("editTrades");
    }

    public void saveSettings(SavedSettingData.MutableNodeAccess nodeAccess) {
        nodeAccess.setCompoundValue("price", ((ClaimShopData)this.trader).getPrice().save());
        ChunkPos centerChunk = new ChunkPos(((ClaimShopData)this.trader).getPos());
        int index = 0;
        for (ChunkPos chunk : ((ClaimShopData)this.trader).getChunkTargets()) {
            nodeAccess.setLongValue("chunk_" + index++, ClaimTradeSettings.getOffset(chunk, centerChunk).m_45588_());
        }
        nodeAccess.setBooleanValue("rent_mode", ((ClaimShopData)this.trader).isRentMode());
        nodeAccess.setLongValue("rent_duration", ((ClaimShopData)this.trader).getRentDuration());
        nodeAccess.setIntValue("rent_max_payments", ((ClaimShopData)this.trader).getMaxRentPayments());
    }

    private static ChunkPos getOffset(ChunkPos pos, ChunkPos center) {
        return new ChunkPos(pos.f_45578_ - center.f_45578_, pos.f_45579_ - center.f_45579_);
    }

    private static ChunkPos removeOffset(ChunkPos pos, ChunkPos center) {
        return new ChunkPos(pos.f_45578_ + center.f_45578_, pos.f_45579_ + center.f_45579_);
    }

    public void loadSettings(SavedSettingData.NodeAccess nodeAccess, LoadContext context) {
        MoneyValue price = MoneyValue.load((CompoundTag)nodeAccess.getCompoundValue("price"));
        if (price == null) {
            price = MoneyValue.empty();
        }
        ((ClaimShopData)this.trader).setPrice(price);
        if (!((ClaimShopData)this.trader).isLocked()) {
            ChunkPos center = new ChunkPos(((ClaimShopData)this.trader).getPos());
            HashSet<ChunkPos> targets = new HashSet<ChunkPos>();
            int index = 0;
            while (nodeAccess.hasLongValue("chunk_" + index)) {
                targets.add(ClaimTradeSettings.removeOffset(new ChunkPos(nodeAccess.getLongValue("chunk_" + index)), center));
            }
            ((ClaimShopData)this.trader).overrideChunkTargets(targets);
            ((ClaimShopData)this.trader).setRentMode(nodeAccess.getBooleanValue("rent_mode"));
            ((ClaimShopData)this.trader).setRentDuration(nodeAccess.getLongValue("rent_duration"));
            ((ClaimShopData)this.trader).setMaxRentPayments(nodeAccess.getIntValue("rent_max_payments"));
        }
    }

    protected void writeLines(SavedSettingData.NodeAccess nodeAccess, Consumer<Component> consumer) {
        MoneyValue price = MoneyValue.load((CompoundTag)nodeAccess.getCompoundValue("price"));
        consumer.accept((Component)ClaimTradeSettings.formatEntry((Component)FTBChunksText.DATA_ENTRY_CLAIM_SHOP_PRICE.get(new Object[0]), (String)(price == null ? "NULL" : price.getString())));
        int chunkCount = 0;
        while (nodeAccess.hasLongValue("chunk_" + chunkCount)) {
            ++chunkCount;
        }
        consumer.accept((Component)ClaimTradeSettings.formatEntry((Component)FTBChunksText.DATA_ENTRY_CLAIM_SHOP_CHUNKS.get(new Object[0]), (int)chunkCount));
        consumer.accept((Component)ClaimTradeSettings.formatEntry((Component)FTBChunksText.DATA_ENTRY_CLAIM_SHOP_RENT_MODE.get(new Object[0]), (boolean)nodeAccess.getBooleanValue("rent_mode")));
        consumer.accept((Component)ClaimTradeSettings.formatEntry((Component)FTBChunksText.DATA_ENTRY_CLAIM_SHOP_RENT_DURATION.get(new Object[0]), (String)new TimeUtil.TimeData(nodeAccess.getLongValue("rent_duration")).getShortString()));
        consumer.accept((Component)ClaimTradeSettings.formatEntry((Component)FTBChunksText.DATA_ENTRY_CLAIM_SHOP_RENT_MAX_PAYMENTS.get(new Object[0]), (int)nodeAccess.getIntValue("rent_max_payments")));
    }
}

