/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscompat.waystones;

import io.github.lightman314.lightmanscompat.waystones.WarpDistanceCache;
import io.github.lightman314.lightmanscompat.waystones.WaystonesNode;
import io.github.lightman314.lightmanscurrency.api.money.MoneyAPI;
import io.github.lightman314.lightmanscurrency.api.money.value.MoneyValue;
import io.github.lightman314.lightmanscurrency.api.money.value.holder.IMoneyHolder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.blay09.mods.waystones.api.IWaystone;
import net.blay09.mods.waystones.api.WaystoneTeleportEvent;
import net.blay09.mods.waystones.core.WarpMode;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public final class WaystonesEventListener {
    private static final Map<UUID, WarpDistanceCache> warpDistanceCache = new HashMap<UUID, WarpDistanceCache>();

    private WaystonesEventListener() {
    }

    @SubscribeEvent
    public static void beforeTeleport(WaystoneTeleportEvent.Pre event) {
        Entity entity = event.getContext().getEntity();
        if (entity instanceof Player) {
            Player player = (Player)entity;
            if (!player.m_150110_().f_35937_) {
                int leashed;
                WarpMode mode;
                IWaystone target = event.getContext().getTargetWaystone();
                MoneyValue price = WaystonesNode.calculatePrice(player, target, mode = event.getContext().getWarpMode(), leashed = event.getContext().getLeashedEntities().size());
                if (price.isEmpty()) {
                    return;
                }
                IMoneyHolder moneyHandler = MoneyAPI.getApi().GetPlayersMoneyHandler(player);
                if (!moneyHandler.getStoredMoney().containsValue(price)) {
                    event.setCanceled(true);
                } else {
                    warpDistanceCache.put(player.m_20148_(), new WarpDistanceCache(player, target));
                }
            }
        }
    }

    @SubscribeEvent
    public static void afterTeleport(WaystoneTeleportEvent.Post event) {
        Entity entity = event.getContext().getEntity();
        if (entity instanceof Player) {
            Player player = (Player)entity;
            if (!player.m_150110_().f_35937_) {
                MoneyValue price;
                WarpDistanceCache distanceData = warpDistanceCache.getOrDefault(player.m_20148_(), WarpDistanceCache.EMPTY);
                if (distanceData.isEmpty()) {
                    WaystonesNode.LOGGER.warn("Warp Distance was not cached for {}'s warp to {}", (Object)player.m_7755_().getString(), (Object)event.getContext().getTargetWaystone().getName());
                }
                if ((price = WaystonesNode.calculatePrice(event.getContext().getTargetWaystone(), event.getContext().getWarpMode(), event.getContext().getLeashedEntities().size(), distanceData)).isEmpty()) {
                    return;
                }
                IMoneyHolder moneyHandler = MoneyAPI.getApi().GetPlayersMoneyHandler(player);
                moneyHandler.extractMoney(price, false);
            }
        }
    }

    @SubscribeEvent
    public static void serverTick(TickEvent.ServerTickEvent event) {
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        if (event.getServer().m_129921_() % 1200 == 0) {
            ArrayList removeList = new ArrayList();
            warpDistanceCache.forEach((id, data) -> {
                if (data.saveData) {
                    data.saveData = false;
                } else {
                    removeList.add(id);
                }
            });
            for (UUID remove : removeList) {
                warpDistanceCache.remove(remove);
            }
        }
    }
}

