/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscompat.api.claimshop;

import io.github.lightman314.lightmanscompat.LCompat;
import io.github.lightman314.lightmanscompat.api.claimshop.IGroupableClaimTrader;
import io.github.lightman314.lightmanscurrency.api.misc.player.PlayerReference;
import io.github.lightman314.lightmanscurrency.api.traders.TraderAPI;
import io.github.lightman314.lightmanscurrency.api.traders.TraderData;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.server.ServerStoppedEvent;

public class ClaimGroupData {
    private static boolean initialized = false;
    private static final Map<String, Set<Long>> clientCache = new HashMap<String, Set<Long>>();
    private static final Map<String, Set<Long>> serverCache = new HashMap<String, Set<Long>>();

    public static void init() {
        if (initialized) {
            return;
        }
        NeoForge.EVENT_BUS.register(ClaimGroupData.class);
        initialized = true;
    }

    public static void updateCache(IGroupableClaimTrader trader, @Nullable String oldGroup) {
        String newGroup;
        Set<Long> set;
        long traderID;
        Map<String, Set<Long>> cache;
        Map<String, Set<Long>> map = cache = trader.isClient() ? clientCache : serverCache;
        if (trader instanceof TraderData) {
            TraderData t = (TraderData)trader;
            traderID = t.getID();
            if (traderID < 0L) {
                return;
            }
        } else {
            LCompat.LOGGER.error("Attempted to update the cache of a claim trader ({}) that isn't actually a trader!", (Object)trader.getClass().getName());
            return;
        }
        if (oldGroup != null && !oldGroup.isBlank() && (set = cache.get(oldGroup)) != null) {
            set.remove(traderID);
            if (set.isEmpty()) {
                cache.remove(oldGroup);
            }
        }
        if (!(newGroup = trader.getClaimGroup()).isBlank()) {
            Set set2 = cache.getOrDefault(newGroup, new HashSet());
            set2.add(traderID);
            cache.put(newGroup, set2);
        }
    }

    public static int getCountForGroup(IGroupableClaimTrader trader, PlayerReference customer) {
        return ClaimGroupData.getCountForGroup(trader.getClaimGroup(), customer, trader.isClient());
    }

    public static int getCountForGroup(String group, PlayerReference customer, boolean isClient) {
        if (group.isBlank()) {
            return 0;
        }
        Map<String, Set<Long>> cache = isClient ? clientCache : serverCache;
        int count = 0;
        HashSet<Long> removeIDs = new HashSet<Long>();
        Set cachedSet = cache.getOrDefault(group, new HashSet());
        Iterator iterator = cachedSet.iterator();
        while (iterator.hasNext()) {
            IGroupableClaimTrader shop;
            long traderID = (Long)iterator.next();
            TraderData t = TraderAPI.getApi().GetTrader(isClient, traderID);
            if (t instanceof IGroupableClaimTrader && (shop = (IGroupableClaimTrader)t).getClaimGroup().equals(group) && customer.is(shop.getCustomer())) {
                ++count;
                continue;
            }
            removeIDs.add(traderID);
        }
        cachedSet.removeAll(removeIDs);
        return count;
    }

    public static void clearClientCache() {
        clientCache.clear();
    }

    @SubscribeEvent
    public static void onServerStop(ServerStoppedEvent event) {
        serverCache.clear();
    }
}

